/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.decorator;

import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpClientFactory;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.TransportUtils;
import com.netflix.discovery.shared.transport.decorator.EurekaHttpClientDecorator;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Monitors;
import java.util.concurrent.atomic.AtomicReference;

public class SessionedEurekaHttpClient
extends EurekaHttpClientDecorator {
    private final EurekaHttpClientFactory clientFactory;
    private final long sessionDurationMs;
    private volatile long lastReconnectTimeStamp = -1L;
    private final AtomicReference<EurekaHttpClient> eurekaHttpClientRef = new AtomicReference();

    public SessionedEurekaHttpClient(EurekaHttpClientFactory clientFactory, long sessionDurationMs) {
        this.clientFactory = clientFactory;
        this.sessionDurationMs = sessionDurationMs;
        Monitors.registerObject((Object)this);
    }

    @Override
    protected <R> EurekaHttpResponse<R> execute(EurekaHttpClientDecorator.RequestExecutor<R> requestExecutor) {
        EurekaHttpClient eurekaHttpClient;
        long now = System.currentTimeMillis();
        long delay = now - this.lastReconnectTimeStamp;
        if (delay >= this.sessionDurationMs) {
            this.lastReconnectTimeStamp = now;
            TransportUtils.shutdown(this.eurekaHttpClientRef.getAndSet(null));
        }
        if ((eurekaHttpClient = this.eurekaHttpClientRef.get()) == null) {
            eurekaHttpClient = TransportUtils.getOrSetAnotherClient(this.eurekaHttpClientRef, this.clientFactory.newClient());
        }
        return requestExecutor.execute(eurekaHttpClient);
    }

    @Override
    public void shutdown() {
        Monitors.unregisterObject((Object)this);
        TransportUtils.shutdown(this.eurekaHttpClientRef.getAndSet(null));
    }

    @Monitor(name="eurekaClient.transport.currentSessionDuration", description="Duration of the current session", type=DataSourceType.GAUGE)
    public long getCurrentSessionDuration() {
        return this.lastReconnectTimeStamp < 0L ? 0L : System.currentTimeMillis() - this.lastReconnectTimeStamp;
    }
}

