/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.decorator;

import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpClientFactory;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.TransportException;
import com.netflix.discovery.shared.transport.TransportUtils;
import com.netflix.discovery.shared.transport.decorator.EurekaHttpClientDecorator;
import com.netflix.discovery.shared.transport.decorator.ServerStatusEvaluator;
import com.netflix.discovery.util.ServoUtil;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableEurekaHttpClient
extends EurekaHttpClientDecorator {
    private static final Logger logger = LoggerFactory.getLogger(RetryableEurekaHttpClient.class);
    public static final int DEFAULT_NUMBER_OF_RETRIES = 3;
    private final ClusterResolver clusterResolver;
    private final TransportClientFactory clientFactory;
    private final ServerStatusEvaluator serverStatusEvaluator;
    private final int numberOfRetries;
    private final AtomicReference<EurekaHttpClient> delegate = new AtomicReference();
    private final Set<EurekaEndpoint> quarantineSet = new ConcurrentSkipListSet<EurekaEndpoint>();
    private final Counter retryCounter;

    public RetryableEurekaHttpClient(ClusterResolver clusterResolver, TransportClientFactory clientFactory, ServerStatusEvaluator serverStatusEvaluator, int numberOfRetries) {
        this.clusterResolver = clusterResolver;
        this.clientFactory = clientFactory;
        this.serverStatusEvaluator = serverStatusEvaluator;
        this.numberOfRetries = numberOfRetries;
        this.retryCounter = new BasicCounter(MonitorConfig.builder((String)"eurekaClient.transport.retries").build());
        ServoUtil.register(this.retryCounter);
    }

    @Override
    public void shutdown() {
        TransportUtils.shutdown(this.delegate.get());
        ServoUtil.unregister(this.retryCounter);
    }

    @Override
    protected <R> EurekaHttpResponse<R> execute(EurekaHttpClientDecorator.RequestExecutor<R> requestExecutor) {
        List<EurekaEndpoint> candidateHosts = null;
        int endpointIdx = 0;
        for (int retry = 0; retry < this.numberOfRetries; ++retry) {
            EurekaHttpClient currentHttpClient = this.delegate.get();
            EurekaEndpoint currentEndpoint = null;
            if (currentHttpClient == null) {
                if (candidateHosts == null && (candidateHosts = this.getHostCandidates()).isEmpty()) {
                    throw new TransportException("There is no known eureka server; cluster server list is empty");
                }
                if (endpointIdx >= candidateHosts.size()) {
                    throw new TransportException("Cannot execute request on any known server");
                }
                currentEndpoint = candidateHosts.get(endpointIdx++);
                currentHttpClient = this.clientFactory.newClient(currentEndpoint);
            }
            try {
                EurekaHttpResponse<R> response = requestExecutor.execute(currentHttpClient);
                if (this.serverStatusEvaluator.accept(response.getStatusCode(), requestExecutor.getRequestType())) {
                    this.delegate.set(currentHttpClient);
                    return response;
                }
                logger.warn("Request execution failure with status code {}; retrying on another server if available", (Object)response.getStatusCode());
            }
            catch (Exception e) {
                logger.warn("Request execution failure", (Throwable)e);
            }
            this.delegate.compareAndSet(currentHttpClient, null);
            if (currentEndpoint == null) continue;
            this.quarantineSet.add(currentEndpoint);
        }
        throw new TransportException("Retry limit reached; giving up on completing the request");
    }

    public static EurekaHttpClientFactory createFactory(final ClusterResolver<EurekaEndpoint> clusterResolver, final TransportClientFactory delegateFactory, final ServerStatusEvaluator serverStatusEvaluator) {
        return new EurekaHttpClientFactory(){

            @Override
            public EurekaHttpClient newClient() {
                return new RetryableEurekaHttpClient(clusterResolver, delegateFactory, serverStatusEvaluator, 3);
            }

            @Override
            public void shutdown() {
                delegateFactory.shutdown();
            }
        };
    }

    private List<EurekaEndpoint> getHostCandidates() {
        List<EurekaEndpoint> candidateHosts = this.clusterResolver.getClusterEndpoints();
        this.quarantineSet.retainAll(candidateHosts);
        if (this.quarantineSet.size() == candidateHosts.size()) {
            this.quarantineSet.clear();
        } else if (!this.quarantineSet.isEmpty()) {
            ArrayList<EurekaEndpoint> remainingHosts = new ArrayList<EurekaEndpoint>(candidateHosts.size());
            for (EurekaEndpoint endpoint : candidateHosts) {
                if (this.quarantineSet.contains(endpoint)) continue;
                remainingHosts.add(endpoint);
            }
            candidateHosts = remainingHosts;
        }
        return candidateHosts;
    }
}

