/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.netflix.appinfo.InstanceInfo;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

class InstanceInfoJsonBeanSerializer
extends BeanSerializer {
    private static final Map<String, String> EMPTY_MAP = Collections.singletonMap("@class", "java.util.Collections$EmptyMap");
    private final ObjectMapper stringMapObjectMapper = new ObjectMapper();
    private final boolean compactMode;

    InstanceInfoJsonBeanSerializer(BeanSerializerBase src, boolean compactMode) {
        super(src);
        this.compactMode = compactMode;
    }

    protected void serializeFields(Object bean, JsonGenerator jgen0, SerializerProvider provider) throws IOException {
        super.serializeFields(bean, jgen0, provider);
        InstanceInfo instanceInfo = (InstanceInfo)bean;
        jgen0.writeFieldName("port");
        jgen0.writeStartObject();
        jgen0.writeNumberField("$", instanceInfo.getPort());
        jgen0.writeStringField("@enabled", Boolean.toString(instanceInfo.isPortEnabled(InstanceInfo.PortType.UNSECURE)));
        jgen0.writeEndObject();
        jgen0.writeFieldName("securePort");
        jgen0.writeStartObject();
        jgen0.writeNumberField("$", instanceInfo.getSecurePort());
        jgen0.writeStringField("@enabled", Boolean.toString(instanceInfo.isPortEnabled(InstanceInfo.PortType.SECURE)));
        jgen0.writeEndObject();
        if (!this.compactMode) {
            jgen0.writeFieldName("metadata");
            if (instanceInfo.getMetadata() == null || instanceInfo.getMetadata().isEmpty()) {
                this.stringMapObjectMapper.writeValue(jgen0, EMPTY_MAP);
            } else {
                this.stringMapObjectMapper.writeValue(jgen0, instanceInfo.getMetadata());
            }
        }
    }
}

