/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.endpoint;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.endpoint.DnsResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointUtils {
    private static final Logger logger = LoggerFactory.getLogger(EndpointUtils.class);
    public static final String DEFAULT_REGION = "default";
    public static final String DEFAULT_ZONE = "default";

    public static List<String> getDiscoveryServiceUrls(EurekaClientConfig clientConfig, String zone, ServiceUrlRandomizer randomizer) {
        boolean shouldUseDns = clientConfig.shouldUseDnsForFetchingServiceUrls();
        if (shouldUseDns) {
            return EndpointUtils.getServiceUrlsFromDNS(clientConfig, zone, clientConfig.shouldPreferSameZoneEureka(), randomizer);
        }
        return EndpointUtils.getServiceUrlsFromConfig(clientConfig, zone, clientConfig.shouldPreferSameZoneEureka());
    }

    public static List<String> getServiceUrlsFromDNS(EurekaClientConfig clientConfig, String instanceZone, boolean preferSameZone, ServiceUrlRandomizer randomizer) {
        String region = EndpointUtils.getRegion(clientConfig);
        Map<String, List<String>> zoneDnsNamesMap = EndpointUtils.getZoneBasedDiscoveryUrlsFromRegion(clientConfig, region);
        Set<String> availableZones = zoneDnsNamesMap.keySet();
        ArrayList<String> zones = new ArrayList<String>(availableZones);
        if (zones.isEmpty()) {
            throw new RuntimeException("No available zones configured for the instanceZone " + instanceZone);
        }
        int zoneIndex = 0;
        boolean zoneFound = false;
        for (String string : zones) {
            logger.debug("Checking if the instance zone {} is the same as the zone from DNS {}", (Object)instanceZone, (Object)string);
            if (preferSameZone) {
                if (instanceZone.equalsIgnoreCase(string)) {
                    zoneFound = true;
                }
            } else if (!instanceZone.equalsIgnoreCase(string)) {
                zoneFound = true;
            }
            if (zoneFound) {
                Object[] args = new Object[]{zones, instanceZone, zoneIndex};
                logger.debug("The zone index from the list {} that matches the instance zone {} is {}", args);
                break;
            }
            ++zoneIndex;
        }
        if (zoneIndex >= zones.size()) {
            logger.warn("No match for the zone {} in the list of available zones {}", (Object)instanceZone, (Object)Arrays.toString(zones.toArray()));
        } else {
            for (int i = 0; i < zoneIndex; ++i) {
                String string = (String)zones.remove(0);
                zones.add(string);
            }
        }
        ArrayList<String> serviceUrls = new ArrayList<String>();
        for (String zone : zones) {
            for (String zoneCname : zoneDnsNamesMap.get(zone)) {
                ArrayList<String> ec2Urls = new ArrayList<String>(EndpointUtils.getEC2DiscoveryUrlsFromZone(zoneCname, DiscoveryUrlType.CNAME));
                if (ec2Urls.size() > 1) {
                    randomizer.randomize(ec2Urls);
                }
                for (String ec2Url : ec2Urls) {
                    String serviceUrl = "http://" + ec2Url + ":" + clientConfig.getEurekaServerPort() + "/" + clientConfig.getEurekaServerURLContext() + "/";
                    logger.debug("The EC2 url is {}", (Object)serviceUrl);
                    serviceUrls.add(serviceUrl);
                }
            }
        }
        String string = (String)serviceUrls.remove(0);
        randomizer.randomize(serviceUrls);
        serviceUrls.add(0, string);
        logger.debug("This client will talk to the following serviceUrls in order : {} ", (Object)Arrays.toString(serviceUrls.toArray()));
        return serviceUrls;
    }

    public static List<String> getServiceUrlsFromConfig(EurekaClientConfig clientConfig, String instanceZone, boolean preferSameZone) {
        int currentOffset;
        ArrayList<String> orderedUrls = new ArrayList<String>();
        String region = EndpointUtils.getRegion(clientConfig);
        Object[] availZones = clientConfig.getAvailabilityZones(clientConfig.getRegion());
        if (availZones == null || availZones.length == 0) {
            availZones = new String[]{"default"};
        }
        logger.debug("The availability zone for the given region {} are {}", (Object)region, (Object)Arrays.toString(availZones));
        int myZoneOffset = EndpointUtils.getZoneOffset(instanceZone, preferSameZone, (String[])availZones);
        List<String> serviceUrls = clientConfig.getEurekaServerServiceUrls((String)availZones[myZoneOffset]);
        if (serviceUrls != null) {
            orderedUrls.addAll(serviceUrls);
        }
        int n = currentOffset = myZoneOffset == availZones.length - 1 ? 0 : myZoneOffset + 1;
        while (currentOffset != myZoneOffset) {
            serviceUrls = clientConfig.getEurekaServerServiceUrls((String)availZones[currentOffset]);
            if (serviceUrls != null) {
                orderedUrls.addAll(serviceUrls);
            }
            if (currentOffset == availZones.length - 1) {
                currentOffset = 0;
                continue;
            }
            ++currentOffset;
        }
        if (orderedUrls.size() < 1) {
            throw new IllegalArgumentException("DiscoveryClient: invalid serviceUrl specified!");
        }
        return orderedUrls;
    }

    public static Set<String> getEC2DiscoveryUrlsFromZone(String dnsName, DiscoveryUrlType type) {
        TreeSet<String> eipsForZone = null;
        try {
            dnsName = "txt." + dnsName;
            logger.debug("The zone url to be looked up is {} :", (Object)dnsName);
            Set<String> ec2UrlsForZone = DnsResolver.getCNamesFromTxtRecord(dnsName);
            for (String ec2Url : ec2UrlsForZone) {
                logger.debug("The eureka url for the dns name {} is {}", (Object)dnsName, (Object)ec2Url);
                ec2UrlsForZone.add(ec2Url);
            }
            if (DiscoveryUrlType.CNAME.equals((Object)type)) {
                return ec2UrlsForZone;
            }
            eipsForZone = new TreeSet<String>();
            for (String cname : ec2UrlsForZone) {
                String[] tokens = cname.split("\\.");
                String ec2HostName = tokens[0];
                String[] ips = ec2HostName.split("-");
                StringBuilder eipBuffer = new StringBuilder();
                for (int ipCtr = 1; ipCtr < 5; ++ipCtr) {
                    eipBuffer.append(ips[ipCtr]);
                    if (ipCtr >= 4) continue;
                    eipBuffer.append(".");
                }
                eipsForZone.add(eipBuffer.toString());
            }
            logger.debug("The EIPS for {} is {} :", (Object)dnsName, eipsForZone);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot get cnames bound to the region:" + dnsName, e);
        }
        return eipsForZone;
    }

    public static Map<String, List<String>> getZoneBasedDiscoveryUrlsFromRegion(EurekaClientConfig clientConfig, String region) {
        String discoveryDnsName = null;
        try {
            discoveryDnsName = "txt." + region + "." + clientConfig.getEurekaServerDNSName();
            logger.debug("The region url to be looked up is {} :", (Object)discoveryDnsName);
            TreeSet<String> zoneCnamesForRegion = new TreeSet<String>(DnsResolver.getCNamesFromTxtRecord(discoveryDnsName));
            TreeMap<String, List<String>> zoneCnameMapForRegion = new TreeMap<String, List<String>>();
            for (String zoneCname : zoneCnamesForRegion) {
                String zone = null;
                if (EndpointUtils.isEC2Url(zoneCname)) {
                    throw new RuntimeException("Cannot find the right DNS entry for " + discoveryDnsName + ". " + "Expected mapping of the format <aws_zone>.<domain_name>");
                }
                String[] cnameTokens = zoneCname.split("\\.");
                zone = cnameTokens[0];
                logger.debug("The zoneName mapped to region {} is {}", (Object)region, (Object)zone);
                ArrayList<String> zoneCnamesSet = (ArrayList<String>)zoneCnameMapForRegion.get(zone);
                if (zoneCnamesSet == null) {
                    zoneCnamesSet = new ArrayList<String>();
                    zoneCnameMapForRegion.put(zone, zoneCnamesSet);
                }
                zoneCnamesSet.add(zoneCname);
            }
            return zoneCnameMapForRegion;
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot get cnames bound to the region:" + discoveryDnsName, e);
        }
    }

    public static String getRegion(EurekaClientConfig clientConfig) {
        String region = clientConfig.getRegion();
        if (region == null) {
            region = "default";
        }
        region = region.trim().toLowerCase();
        return region;
    }

    private static boolean isEC2Url(String zoneCname) {
        return zoneCname.startsWith("ec2");
    }

    private static int getZoneOffset(String myZone, boolean preferSameZone, String[] availZones) {
        for (int i = 0; i < availZones.length; ++i) {
            if (myZone == null || availZones[i].equalsIgnoreCase(myZone.trim()) != preferSameZone) continue;
            return i;
        }
        logger.warn("DISCOVERY: Could not pick a zone based on preferred zone settings. My zone - {}, preferSameZone- {}. Defaulting to " + availZones[0], (Object)myZone, (Object)preferSameZone);
        return 0;
    }

    public static class InstanceInfoBasedUrlRandomizer
    implements ServiceUrlRandomizer {
        private final InstanceInfo instanceInfo;

        public InstanceInfoBasedUrlRandomizer(InstanceInfo instanceInfo) {
            this.instanceInfo = instanceInfo;
        }

        @Override
        public void randomize(List<String> urlList) {
            int listSize = 0;
            if (urlList != null) {
                listSize = urlList.size();
            }
            if (this.instanceInfo == null || listSize == 0) {
                return;
            }
            int instanceHashcode = this.instanceInfo.getHostName().hashCode();
            if (instanceHashcode < 0) {
                instanceHashcode *= -1;
            }
            int backupInstance = instanceHashcode % listSize;
            for (int i = 0; i < backupInstance; ++i) {
                String zone = urlList.remove(0);
                urlList.add(zone);
            }
        }
    }

    public static interface ServiceUrlRandomizer {
        public void randomize(List<String> var1);
    }

    public static enum DiscoveryUrlType {
        CNAME,
        A;

    }
}

