/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.converters.KeyFormatter;
import com.netflix.discovery.converters.jackson.AbstractEurekaJacksonCodec;
import com.netflix.discovery.converters.jackson.EurekaJacksonJsonModifiers;
import com.netflix.discovery.converters.jackson.mixin.InstanceInfoJsonMixIn;

public class EurekaJsonJacksonCodec
extends AbstractEurekaJacksonCodec {
    private final ObjectMapper jsonMapper = new ObjectMapper();

    public EurekaJsonJacksonCodec() {
        this(KeyFormatter.defaultKeyFormatter(), false);
    }

    public EurekaJsonJacksonCodec(KeyFormatter keyFormatter, boolean compact) {
        SimpleModule jsonModule = new SimpleModule();
        jsonModule.setSerializerModifier(EurekaJacksonJsonModifiers.createJsonSerializerModifier(keyFormatter, compact));
        jsonModule.setDeserializerModifier(EurekaJacksonJsonModifiers.createJsonDeserializerModifier(keyFormatter, compact));
        this.jsonMapper.registerModule((Module)jsonModule);
        this.jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        this.jsonMapper.configure(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED, false);
        this.jsonMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        this.jsonMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        if (compact) {
            this.addMiniConfig(this.jsonMapper);
        } else {
            this.jsonMapper.addMixIn(InstanceInfo.class, InstanceInfoJsonMixIn.class);
        }
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.jsonMapper;
    }
}

