/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.util.EurekaEntityTransformers;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class EurekaEntityFunctions {
    private EurekaEntityFunctions() {
    }

    public static Set<String> selectApplicationNames(Applications applications) {
        HashSet<String> result = new HashSet<String>();
        for (Application app : applications.getRegisteredApplications()) {
            result.add(app.getName());
        }
        return result;
    }

    public static Map<String, InstanceInfo> selectInstancesMappedById(Application application) {
        HashMap<String, InstanceInfo> result = new HashMap<String, InstanceInfo>();
        for (InstanceInfo instance : application.getInstances()) {
            result.put(instance.getId(), instance);
        }
        return result;
    }

    public static InstanceInfo selectInstance(Applications applications, String id) {
        for (Application application : applications.getRegisteredApplications()) {
            for (InstanceInfo instance : application.getInstances()) {
                if (!instance.getId().equals(id)) continue;
                return instance;
            }
        }
        return null;
    }

    public static InstanceInfo selectInstance(Applications applications, String appName, String id) {
        Application application = applications.getRegisteredApplications(appName);
        if (application != null) {
            for (InstanceInfo instance : application.getInstances()) {
                if (!instance.getId().equals(id)) continue;
                return instance;
            }
        }
        return null;
    }

    public static Map<String, Application> toApplicationMap(List<InstanceInfo> instances) {
        HashMap<String, Application> applicationMap = new HashMap<String, Application>();
        for (InstanceInfo instance : instances) {
            String appName = instance.getAppName();
            Application application = (Application)applicationMap.get(appName);
            if (application == null) {
                application = new Application(appName);
                applicationMap.put(appName, application);
            }
            application.addInstance(instance);
        }
        return applicationMap;
    }

    public static Applications toApplications(Map<String, Application> applicationMap) {
        Applications applications = new Applications();
        for (Application application : applicationMap.values()) {
            applications.addApplication(application);
        }
        return EurekaEntityFunctions.updateMeta(applications);
    }

    public static Applications toApplications(InstanceInfo ... instances) {
        return EurekaEntityFunctions.toApplications(Arrays.asList(instances));
    }

    public static Applications toApplications(List<InstanceInfo> instances) {
        Applications result = new Applications();
        for (InstanceInfo instance : instances) {
            Application app = result.getRegisteredApplications(instance.getAppName());
            if (app == null) {
                app = new Application(instance.getAppName());
                result.addApplication(app);
            }
            app.addInstance(instance);
        }
        return EurekaEntityFunctions.updateMeta(result);
    }

    public static Applications copyApplications(Applications source) {
        Applications result = new Applications();
        EurekaEntityFunctions.copyApplications(source, result);
        return EurekaEntityFunctions.updateMeta(result);
    }

    public static void copyApplications(Applications source, Applications result) {
        if (source != null) {
            for (Application app : source.getRegisteredApplications()) {
                result.addApplication(new Application(app.getName(), app.getInstances()));
            }
        }
    }

    public static Application copyApplication(Application application) {
        Application copy = new Application(application.getName());
        for (InstanceInfo instance : application.getInstances()) {
            copy.addInstance(instance);
        }
        return copy;
    }

    public static void copyApplication(Application source, Application result) {
        if (source != null) {
            for (InstanceInfo instance : source.getInstances()) {
                result.addInstance(instance);
            }
        }
    }

    public static void copyInstances(List<InstanceInfo> instances, Applications result) {
        if (instances != null) {
            for (InstanceInfo instance : instances) {
                Application app = result.getRegisteredApplications(instance.getAppName());
                if (app == null) {
                    app = new Application(instance.getAppName());
                    result.addApplication(app);
                }
                app.addInstance(instance);
            }
        }
    }

    public static InstanceInfo copyInstance(InstanceInfo original, InstanceInfo.ActionType actionType) {
        InstanceInfo copy = new InstanceInfo(original);
        copy.setActionType(actionType);
        return copy;
    }

    public static void deepCopyApplication(Application source, Application result, EurekaEntityTransformers.Transformer<InstanceInfo> transformer) {
        for (InstanceInfo instance : source.getInstances()) {
            InstanceInfo copy = transformer.apply(instance);
            if (copy == instance) {
                copy = new InstanceInfo(instance);
            }
            result.addInstance(copy);
        }
    }

    public static Application deepCopyApplication(Application source) {
        Application result = new Application(source.getName());
        EurekaEntityFunctions.deepCopyApplication(source, result, EurekaEntityTransformers.identity());
        return result;
    }

    public static Applications deepCopyApplications(Applications source) {
        Applications result = new Applications();
        for (Application application : source.getRegisteredApplications()) {
            result.addApplication(EurekaEntityFunctions.deepCopyApplication(application));
        }
        return EurekaEntityFunctions.updateMeta(result);
    }

    public static Applications mergeApplications(Applications first, Applications second) {
        Set<String> firstNames = EurekaEntityFunctions.selectApplicationNames(first);
        Set<String> secondNames = EurekaEntityFunctions.selectApplicationNames(second);
        HashSet<String> allNames = new HashSet<String>(firstNames);
        allNames.addAll(secondNames);
        Applications merged = new Applications();
        for (String appName : allNames) {
            if (firstNames.contains(appName)) {
                if (secondNames.contains(appName)) {
                    merged.addApplication(EurekaEntityFunctions.mergeApplication(first.getRegisteredApplications(appName), second.getRegisteredApplications(appName)));
                    continue;
                }
                merged.addApplication(EurekaEntityFunctions.copyApplication(first.getRegisteredApplications(appName)));
                continue;
            }
            merged.addApplication(EurekaEntityFunctions.copyApplication(second.getRegisteredApplications(appName)));
        }
        return EurekaEntityFunctions.updateMeta(merged);
    }

    public static Application mergeApplication(Application first, Application second) {
        if (!first.getName().equals(second.getName())) {
            throw new IllegalArgumentException("Cannot merge applications with different names");
        }
        Application merged = EurekaEntityFunctions.copyApplication(first);
        for (InstanceInfo instance : second.getInstances()) {
            switch (instance.getActionType()) {
                case ADDED: 
                case MODIFIED: {
                    merged.addInstance(instance);
                    break;
                }
                case DELETED: {
                    merged.removeInstance(instance);
                }
            }
        }
        return merged;
    }

    public static Applications updateMeta(Applications applications) {
        applications.setVersion(1L);
        applications.setAppsHashCode(applications.getReconcileHashCode());
        return applications;
    }

    public static int countInstances(Applications applications) {
        int count = 0;
        for (Application application : applications.getRegisteredApplications()) {
            count += application.getInstances().size();
        }
        return count;
    }
}

