/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.wrappers;

import com.netflix.appinfo.EurekaAccept;
import com.netflix.discovery.converters.EurekaJacksonCodec;
import com.netflix.discovery.converters.JsonXStream;
import com.netflix.discovery.converters.KeyFormatter;
import com.netflix.discovery.converters.XmlXStream;
import com.netflix.discovery.converters.jackson.EurekaJsonJacksonCodec;
import com.netflix.discovery.converters.jackson.EurekaXmlJacksonCodec;
import com.netflix.discovery.converters.wrappers.CodecWrapperBase;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderDecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MediaType;

public final class CodecWrappers {
    private static final Map<String, EncoderDecoderWrapper> CODECS = new ConcurrentHashMap<String, EncoderDecoderWrapper>();

    public static void registerWrapper(EncoderDecoderWrapper wrapper) {
        CODECS.put(wrapper.codecName(), wrapper);
    }

    public static <T extends CodecWrapperBase> String getCodecName(Class<T> clazz) {
        return clazz.getSimpleName();
    }

    public static <T extends EncoderWrapper> EncoderWrapper getEncoder(Class<T> clazz) {
        return CodecWrappers.getEncoder(CodecWrappers.getCodecName(clazz));
    }

    public static synchronized EncoderWrapper getEncoder(String name) {
        EncoderDecoderWrapper wrapper;
        if (name == null) {
            return null;
        }
        if (!CODECS.containsKey(name) && (wrapper = CodecWrappers.create(name)) != null) {
            CODECS.put(wrapper.codecName(), wrapper);
        }
        return CODECS.get(name);
    }

    public static <T extends DecoderWrapper> DecoderWrapper getDecoder(Class<T> clazz) {
        return CodecWrappers.getDecoder(CodecWrappers.getCodecName(clazz));
    }

    public static synchronized DecoderWrapper resolveDecoder(String name, String eurekaAccept) {
        EurekaAccept accept = EurekaAccept.fromString(eurekaAccept);
        switch (accept) {
            case compact: {
                return CodecWrappers.getDecoder(JacksonJsonMini.class);
            }
        }
        return CodecWrappers.getDecoder(name);
    }

    public static synchronized DecoderWrapper getDecoder(String name) {
        EncoderDecoderWrapper wrapper;
        if (name == null) {
            return null;
        }
        if (!CODECS.containsKey(name) && (wrapper = CodecWrappers.create(name)) != null) {
            CODECS.put(wrapper.codecName(), wrapper);
        }
        return CODECS.get(name);
    }

    private static EncoderDecoderWrapper create(String name) {
        if (CodecWrappers.getCodecName(JacksonJson.class).equals(name)) {
            return new JacksonJson();
        }
        if (CodecWrappers.getCodecName(JacksonJsonMini.class).equals(name)) {
            return new JacksonJsonMini();
        }
        if (CodecWrappers.getCodecName(LegacyJacksonJson.class).equals(name)) {
            return new LegacyJacksonJson();
        }
        if (CodecWrappers.getCodecName(XStreamJson.class).equals(name)) {
            return new XStreamJson();
        }
        if (CodecWrappers.getCodecName(JacksonXml.class).equals(name)) {
            return new JacksonXml();
        }
        if (CodecWrappers.getCodecName(JacksonXmlMini.class).equals(name)) {
            return new JacksonXmlMini();
        }
        if (CodecWrappers.getCodecName(XStreamXml.class).equals(name)) {
            return new XStreamXml();
        }
        return null;
    }

    public static class XStreamXml
    implements EncoderDecoderWrapper {
        protected final XmlXStream codec = XmlXStream.getInstance();

        @Override
        public String codecName() {
            return CodecWrappers.getCodecName(this.getClass());
        }

        @Override
        public boolean support(MediaType mediaType) {
            return mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE);
        }

        @Override
        public <T> String encode(T object) throws IOException {
            return this.codec.toXML(object);
        }

        @Override
        public <T> void encode(T object, OutputStream outputStream) throws IOException {
            this.codec.toXML(object, outputStream);
        }

        @Override
        public <T> T decode(String textValue, Class<T> type) throws IOException {
            return (T)this.codec.fromXML(textValue, type);
        }

        @Override
        public <T> T decode(InputStream inputStream, Class<T> type) throws IOException {
            return (T)this.codec.fromXML(inputStream, type);
        }
    }

    public static class XStreamJson
    implements EncoderDecoderWrapper {
        protected final JsonXStream codec = JsonXStream.getInstance();

        @Override
        public String codecName() {
            return CodecWrappers.getCodecName(this.getClass());
        }

        @Override
        public boolean support(MediaType mediaType) {
            return mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE);
        }

        @Override
        public <T> String encode(T object) throws IOException {
            return this.codec.toXML(object);
        }

        @Override
        public <T> void encode(T object, OutputStream outputStream) throws IOException {
            this.codec.toXML(object, outputStream);
        }

        @Override
        public <T> T decode(String textValue, Class<T> type) throws IOException {
            return (T)this.codec.fromXML(textValue, type);
        }

        @Override
        public <T> T decode(InputStream inputStream, Class<T> type) throws IOException {
            return (T)this.codec.fromXML(inputStream, type);
        }
    }

    public static class LegacyJacksonJson
    implements EncoderDecoderWrapper {
        protected final EurekaJacksonCodec codec = new EurekaJacksonCodec();

        @Override
        public String codecName() {
            return CodecWrappers.getCodecName(this.getClass());
        }

        @Override
        public boolean support(MediaType mediaType) {
            return mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE);
        }

        @Override
        public <T> String encode(T object) throws IOException {
            return this.codec.writeToString(object);
        }

        @Override
        public <T> void encode(T object, OutputStream outputStream) throws IOException {
            this.codec.writeTo(object, outputStream);
        }

        @Override
        public <T> T decode(String textValue, Class<T> type) throws IOException {
            return this.codec.readValue(type, textValue);
        }

        @Override
        public <T> T decode(InputStream inputStream, Class<T> type) throws IOException {
            return this.codec.readValue(type, inputStream);
        }
    }

    public static class JacksonXmlMini
    implements EncoderDecoderWrapper {
        protected final EurekaXmlJacksonCodec codec = new EurekaXmlJacksonCodec(KeyFormatter.defaultKeyFormatter(), true);

        @Override
        public String codecName() {
            return CodecWrappers.getCodecName(this.getClass());
        }

        @Override
        public boolean support(MediaType mediaType) {
            return mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE);
        }

        @Override
        public <T> String encode(T object) throws IOException {
            return this.codec.getObjectMapper().writeValueAsString(object);
        }

        @Override
        public <T> void encode(T object, OutputStream outputStream) throws IOException {
            this.codec.writeTo(object, outputStream);
        }

        @Override
        public <T> T decode(String textValue, Class<T> type) throws IOException {
            return (T)this.codec.getObjectMapper().readValue(textValue, type);
        }

        @Override
        public <T> T decode(InputStream inputStream, Class<T> type) throws IOException {
            return (T)this.codec.getObjectMapper().readValue(inputStream, type);
        }
    }

    public static class JacksonXml
    implements EncoderDecoderWrapper {
        protected final EurekaXmlJacksonCodec codec = new EurekaXmlJacksonCodec();

        @Override
        public String codecName() {
            return CodecWrappers.getCodecName(this.getClass());
        }

        @Override
        public boolean support(MediaType mediaType) {
            return mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE);
        }

        @Override
        public <T> String encode(T object) throws IOException {
            return this.codec.getObjectMapper().writeValueAsString(object);
        }

        @Override
        public <T> void encode(T object, OutputStream outputStream) throws IOException {
            this.codec.writeTo(object, outputStream);
        }

        @Override
        public <T> T decode(String textValue, Class<T> type) throws IOException {
            return (T)this.codec.getObjectMapper().readValue(textValue, type);
        }

        @Override
        public <T> T decode(InputStream inputStream, Class<T> type) throws IOException {
            return (T)this.codec.getObjectMapper().readValue(inputStream, type);
        }
    }

    public static class JacksonJsonMini
    implements EncoderDecoderWrapper {
        protected final EurekaJsonJacksonCodec codec = new EurekaJsonJacksonCodec(KeyFormatter.defaultKeyFormatter(), true);

        @Override
        public String codecName() {
            return CodecWrappers.getCodecName(this.getClass());
        }

        @Override
        public boolean support(MediaType mediaType) {
            return mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE);
        }

        @Override
        public <T> String encode(T object) throws IOException {
            return this.codec.getObjectMapper().writeValueAsString(object);
        }

        @Override
        public <T> void encode(T object, OutputStream outputStream) throws IOException {
            this.codec.writeTo(object, outputStream);
        }

        @Override
        public <T> T decode(String textValue, Class<T> type) throws IOException {
            return (T)this.codec.getObjectMapper().readValue(textValue, type);
        }

        @Override
        public <T> T decode(InputStream inputStream, Class<T> type) throws IOException {
            return (T)this.codec.getObjectMapper().readValue(inputStream, type);
        }
    }

    public static class JacksonJson
    implements EncoderDecoderWrapper {
        protected final EurekaJsonJacksonCodec codec = new EurekaJsonJacksonCodec();

        @Override
        public String codecName() {
            return CodecWrappers.getCodecName(this.getClass());
        }

        @Override
        public boolean support(MediaType mediaType) {
            return mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE);
        }

        @Override
        public <T> String encode(T object) throws IOException {
            return this.codec.getObjectMapper().writeValueAsString(object);
        }

        @Override
        public <T> void encode(T object, OutputStream outputStream) throws IOException {
            this.codec.writeTo(object, outputStream);
        }

        @Override
        public <T> T decode(String textValue, Class<T> type) throws IOException {
            return (T)this.codec.getObjectMapper().readValue(textValue, type);
        }

        @Override
        public <T> T decode(InputStream inputStream, Class<T> type) throws IOException {
            return (T)this.codec.getObjectMapper().readValue(inputStream, type);
        }
    }
}

