/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.dataformat.xml.ser.XmlBeanSerializer;
import com.netflix.discovery.converters.KeyFormatter;
import com.netflix.discovery.shared.Applications;
import java.io.IOException;

class ApplicationsBeanSerializers {
    ApplicationsBeanSerializers() {
    }

    static class ApplicationsXmlBeanSerializer
    extends XmlBeanSerializer {
        private final String versionKey;
        private final String appsHashCodeKey;

        ApplicationsXmlBeanSerializer(BeanSerializerBase src, KeyFormatter keyFormatter) {
            super(src);
            this.versionKey = keyFormatter.formatKey("versions_delta");
            this.appsHashCodeKey = keyFormatter.formatKey("apps_hashcode");
        }

        protected void serializeFields(Object bean, JsonGenerator jgen0, SerializerProvider provider) throws IOException {
            super.serializeFields(bean, jgen0, provider);
            Applications applications = (Applications)bean;
            if (applications.getVersion() != null) {
                jgen0.writeStringField(this.versionKey, Long.toString(applications.getVersion()));
            }
            if (applications.getAppsHashCode() != null) {
                jgen0.writeStringField(this.appsHashCodeKey, applications.getAppsHashCode());
            }
        }
    }

    static class ApplicationsJsonBeanSerializer
    extends BeanSerializer {
        private final String versionKey;
        private final String appsHashCodeKey;

        ApplicationsJsonBeanSerializer(BeanSerializerBase src, KeyFormatter keyFormatter) {
            super(src);
            this.versionKey = keyFormatter.formatKey("versions_delta");
            this.appsHashCodeKey = keyFormatter.formatKey("apps_hashcode");
        }

        protected void serializeFields(Object bean, JsonGenerator jgen0, SerializerProvider provider) throws IOException {
            super.serializeFields(bean, jgen0, provider);
            Applications applications = (Applications)bean;
            if (applications.getVersion() != null) {
                jgen0.writeStringField(this.versionKey, Long.toString(applications.getVersion()));
            }
            if (applications.getAppsHashCode() != null) {
                jgen0.writeStringField(this.appsHashCodeKey, applications.getAppsHashCode());
            }
        }
    }
}

