/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.util.List;
import java.util.Map;

public final class EurekaEntityComparators {
    private EurekaEntityComparators() {
    }

    public static boolean equal(DataCenterInfo first, DataCenterInfo second) {
        if (first == second) {
            return true;
        }
        if (first == null || first == null && second != null) {
            return false;
        }
        if (first.getClass() != second.getClass()) {
            return false;
        }
        if (first instanceof AmazonInfo) {
            return EurekaEntityComparators.equal((AmazonInfo)first, (AmazonInfo)second);
        }
        return first.getName() == second.getName();
    }

    public static boolean equal(AmazonInfo first, AmazonInfo second) {
        if (first == second) {
            return true;
        }
        if (first == null || first == null && second != null) {
            return false;
        }
        return first.getMetadata().equals(second.getMetadata());
    }

    public static boolean subsetOf(DataCenterInfo first, DataCenterInfo second) {
        if (first == second) {
            return true;
        }
        if (first == null || first == null && second != null) {
            return false;
        }
        if (first.getClass() != second.getClass()) {
            return false;
        }
        if (first instanceof AmazonInfo) {
            return EurekaEntityComparators.subsetOf((AmazonInfo)first, (AmazonInfo)second);
        }
        return first.getName() == second.getName();
    }

    public static boolean subsetOf(AmazonInfo first, AmazonInfo second) {
        if (first == second) {
            return true;
        }
        if (first == null || first == null && second != null) {
            return false;
        }
        return first.getMetadata().entrySet().containsAll(second.getMetadata().entrySet());
    }

    public static boolean equal(LeaseInfo first, LeaseInfo second) {
        if (first == second) {
            return true;
        }
        if (first == null || first == null && second != null) {
            return false;
        }
        if (first.getDurationInSecs() != second.getDurationInSecs()) {
            return false;
        }
        if (first.getEvictionTimestamp() != second.getEvictionTimestamp()) {
            return false;
        }
        if (first.getRegistrationTimestamp() != second.getRegistrationTimestamp()) {
            return false;
        }
        if (first.getRenewalIntervalInSecs() != second.getRenewalIntervalInSecs()) {
            return false;
        }
        if (first.getRenewalTimestamp() != second.getRenewalTimestamp()) {
            return false;
        }
        return first.getServiceUpTimestamp() == second.getServiceUpTimestamp();
    }

    public static boolean equal(InstanceInfo first, InstanceInfo second) {
        if (first == second) {
            return true;
        }
        if (first == null || first == null && second != null) {
            return false;
        }
        if (first.getCountryId() != second.getCountryId()) {
            return false;
        }
        if (first.getPort() != second.getPort()) {
            return false;
        }
        if (first.getSecurePort() != second.getSecurePort()) {
            return false;
        }
        if (first.getActionType() != second.getActionType()) {
            return false;
        }
        if (first.getAppGroupName() != null ? !first.getAppGroupName().equals(second.getAppGroupName()) : second.getAppGroupName() != null) {
            return false;
        }
        if (first.getAppName() != null ? !first.getAppName().equals(second.getAppName()) : second.getAppName() != null) {
            return false;
        }
        if (first.getASGName() != null ? !first.getASGName().equals(second.getASGName()) : second.getASGName() != null) {
            return false;
        }
        if (!EurekaEntityComparators.equal(first.getDataCenterInfo(), second.getDataCenterInfo())) {
            return false;
        }
        if (first.getHealthCheckUrls() != null ? !first.getHealthCheckUrls().equals(second.getHealthCheckUrls()) : second.getHealthCheckUrls() != null) {
            return false;
        }
        if (first.getHomePageUrl() != null ? !first.getHomePageUrl().equals(second.getHomePageUrl()) : second.getHomePageUrl() != null) {
            return false;
        }
        if (first.getHostName() != null ? !first.getHostName().equals(second.getHostName()) : second.getHostName() != null) {
            return false;
        }
        if (first.getIPAddr() != null ? !first.getIPAddr().equals(second.getIPAddr()) : second.getIPAddr() != null) {
            return false;
        }
        if (!EurekaEntityComparators.equal(first.getLeaseInfo(), second.getLeaseInfo())) {
            return false;
        }
        if (!EurekaEntityComparators.equal(first.getMetadata(), second.getMetadata())) {
            return false;
        }
        if (first.getHealthCheckUrls() != null ? !first.getHealthCheckUrls().equals(second.getHealthCheckUrls()) : second.getHealthCheckUrls() != null) {
            return false;
        }
        if (first.getVIPAddress() != null ? !first.getVIPAddress().equals(second.getVIPAddress()) : second.getVIPAddress() != null) {
            return false;
        }
        if (first.getSecureVipAddress() != null ? !first.getSecureVipAddress().equals(second.getSecureVipAddress()) : second.getSecureVipAddress() != null) {
            return false;
        }
        if (first.getStatus() != null ? !first.getStatus().equals((Object)second.getStatus()) : second.getStatus() != null) {
            return false;
        }
        if (first.getStatusPageUrl() != null ? !first.getStatusPageUrl().equals(second.getStatusPageUrl()) : second.getStatusPageUrl() != null) {
            return false;
        }
        if (first.getLastDirtyTimestamp() != null ? !first.getLastDirtyTimestamp().equals(second.getLastDirtyTimestamp()) : second.getLastDirtyTimestamp() != null) {
            return false;
        }
        if (first.getLastUpdatedTimestamp() != second.getLastUpdatedTimestamp()) {
            return false;
        }
        return !(first.isCoordinatingDiscoveryServer() != null ? !first.isCoordinatingDiscoveryServer().equals(second.isCoordinatingDiscoveryServer()) : second.isCoordinatingDiscoveryServer() != null);
    }

    public static boolean equalMini(InstanceInfo first, InstanceInfo second) {
        if (first == second) {
            return true;
        }
        if (first == null || first == null && second != null) {
            return false;
        }
        if (first.getPort() != second.getPort()) {
            return false;
        }
        if (first.getSecurePort() != second.getSecurePort()) {
            return false;
        }
        if (first.getActionType() != second.getActionType()) {
            return false;
        }
        if (first.getAppName() != null ? !first.getAppName().equals(second.getAppName()) : second.getAppName() != null) {
            return false;
        }
        if (first.getASGName() != null ? !first.getASGName().equals(second.getASGName()) : second.getASGName() != null) {
            return false;
        }
        if (!EurekaEntityComparators.subsetOf(first.getDataCenterInfo(), second.getDataCenterInfo())) {
            return false;
        }
        if (first.getHostName() != null ? !first.getHostName().equals(second.getHostName()) : second.getHostName() != null) {
            return false;
        }
        if (first.getIPAddr() != null ? !first.getIPAddr().equals(second.getIPAddr()) : second.getIPAddr() != null) {
            return false;
        }
        if (first.getVIPAddress() != null ? !first.getVIPAddress().equals(second.getVIPAddress()) : second.getVIPAddress() != null) {
            return false;
        }
        if (first.getSecureVipAddress() != null ? !first.getSecureVipAddress().equals(second.getSecureVipAddress()) : second.getSecureVipAddress() != null) {
            return false;
        }
        if (first.getStatus() != null ? !first.getStatus().equals((Object)second.getStatus()) : second.getStatus() != null) {
            return false;
        }
        return first.getLastUpdatedTimestamp() == second.getLastUpdatedTimestamp();
    }

    public static boolean equal(Application first, Application second) {
        if (first == second) {
            return true;
        }
        if (first == null || first == null && second != null) {
            return false;
        }
        if (first.getName() != null ? !first.getName().equals(second.getName()) : second.getName() != null) {
            return false;
        }
        List<InstanceInfo> firstInstanceInfos = first.getInstances();
        List<InstanceInfo> secondInstanceInfos = second.getInstances();
        if (firstInstanceInfos == null && secondInstanceInfos == null) {
            return true;
        }
        if (firstInstanceInfos == null || secondInstanceInfos == null || firstInstanceInfos.size() != secondInstanceInfos.size()) {
            return false;
        }
        for (InstanceInfo firstInstanceInfo : firstInstanceInfos) {
            InstanceInfo secondInstanceInfo;
            if (EurekaEntityComparators.equal(firstInstanceInfo, secondInstanceInfo = second.getByInstanceId(firstInstanceInfo.getId()))) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(Applications first, Applications second) {
        if (first == second) {
            return true;
        }
        if (first == null || first == null && second != null) {
            return false;
        }
        List<Application> firstApps = first.getRegisteredApplications();
        List<Application> secondApps = second.getRegisteredApplications();
        if (firstApps == null && secondApps == null) {
            return true;
        }
        if (firstApps == null || secondApps == null || firstApps.size() != secondApps.size()) {
            return false;
        }
        for (Application firstApp : firstApps) {
            Application secondApp;
            if (EurekaEntityComparators.equal(firstApp, secondApp = second.getRegisteredApplications(firstApp.getName()))) continue;
            return false;
        }
        return true;
    }

    private static boolean equal(Map<String, String> first, Map<String, String> second) {
        if (first == second) {
            return true;
        }
        if (first == null || first == null && second != null || first.size() != second.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : first.entrySet()) {
            String secondValue;
            if (!second.containsKey(entry.getKey())) {
                return false;
            }
            String firstValue = entry.getValue();
            if (firstValue.equals(secondValue = second.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }
}

