/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.discovery.converters.KeyFormatter;
import com.netflix.discovery.converters.jackson.AbstractEurekaJacksonCodec;
import com.netflix.discovery.converters.jackson.DataCenterInfoXmlMixIn;
import com.netflix.discovery.converters.jackson.EurekaJacksonModifiers;

public class EurekaXmlJacksonCodec
extends AbstractEurekaJacksonCodec {
    private final XmlMapper xmlMapper;

    public EurekaXmlJacksonCodec() {
        this(KeyFormatter.defaultKeyFormatter(), false);
    }

    public EurekaXmlJacksonCodec(final KeyFormatter keyFormatter, boolean compact) {
        this.xmlMapper = new XmlMapper(){

            public ObjectMapper registerModule(Module module) {
                this.setSerializerFactory(this.getSerializerFactory().withSerializerModifier(EurekaJacksonModifiers.createXmlSerializerModifier(keyFormatter)));
                return super.registerModule(module);
            }
        };
        this.xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.xmlMapper.addMixInAnnotations(DataCenterInfo.class, DataCenterInfoXmlMixIn.class);
        SimpleModule xmlModule = new SimpleModule();
        xmlModule.setDeserializerModifier(EurekaJacksonModifiers.createXmlDeserializerModifier(keyFormatter, compact));
        this.xmlMapper.registerModule((Module)xmlModule);
        if (compact) {
            this.addMiniConfig((ObjectMapper)this.xmlMapper);
        }
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.xmlMapper;
    }
}

