/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.converters.KeyFormatter;
import com.netflix.discovery.converters.jackson.DataCenterInfoXmlMixIn;
import com.netflix.discovery.converters.jackson.EurekaJacksonModifiers;
import com.netflix.discovery.converters.jackson.MiniInstanceInfoMixIn;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;

public class EurekaJacksonCodecNG {
    private static final Set<String> MINI_AMAZON_INFO_INCLUDE_KEYS = new HashSet<String>(Arrays.asList("instance-id", "public-ipv4", "public-hostname", "local-ipv4", "availability-zone"));
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final XmlMapper xmlMapper;

    public EurekaJacksonCodecNG() {
        this(KeyFormatter.defaultKeyFormatter(), false);
    }

    public EurekaJacksonCodecNG(final KeyFormatter keyFormatter, boolean compact) {
        SimpleModule jsonModule = new SimpleModule();
        jsonModule.setSerializerModifier(EurekaJacksonModifiers.createJsonSerializerModifier(keyFormatter));
        jsonModule.setDeserializerModifier(EurekaJacksonModifiers.createJsonDeserializerModifier(keyFormatter, compact));
        this.jsonMapper.registerModule((Module)jsonModule);
        this.jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        this.jsonMapper.configure(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED, true);
        this.jsonMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        this.jsonMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        this.xmlMapper = new XmlMapper(){

            public ObjectMapper registerModule(Module module) {
                this.setSerializerFactory(this.getSerializerFactory().withSerializerModifier(EurekaJacksonModifiers.createXmlSerializerModifier(keyFormatter)));
                return super.registerModule(module);
            }
        };
        this.xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.xmlMapper.addMixInAnnotations(DataCenterInfo.class, DataCenterInfoXmlMixIn.class);
        SimpleModule xmlModule = new SimpleModule();
        xmlModule.setDeserializerModifier(EurekaJacksonModifiers.createXmlDeserializerModifier(keyFormatter, compact));
        this.xmlMapper.registerModule((Module)xmlModule);
        if (compact) {
            this.addMiniConfig(this.jsonMapper);
            this.addMiniConfig((ObjectMapper)this.xmlMapper);
        }
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public ObjectMapper getXmlMapper() {
        return this.xmlMapper;
    }

    public <T> T readValue(Class<T> type, InputStream entityStream, MediaType mediaType) throws IOException {
        return (T)this.getMapper(mediaType).readValue(entityStream, type);
    }

    public <T> void writeTo(T object, OutputStream entityStream, MediaType mediaType) throws IOException {
        this.getMapper(mediaType).writeValue(entityStream, object);
    }

    private void addMiniConfig(ObjectMapper mapper) {
        mapper.addMixInAnnotations(InstanceInfo.class, MiniInstanceInfoMixIn.class);
        this.bindAmazonInfoFilter(mapper);
    }

    private void bindAmazonInfoFilter(ObjectMapper mapper) {
        SimpleFilterProvider filters = new SimpleFilterProvider();
        String filterName = "exclude-amazon-info-entries";
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){

            public Object findFilterId(Annotated a) {
                if (Map.class.isAssignableFrom(a.getRawType())) {
                    return "exclude-amazon-info-entries";
                }
                return super.findFilterId(a);
            }
        });
        filters.addFilter("exclude-amazon-info-entries", new SimpleBeanPropertyFilter(){

            protected boolean include(BeanPropertyWriter writer) {
                return true;
            }

            protected boolean include(PropertyWriter writer) {
                return MINI_AMAZON_INFO_INCLUDE_KEYS.contains(writer.getName());
            }
        });
        mapper.setFilters((FilterProvider)filters);
    }

    private ObjectMapper getMapper(MediaType mediaType) {
        if (mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            return this.jsonMapper;
        }
        if (mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            return this.xmlMapper;
        }
        throw new IllegalArgumentException("Expected application/xml or application/json media types only, and got " + mediaType);
    }
}

