/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.converters.Converters;
import com.netflix.discovery.converters.StringCache;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;

public class XmlXStream
extends XStream {
    private static final XmlXStream s_instance = new XmlXStream();

    public XmlXStream() {
        super((HierarchicalStreamDriver)new DomDriver(null, (NameCoder)XmlXStream.initializeNameCoder()));
        StringCache cache = new StringCache();
        this.registerConverter(new Converters.ApplicationConverter(cache));
        this.registerConverter(new Converters.ApplicationsConverter());
        this.registerConverter(new Converters.DataCenterInfoConverter(cache));
        this.registerConverter(new Converters.InstanceInfoConverter(cache));
        this.registerConverter(new Converters.LeaseInfoConverter());
        this.registerConverter(new Converters.MetadataConverter(cache));
        this.setMode(1001);
        this.processAnnotations(new Class[]{InstanceInfo.class, Application.class, Applications.class});
    }

    public static XmlXStream getInstance() {
        return s_instance;
    }

    private static XmlFriendlyNameCoder initializeNameCoder() {
        EurekaClientConfig clientConfig = DiscoveryManager.getInstance().getEurekaClientConfig();
        if (clientConfig == null) {
            return new XmlFriendlyNameCoder();
        }
        return new XmlFriendlyNameCoder(clientConfig.getDollarReplacement(), clientConfig.getEscapeCharReplacement());
    }
}

