/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit.functions;

import java.util.function.IntUnaryOperator;

public final class Log10RootIntFunction
implements IntUnaryOperator {
    private static final int[] lookup = new int[1000];
    private static final Log10RootIntFunction INSTANCE;

    private Log10RootIntFunction() {
    }

    public static IntUnaryOperator create(int baseline) {
        return baseline == 0 ? INSTANCE : INSTANCE.andThen(t -> t + baseline);
    }

    @Override
    public int applyAsInt(int t) {
        return t < 1000 ? lookup[t] : (int)Math.log10(t);
    }

    static {
        for (int i = 0; i < lookup.length; ++i) {
            Log10RootIntFunction.lookup[i] = Math.max(1, (int)Math.log10(i));
        }
        INSTANCE = new Log10RootIntFunction();
    }
}

