/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limiter;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Optional;

public final class BlockingLimiter<ContextT>
implements Limiter<ContextT> {
    private final Limiter<ContextT> delegate;
    private final Optional<Duration> timeout;
    private final Object lock = new Object();

    public static <ContextT> BlockingLimiter<ContextT> wrap(Limiter<ContextT> delegate) {
        return new BlockingLimiter<ContextT>(delegate, Optional.empty());
    }

    public static <ContextT> BlockingLimiter<ContextT> wrap(Limiter<ContextT> delegate, Duration timeout) {
        return new BlockingLimiter<ContextT>(delegate, Optional.of(timeout));
    }

    private BlockingLimiter(Limiter<ContextT> limiter, Optional<Duration> timeout) {
        this.delegate = limiter;
        this.timeout = timeout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Limiter.Listener> tryAcquire(ContextT context) {
        Instant deadline = this.timeout.map(t -> Instant.now().plus((TemporalAmount)t)).orElse(Instant.MAX);
        Object object = this.lock;
        synchronized (object) {
            Instant now;
            while ((now = Instant.now()).isBefore(deadline)) {
                Optional<Limiter.Listener> listener = this.delegate.acquire(context);
                if (listener.isPresent()) {
                    return listener;
                }
                try {
                    this.lock.wait(Duration.between(now, deadline).toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return Optional.empty();
                }
            }
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unblock() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    @Override
    public Optional<Limiter.Listener> acquire(ContextT context) {
        return this.tryAcquire(context).map(delegate -> new Limiter.Listener((Limiter.Listener)delegate){
            final /* synthetic */ Limiter.Listener val$delegate;
            {
                this.val$delegate = listener;
            }

            @Override
            public void onSuccess() {
                this.val$delegate.onSuccess();
                BlockingLimiter.this.unblock();
            }

            @Override
            public void onIgnore() {
                this.val$delegate.onIgnore();
                BlockingLimiter.this.unblock();
            }

            @Override
            public void onDropped() {
                this.val$delegate.onDropped();
                BlockingLimiter.this.unblock();
            }
        });
    }

    public String toString() {
        return "BlockingLimiter [" + this.delegate + "]";
    }
}

