/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limiter;
import java.util.Optional;

public final class BlockingLimiter<ContextT>
implements Limiter<ContextT> {
    private final Limiter<ContextT> delegate;
    private final Object lock = new Object();

    public static <ContextT> BlockingLimiter<ContextT> wrap(Limiter<ContextT> delegate) {
        return new BlockingLimiter<ContextT>(delegate);
    }

    private BlockingLimiter(Limiter<ContextT> limiter) {
        this.delegate = limiter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Limiter.Listener> tryAcquire(ContextT context) {
        Object object = this.lock;
        synchronized (object) {
            Optional<Limiter.Listener> listener;
            while (!(listener = this.delegate.acquire(context)).isPresent()) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return Optional.empty();
                }
            }
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unblock() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    @Override
    public Optional<Limiter.Listener> acquire(ContextT context) {
        return this.tryAcquire(context).map(delegate -> new Limiter.Listener((Limiter.Listener)delegate){
            final /* synthetic */ Limiter.Listener val$delegate;
            {
                this.val$delegate = listener;
            }

            @Override
            public void onSuccess() {
                this.val$delegate.onSuccess();
                BlockingLimiter.this.unblock();
            }

            @Override
            public void onIgnore() {
                this.val$delegate.onIgnore();
                BlockingLimiter.this.unblock();
            }

            @Override
            public void onDropped() {
                this.val$delegate.onDropped();
                BlockingLimiter.this.unblock();
            }
        });
    }

    public String toString() {
        return "BlockingLimiter [" + this.delegate + "]";
    }
}

