/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.internal.EmptyMetricRegistry;
import com.netflix.concurrency.limits.internal.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VegasLimit
implements Limit {
    private static final Logger LOG = LoggerFactory.getLogger(VegasLimit.class);
    private volatile double estimatedLimit;
    private volatile long rtt_noload = 0L;
    private boolean didDrop = false;
    private final int maxLimit;
    private final double smoothing;
    private final Function<Integer, Integer> alphaFunc;
    private final Function<Integer, Integer> betaFunc;
    private final Function<Integer, Integer> increaseFunc;
    private final Function<Integer, Integer> decreaseFunc;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static VegasLimit newDefault() {
        return VegasLimit.newBuilder().build();
    }

    private VegasLimit(Builder builder) {
        this.estimatedLimit = builder.initialLimit;
        this.maxLimit = builder.maxConcurrency;
        this.alphaFunc = builder.alpha;
        this.betaFunc = builder.beta;
        this.increaseFunc = builder.increaseFunc;
        this.decreaseFunc = builder.decreaseFunc;
        this.smoothing = builder.smoothing;
    }

    @Override
    public synchronized void update(long rtt) {
        double newLimit;
        Preconditions.checkArgument(rtt > 0L, "rtt must be >0 but got " + rtt);
        if (this.rtt_noload == 0L || rtt < this.rtt_noload) {
            LOG.debug("New MinRTT {}", (Object)rtt);
            this.rtt_noload = rtt;
        }
        int queueSize = (int)Math.ceil(this.estimatedLimit * (1.0 - (double)this.rtt_noload / (double)rtt));
        if (this.didDrop) {
            newLimit = this.decreaseFunc.apply((int)this.estimatedLimit).intValue();
            this.didDrop = false;
        } else {
            int alpha = this.alphaFunc.apply((int)this.estimatedLimit);
            int beta = this.betaFunc.apply((int)this.estimatedLimit);
            if (queueSize <= alpha) {
                newLimit = this.increaseFunc.apply((int)this.estimatedLimit).intValue();
            } else if (queueSize > beta) {
                newLimit = this.decreaseFunc.apply((int)this.estimatedLimit).intValue();
            } else {
                return;
            }
        }
        newLimit = Math.max(1.0, Math.min((double)this.maxLimit, newLimit));
        newLimit = (int)((1.0 - this.smoothing) * this.estimatedLimit + this.smoothing * newLimit);
        if ((int)newLimit != (int)this.estimatedLimit) {
            this.estimatedLimit = newLimit;
            if (LOG.isDebugEnabled()) {
                LOG.debug("New limit={} minRtt={} \u03bcs winRtt={} \u03bcs queueSize={}", new Object[]{this.estimatedLimit, TimeUnit.NANOSECONDS.toMicros(this.rtt_noload), TimeUnit.NANOSECONDS.toMicros(rtt), queueSize});
            }
        }
        this.estimatedLimit = newLimit;
    }

    @Override
    public synchronized void drop() {
        if (!this.didDrop) {
            this.didDrop = true;
        }
    }

    @Override
    public int getLimit() {
        return (int)this.estimatedLimit;
    }

    long getRttNoLoad() {
        return this.rtt_noload;
    }

    public String toString() {
        return "VegasLimit [limit=" + this.estimatedLimit + ", rtt_noload=" + TimeUnit.NANOSECONDS.toMillis(this.rtt_noload) + "]";
    }

    public static class Builder {
        private int initialLimit = 20;
        private int maxConcurrency = 1000;
        private MetricRegistry registry = EmptyMetricRegistry.INSTANCE;
        private double smoothing = 0.2;
        private Function<Integer, Integer> alpha = limit -> 3;
        private Function<Integer, Integer> beta = limit -> 6;
        private Function<Integer, Integer> increaseFunc = limit -> limit + 1;
        private Function<Integer, Integer> decreaseFunc = limit -> limit / 2;

        public Builder alpha(int alpha) {
            this.alpha = ignore -> alpha;
            return this;
        }

        public Builder alpha(Function<Integer, Integer> alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder beta(int beta) {
            this.beta = ignore -> beta;
            return this;
        }

        public Builder beta(Function<Integer, Integer> beta) {
            this.beta = beta;
            return this;
        }

        public Builder increase(Function<Integer, Integer> increase) {
            this.increaseFunc = increase;
            return this;
        }

        public Builder decrease(Function<Integer, Integer> decrease) {
            this.decreaseFunc = decrease;
            return this;
        }

        public Builder smoothing(double smoothing) {
            this.smoothing = smoothing;
            return this;
        }

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        @Deprecated
        public Builder tolerance(double tolerance) {
            return this;
        }

        public Builder maxConcurrency(int maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder backoffRatio(double ratio) {
            return this;
        }

        public Builder metricRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        public VegasLimit build() {
            VegasLimit limit = new VegasLimit(this);
            this.registry.registerGauge("min_rtt", limit::getRttNoLoad, new String[0]);
            return limit;
        }
    }
}

