/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.blitz4j;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class LoggerCache {
    private static LoggerCache instance = new LoggerCache();
    private Map<String, Logger> appenderLoggerMap = new ConcurrentHashMap<String, Logger>(5000);

    private LoggerCache() {
    }

    public static LoggerCache getInstance() {
        return instance;
    }

    public Logger getOrCreateLogger(String clazz) {
        Logger logger = this.appenderLoggerMap.get(clazz);
        if (logger == null) {
            logger = Logger.getLogger((String)clazz);
            this.appenderLoggerMap.put(clazz, logger);
        }
        return logger;
    }

    public void clearAll() {
        this.appenderLoggerMap.clear();
    }
}

