/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.blitz4j;

import com.netflix.blitz4j.NFCategoryFactory;
import java.util.AbstractQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerFactory;

public class NFHierarchy
extends Hierarchy {
    private LoggerFactory myFactory = new NFCategoryFactory();
    private AbstractQueue<HierarchyEventListener> listeners = new ConcurrentLinkedQueue<HierarchyEventListener>();

    public NFHierarchy(Logger root) {
        super(root);
    }

    public Logger getLogger(String name) {
        return this.getLogger(name, this.myFactory);
    }

    public void addHierarchyEventListener(HierarchyEventListener listener) {
        if (this.listeners.contains(listener)) {
            LogLog.warn((String)"Ignoring attempt to add an existent listener.");
        } else {
            this.listeners.add(listener);
        }
    }

    public void fireAddAppenderEvent(Category logger, Appender appender) {
        if (this.listeners != null) {
            for (HierarchyEventListener listener : this.listeners) {
                listener.addAppenderEvent(logger, appender);
            }
        }
    }

    public void fireRemoveAppenderEvent(Category logger, Appender appender) {
        if (this.listeners != null) {
            for (HierarchyEventListener listener : this.listeners) {
                listener.removeAppenderEvent(logger, appender);
            }
        }
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.myFactory = loggerFactory;
    }
}

