/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.blitz4j;

import com.netflix.blitz4j.BlitzConfig;
import com.netflix.blitz4j.LoggingConfiguration;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.MDC;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class LoggingContext {
    private static final BlitzConfig CONFIGURATION = LoggingConfiguration.getInstance().getConfiguration();
    private static final String LOCATION_INFO = "locationInfo";
    private ThreadLocal<StackTraceElement> stackLocal;
    private ThreadLocal<LoggingEvent> loggingEvent;
    private static final LoggingContext instance = new LoggingContext();
    private Timer stackTraceTimer;

    private LoggingContext() {
        block2: {
            this.stackLocal = new ThreadLocal();
            this.loggingEvent = new ThreadLocal();
            this.stackTraceTimer = Monitors.newTimer((String)"getStacktraceElement", (TimeUnit)TimeUnit.NANOSECONDS);
            try {
                Monitors.registerObject((Object)this);
            }
            catch (Throwable e) {
                if (!CONFIGURATION.shouldPrintLoggingErrors()) break block2;
                e.printStackTrace();
            }
        }
    }

    public StackTraceElement getStackTraceElement(Class stackClass) {
        Stopwatch s = this.stackTraceTimer.start();
        Throwable t = new Throwable();
        StackTraceElement[] stArray = t.getStackTrace();
        int stackSize = stArray.length;
        StackTraceElement st = null;
        for (int i = 0; i < stackSize; ++i) {
            boolean found = false;
            while (stArray[i].getClassName().equals(stackClass.getName())) {
                ++i;
                found = true;
            }
            if (!found) continue;
            st = stArray[i];
        }
        s.stop();
        return st;
    }

    public LocationInfo getLocationInfo(Class wrapperClassName) {
        LocationInfo locationInfo;
        block3: {
            locationInfo = null;
            try {
                if (this.stackLocal.get() == null) {
                    this.stackLocal.set(this.getStackTraceElement(wrapperClassName));
                }
                locationInfo = new LocationInfo(this.stackLocal.get().getFileName(), this.stackLocal.get().getClassName(), this.stackLocal.get().getMethodName(), this.stackLocal.get().getLineNumber() + "");
            }
            catch (Throwable e) {
                if (!CONFIGURATION.shouldPrintLoggingErrors()) break block3;
                e.printStackTrace();
            }
        }
        return locationInfo;
    }

    private void clearLocationInfo() {
        MDC.remove((String)LOCATION_INFO);
        this.stackLocal.set(null);
    }

    public static LoggingContext getInstance() {
        return instance;
    }

    public LocationInfo generateLocationInfo(LoggingEvent event) {
        LocationInfo locationInfo;
        block4: {
            if (event != this.loggingEvent.get()) {
                this.loggingEvent.set(event);
                this.clearLocationInfo();
            }
            locationInfo = null;
            try {
                locationInfo = LoggingContext.getInstance().getLocationInfo(Class.forName(event.getFQNOfLoggerClass()));
                if (locationInfo != null) {
                    MDC.put((String)LOCATION_INFO, (Object)locationInfo);
                }
            }
            catch (Throwable e) {
                if (!CONFIGURATION.shouldPrintLoggingErrors()) break block4;
                e.printStackTrace();
            }
        }
        return locationInfo;
    }

    public LocationInfo getLocationInfo(LoggingEvent event) {
        LocationInfo locationInfo;
        if (event != this.loggingEvent.get()) {
            this.loggingEvent.set(event);
            this.clearLocationInfo();
        }
        if ((locationInfo = (LocationInfo)event.getMDC(LOCATION_INFO)) == null) {
            locationInfo = this.generateLocationInfo(event);
        }
        return locationInfo;
    }
}

