/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.DefaultDecoder;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.StrInterpolator;
import com.netflix.archaius.config.PrefixedViewConfig;
import com.netflix.archaius.exceptions.ParseException;
import com.netflix.archaius.interpolate.CommonsStrInterpolator;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

public abstract class AbstractConfig
implements Config {
    private final CopyOnWriteArrayList<ConfigListener> listeners = new CopyOnWriteArrayList();
    private final StrInterpolator.Lookup lookup;
    private Decoder decoder = new DefaultDecoder();
    private StrInterpolator interpolator = CommonsStrInterpolator.INSTANCE;
    private String listDelimiter = ",";
    private final String name;
    private static final AtomicInteger idCounter = new AtomicInteger();

    protected static String generateUniqueName(String prefix) {
        return prefix + idCounter.incrementAndGet();
    }

    public AbstractConfig(String name) {
        this.lookup = ConfigStrLookup.from(this);
        this.name = name == null ? AbstractConfig.generateUniqueName("unnamed-") : name;
    }

    public AbstractConfig() {
        this(AbstractConfig.generateUniqueName("unnamed-"));
    }

    protected CopyOnWriteArrayList<ConfigListener> getListeners() {
        return this.listeners;
    }

    protected StrInterpolator.Lookup getLookup() {
        return this.lookup;
    }

    public String getListDelimiter() {
        return this.listDelimiter;
    }

    public void setListDelimiter(String delimiter) {
        this.listDelimiter = delimiter;
    }

    public final Decoder getDecoder() {
        return this.decoder;
    }

    public void setDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    public final StrInterpolator getStrInterpolator() {
        return this.interpolator;
    }

    public void setStrInterpolator(StrInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    public void addListener(ConfigListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ConfigListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyConfigUpdated(Config child) {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigUpdated(child);
        }
    }

    protected void notifyError(Throwable t, Config child) {
        for (ConfigListener listener : this.listeners) {
            listener.onError(t, child);
        }
    }

    protected void notifyConfigAdded(Config child) {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigAdded(child);
        }
    }

    protected void notifyConfigRemoved(Config child) {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigRemoved(child);
        }
    }

    public String getString(String key, String defaultValue) {
        Object value = this.getRawProperty(key);
        if (value == null) {
            return this.notFound(key, defaultValue != null ? this.interpolator.create(this.getLookup()).resolve(defaultValue) : null);
        }
        if (value instanceof String) {
            return this.resolve((String)value);
        }
        return value.toString();
    }

    public String getString(String key) {
        Object value = this.getRawProperty(key);
        if (value == null) {
            return (String)this.notFound(key);
        }
        if (value instanceof String) {
            return this.resolve(value.toString());
        }
        return value.toString();
    }

    protected <T> T notFound(String key, T defaultValue) {
        return defaultValue;
    }

    protected <T> T notFound(String key) {
        throw new NoSuchElementException("'" + key + "' not found");
    }

    @Deprecated
    public Iterator<String> getKeys(final String prefix) {
        return new Iterator<String>(){
            Iterator<String> iter;
            String next;
            {
                this.iter = AbstractConfig.this.getKeys();
                while (this.iter.hasNext()) {
                    this.next = this.iter.next();
                    if (this.next.startsWith(prefix)) break;
                    this.next = null;
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public String next() {
                if (this.next == null) {
                    throw new IllegalStateException();
                }
                String current = this.next;
                this.next = null;
                while (this.iter.hasNext()) {
                    this.next = this.iter.next();
                    if (this.next.startsWith(prefix)) break;
                    this.next = null;
                }
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Config getPrefixedView(String prefix) {
        if (prefix == null || prefix.isEmpty() || prefix.equals(".")) {
            return this;
        }
        return new PrefixedViewConfig(prefix, this);
    }

    public <T> T accept(Config.Visitor<T> visitor) {
        Object result = null;
        this.forEachProperty((k, v) -> visitor.visitKey(k, v));
        return null;
    }

    protected <T> T getValue(Class<T> type, String key) {
        T value = this.getValueWithDefault(type, key, null);
        if (value == null) {
            return this.notFound(key);
        }
        return value;
    }

    protected <T> T getValueWithDefault(Class<T> type, String key, T defaultValue) {
        Object rawProp = this.getRawProperty(key);
        if (rawProp == null) {
            return defaultValue;
        }
        if (rawProp instanceof String) {
            try {
                String value = this.resolve(rawProp.toString());
                return (T)this.decoder.decode(type, value);
            }
            catch (NumberFormatException e) {
                return this.parseError(key, rawProp.toString(), e);
            }
        }
        if (type.isInstance(rawProp) || type.isPrimitive()) {
            return (T)rawProp;
        }
        return this.parseError(key, rawProp.toString(), new NumberFormatException("Property " + rawProp.toString() + " is of wrong format " + type.getCanonicalName()));
    }

    public String resolve(String value) {
        return this.interpolator.create(this.getLookup()).resolve(value);
    }

    public <T> T resolve(String value, Class<T> type) {
        return (T)this.getDecoder().decode(type, this.resolve(value));
    }

    public Long getLong(String key) {
        return this.getValue(Long.class, key);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.getValueWithDefault(Long.class, key, defaultValue);
    }

    public Double getDouble(String key) {
        return this.getValue(Double.class, key);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.getValueWithDefault(Double.class, key, defaultValue);
    }

    public Integer getInteger(String key) {
        return this.getValue(Integer.class, key);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.getValueWithDefault(Integer.class, key, defaultValue);
    }

    public Boolean getBoolean(String key) {
        return this.getValue(Boolean.class, key);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.getValueWithDefault(Boolean.class, key, defaultValue);
    }

    public Short getShort(String key) {
        return this.getValue(Short.class, key);
    }

    public Short getShort(String key, Short defaultValue) {
        return this.getValueWithDefault(Short.class, key, defaultValue);
    }

    public BigInteger getBigInteger(String key) {
        return this.getValue(BigInteger.class, key);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.getValueWithDefault(BigInteger.class, key, defaultValue);
    }

    public BigDecimal getBigDecimal(String key) {
        return this.getValue(BigDecimal.class, key);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.getValueWithDefault(BigDecimal.class, key, defaultValue);
    }

    public Float getFloat(String key) {
        return this.getValue(Float.class, key);
    }

    public Float getFloat(String key, Float defaultValue) {
        return this.getValueWithDefault(Float.class, key, defaultValue);
    }

    public Byte getByte(String key) {
        return this.getValue(Byte.class, key);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return this.getValueWithDefault(Byte.class, key, defaultValue);
    }

    public <T> List<T> getList(String key, Class<T> type) {
        String value = this.getString(key);
        if (value == null) {
            return (List)this.notFound(key);
        }
        String[] parts = value.split(this.getListDelimiter());
        ArrayList<Object> result = new ArrayList<Object>();
        for (String part : parts) {
            result.add(this.decoder.decode(type, part));
        }
        return result;
    }

    public List getList(String key) {
        String value = this.getString(key);
        if (value == null) {
            return (List)this.notFound(key);
        }
        String[] parts = value.split(this.getListDelimiter());
        return Arrays.asList(parts);
    }

    public List getList(String key, List defaultValue) {
        String value = this.getString(key, null);
        if (value == null) {
            return this.notFound(key, defaultValue);
        }
        String[] parts = value.split(",");
        return Arrays.asList(parts);
    }

    public <T> T get(Class<T> type, String key) {
        return this.getValue(type, key);
    }

    public <T> T get(Class<T> type, String key, T defaultValue) {
        return this.getValueWithDefault(type, key, defaultValue);
    }

    private <T> T parseError(String key, String value, Exception e) {
        throw new ParseException("Error parsing value '" + value + "' for property '" + key + "'", e);
    }

    public void forEachProperty(BiConsumer<String, Object> consumer) {
        Iterator keys = this.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = this.getRawProperty(key);
            if (value == null) continue;
            consumer.accept(key, value);
        }
    }

    public String getName() {
        return this.name;
    }
}

