/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.cascade;

import com.netflix.archaius.api.CascadeStrategy;
import com.netflix.archaius.api.StrInterpolator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ConcatCascadeStrategy
implements CascadeStrategy {
    private static final String DEFAULT_SEPARATOR = "-";
    private final List<String> parameters;
    private final String separator;

    public static ConcatCascadeStrategy from(String ... parameters) {
        ArrayList<String> params = new ArrayList<String>();
        Collections.addAll(params, parameters);
        return new ConcatCascadeStrategy(params);
    }

    public ConcatCascadeStrategy(List<String> parameters) {
        this.separator = DEFAULT_SEPARATOR;
        this.parameters = new ArrayList<String>();
        this.parameters.addAll(parameters);
    }

    public ConcatCascadeStrategy(String[] parameters) {
        this(Arrays.asList(parameters));
    }

    public ConcatCascadeStrategy(String separator, List<String> parameters) {
        this.separator = separator;
        this.parameters = new ArrayList<String>();
        this.parameters.addAll(parameters);
    }

    public ConcatCascadeStrategy(String separator, String[] parameters) {
        this(separator, Arrays.asList(parameters));
    }

    public List<String> generate(String name, StrInterpolator interpolator, StrInterpolator.Lookup lookup) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(name);
        String current = name;
        for (String param : this.parameters) {
            current = current + this.separator + param;
            result.add(interpolator.create(lookup).resolve(current));
        }
        return result;
    }
}

