/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.api;

import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.PropertyDetails;
import com.netflix.archaius.api.PropertySource;
import com.netflix.archaius.api.StrInterpolator;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public interface Config
extends PropertySource {
    public void addListener(ConfigListener var1);

    public void removeListener(ConfigListener var1);

    public Object getRawProperty(String var1);

    default public Object getRawPropertyUninstrumented(String key) {
        return this.getRawProperty(key);
    }

    @Override
    default public Optional<Object> getProperty(String key) {
        return Optional.ofNullable(this.getRawProperty(key));
    }

    @Override
    default public Optional<Object> getPropertyUninstrumented(String key) {
        return Optional.ofNullable(this.getRawPropertyUninstrumented(key));
    }

    default public void recordUsage(PropertyDetails propertyDetails) {
        throw new UnsupportedOperationException("Property usage instrumentation not supported for this config type.");
    }

    default public boolean instrumentationEnabled() {
        return false;
    }

    public Long getLong(String var1);

    public Long getLong(String var1, Long var2);

    public String getString(String var1);

    public String getString(String var1, String var2);

    public Double getDouble(String var1);

    public Double getDouble(String var1, Double var2);

    public Integer getInteger(String var1);

    public Integer getInteger(String var1, Integer var2);

    public Boolean getBoolean(String var1);

    public Boolean getBoolean(String var1, Boolean var2);

    public Short getShort(String var1);

    public Short getShort(String var1, Short var2);

    public BigInteger getBigInteger(String var1);

    public BigInteger getBigInteger(String var1, BigInteger var2);

    public BigDecimal getBigDecimal(String var1);

    public BigDecimal getBigDecimal(String var1, BigDecimal var2);

    public Float getFloat(String var1);

    public Float getFloat(String var1, Float var2);

    public Byte getByte(String var1);

    public Byte getByte(String var1, Byte var2);

    public List<?> getList(String var1);

    public <T> List<T> getList(String var1, Class<T> var2);

    @Deprecated
    public List<?> getList(String var1, List<?> var2);

    public <T> T get(Class<T> var1, String var2);

    public <T> T get(Class<T> var1, String var2, T var3);

    public <T> T get(Type var1, String var2);

    public <T> T get(Type var1, String var2, T var3);

    public boolean containsKey(String var1);

    @Deprecated
    public Iterator<String> getKeys();

    default public Iterable<String> keys() {
        return this::getKeys;
    }

    public Iterator<String> getKeys(String var1);

    public Config getPrefixedView(String var1);

    public Config getPrivateView();

    public void setStrInterpolator(StrInterpolator var1);

    public StrInterpolator getStrInterpolator();

    public void setDecoder(Decoder var1);

    public Decoder getDecoder();

    public <T> T accept(Visitor<T> var1);

    default public String resolve(String value) {
        throw new UnsupportedOperationException();
    }

    default public <T> T resolve(String value, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public static interface Visitor<T> {
        public T visitKey(String var1, Object var2);
    }
}

