/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.tool;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.netease.nis.bugrpt.crash.CrashDetailBean;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class SharedPrefUtil {
    public static final String SHARED_PREFERENCE_NAME = "CrashTimes";
    public static final String SHARED_DATE = "date";
    public static final String SHARED_CATCHED_EXCEPTION_LIMIT = "catchedExcepitonTimes";
    public static final String SHARED_USER_LOG_LIMIT = "userLogTimes";
    public static final String SHARED_UNHANDLED_EXCEPTION_LIMIT = "crashTimes";
    private Context mContext = null;

    public SharedPrefUtil(Context ctx) {
        this.mContext = ctx;
    }

    public boolean isReachLimitCount(CrashDetailBean bean) {
        Boolean bRet = false;
        try {
            SharedPreferences preferences = this.mContext.getSharedPreferences(SHARED_PREFERENCE_NAME, 0);
            String date = preferences.getString(SHARED_DATE, "");
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
            String today = dateFormat.format(calendar.getTime());
            String exceptionTimesDesc = bean.isCatchedException() ? SHARED_CATCHED_EXCEPTION_LIMIT : (bean.isUserLog() ? SHARED_USER_LOG_LIMIT : SHARED_UNHANDLED_EXCEPTION_LIMIT);
            int crashTimes = preferences.getInt(exceptionTimesDesc, 0);
            Log.d((String)"bugrpt", (String)(exceptionTimesDesc + ":" + crashTimes));
            if (date.equals(today)) {
                if (bean.isCatchedException() || bean.isUserLog()) {
                    if (crashTimes >= 100) {
                        Log.d((String)"bugrpt", (String)"user define exception is limited");
                        bRet = true;
                    }
                } else if (crashTimes >= 1000) {
                    Log.d((String)"bugrpt", (String)"unhandle exception is limited");
                    bRet = true;
                }
            } else {
                SharedPreferences.Editor editor = preferences.edit();
                editor.putString(SHARED_DATE, today);
                editor.putInt(SHARED_CATCHED_EXCEPTION_LIMIT, 0);
                editor.putInt(SHARED_USER_LOG_LIMIT, 0);
                editor.putInt(SHARED_UNHANDLED_EXCEPTION_LIMIT, 0);
                editor.commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bRet;
    }

    public void increaseCrashSendCount(CrashDetailBean bean) {
        try {
            String exceptionTimesDesc = bean.isCatchedException() ? SHARED_CATCHED_EXCEPTION_LIMIT : (bean.isUserLog() ? SHARED_USER_LOG_LIMIT : SHARED_UNHANDLED_EXCEPTION_LIMIT);
            SharedPreferences preferences = this.mContext.getSharedPreferences(SHARED_PREFERENCE_NAME, 0);
            int crashTimes = preferences.getInt(exceptionTimesDesc, 0);
            SharedPreferences.Editor editor = preferences.edit();
            editor.putInt(exceptionTimesDesc, ++crashTimes);
            editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

