/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt;

import android.content.Context;
import android.util.Log;
import com.netease.nis.bugrpt.CrashHandler;
import com.netease.nis.bugrpt.tool.Common;
import java.io.File;

public class NativeCrashHandler {
    public static final String TAG = "bugrpt";
    private static NativeCrashHandler mNativeHandler;
    private static boolean soload_flag;
    private Context mContext;
    private String mNativeVer = null;

    private NativeCrashHandler(Context context) {
        if (context != null) {
            this.mContext = context.getApplicationContext();
            if (this.mContext == null) {
                this.mContext = context;
            }
        } else {
            this.mContext = null;
        }
    }

    public static native void crash();

    public static native String getInfo(Context var0, int var1, String var2);

    public static synchronized NativeCrashHandler getInstance(Context context) {
        if (mNativeHandler == null) {
            mNativeHandler = new NativeCrashHandler(context);
        }
        return mNativeHandler;
    }

    public static String initNative(Context context) {
        String strNativeVer = "";
        if (mNativeHandler == null) {
            NativeCrashHandler.getInstance(context);
        }
        if (mNativeHandler != null) {
            if (NativeCrashHandler.queryLibpath(context)) {
                try {
                    System.loadLibrary(TAG);
                    strNativeVer = mNativeHandler.initInternal();
                    soload_flag = true;
                }
                catch (UnsatisfiedLinkError error) {
                    Log.d((String)TAG, (String)("libbugrpt.so load failed:" + error.getMessage()));
                }
            } else {
                Log.d((String)TAG, (String)"libbugrpt.so not exists");
            }
        }
        return strNativeVer;
    }

    private static boolean queryLibpath(Context context) {
        try {
            File soFile = new File(context.getCacheDir().getParent() + "/lib", "libbugrpt.so");
            if (soFile.exists()) {
                return true;
            }
            File soFile2 = new File(context.getApplicationInfo().nativeLibraryDir, "libbugrpt.so");
            if (soFile2.exists()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static String collectJniDeviceInfo(Context ctx, String str) {
        String strJson = "";
        if (soload_flag) {
            strJson = NativeCrashHandler.getInfo(ctx, 1, str);
        }
        return strJson;
    }

    public static String isRoot(Context ctx, String str) {
        String strRoot = "";
        try {
            if (soload_flag) {
                strRoot = NativeCrashHandler.getInfo(ctx, 2, str);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strRoot;
    }

    public static void send(String text, int tid) {
        CrashHandler crashHandler = CrashHandler.getInstance();
        Log.d((String)TAG, (String)("before send,ndk crash thread id:" + tid));
        StringBuffer ErrorLog = new StringBuffer();
        ErrorLog.append(text);
        String javaStack = Common.getJavaStackTrace(tid);
        if (javaStack != null && !javaStack.equals("")) {
            ErrorLog.append("\njava:");
            ErrorLog.append(javaStack);
        }
        crashHandler.sendReportsToServer(ErrorLog.toString(), "ndk");
    }

    protected native String init(Context var1, String var2, boolean var3, int var4);

    private String initInternal() {
        if (this.mNativeVer == null) {
            this.mNativeVer = this.init(this.mContext, this.mContext.getCacheDir().getAbsolutePath(), false, 1);
        }
        return this.mNativeVer;
    }

    static {
        soload_flag = false;
    }
}

