/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);

    public static File getFile(ApplicationContext applicationContext, String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("File path doesn't set");
        }
        try {
            String filePath = applicationContext.getEnvironment().resolvePlaceholders(path);
            File file = applicationContext.getResource(filePath).getFile();
            LOG.info("File [{}] is found", (Object)path);
            return file;
        }
        catch (Exception e) {
            LOG.warn("File [{}] isn't found or valid, ignore to load...", (Object)path);
            return null;
        }
    }

    public static InputStream getInputStream(ApplicationContext applicationContext, String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("File path doesn't set");
        }
        try {
            String filePath = applicationContext.getEnvironment().resolvePlaceholders(path);
            InputStream inputStream = applicationContext.getResource(filePath).getInputStream();
            LOG.info("File [{}] is found", (Object)path);
            return inputStream;
        }
        catch (Exception e) {
            LOG.warn("File [{}] isn't found or valid, ignore to load...", (Object)path);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getText(ApplicationContext applicationContext, String path) {
        block7: {
            InputStream inputStream = null;
            try {
                inputStream = FileUtil.getInputStream(applicationContext, path);
                if (inputStream == null) break block7;
                try {
                    String string = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                    return string;
                }
                catch (IOException e) {
                    LOG.warn("InputStream to String failed, ignore to load...");
                }
            }
            finally {
                if (inputStream != null) {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
        return null;
    }

    public static void toFile(String text, String directoryPath, String fileName, String encoding) throws IOException {
        File directory = new File(directoryPath);
        if (!directory.exists() || !directory.isDirectory()) {
            directory.mkdirs();
        }
        File file = new File(directoryPath + File.separator + fileName);
        FileUtils.writeStringToFile((File)file, (String)text, (String)encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(byte[] bytes, String directoryPath, String fileName) throws IOException {
        FileOutputStream fos;
        block6: {
            File directory = new File(directoryPath);
            if (!directory.exists() || !directory.isDirectory()) {
                directory.mkdirs();
            }
            BufferedOutputStream bos = null;
            fos = null;
            try {
                File file = new File(directoryPath + File.separator + fileName);
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                bos.write(bytes);
                if (bos == null) break block6;
            }
            catch (Throwable throwable) {
                if (bos != null) {
                    IOUtils.closeQuietly(bos);
                }
                if (fos != null) {
                    IOUtils.closeQuietly(fos);
                }
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)bos);
        }
        if (fos != null) {
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    public static byte[] fromFile(String directoryPath, String fileName) throws IOException {
        File file = new File(directoryPath + File.separator + fileName);
        return FileUtils.readFileToByteArray((File)file);
    }

    public static void forceDeleteDirectory(File directory, int forceTimes) {
        if (directory.isDirectory() && directory.exists()) {
            try {
                FileUtils.deleteDirectory((File)directory);
                if (--forceTimes <= 0) {
                    throw new IOException("Force delete directory=" + directory + " failed");
                }
                FileUtil.forceDeleteDirectory(directory, forceTimes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void forceDeleteFile(File file, int forceTimes) {
        if (file.isFile() && file.exists()) {
            try {
                FileUtils.deleteQuietly((File)file);
                if (--forceTimes <= 0) {
                    throw new IOException("Force delete file=" + file + " failed");
                }
                FileUtil.forceDeleteFile(file, forceTimes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static byte[] getBytes(File file) throws FileNotFoundException, IOException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inputStream != null) {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
    }
}

