/*
 * Decompiled with CFR 0.152.
 */
package com.neovisionaries.ws.client;

import com.neovisionaries.ws.client.ListenerManager;
import com.neovisionaries.ws.client.StateManager;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketError;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

class WritingThread
extends Thread {
    private static final int SHOULD_SEND = 0;
    private static final int SHOULD_STOP = 1;
    private static final int SHOULD_CONTINUE = 2;
    private final WebSocket mWebSocket;
    private final List<WebSocketFrame> mFrames;
    private boolean mStopRequested;
    private WebSocketFrame mCloseFrame;

    public WritingThread(WebSocket websocket) {
        super("WritingThread");
        this.mWebSocket = websocket;
        this.mFrames = new LinkedList<WebSocketFrame>();
    }

    public void run() {
        try {
            this.main();
        }
        catch (Throwable t) {
            WebSocketException cause = new WebSocketException(WebSocketError.UNEXPECTED_ERROR_IN_WRITING_THREAD, "An uncaught throwable was detected in the writing thread", t);
            ListenerManager manager = this.mWebSocket.getListenerManager();
            manager.callOnError(cause);
            manager.callOnUnexpectedError(cause);
        }
    }

    private void main() {
        int result;
        this.mWebSocket.onWritingThreadStarted();
        while ((result = this.waitForFrames()) != 1) {
            if (result == 2) continue;
            try {
                this.sendFrames();
            }
            catch (WebSocketException e) {
                break;
            }
        }
        try {
            this.sendFrames();
        }
        catch (WebSocketException webSocketException) {
            // empty catch block
        }
        this.notifyFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        WritingThread writingThread = this;
        synchronized (writingThread) {
            this.mStopRequested = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueFrame(WebSocketFrame frame) {
        WritingThread writingThread = this;
        synchronized (writingThread) {
            this.mFrames.add(frame);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int waitForFrames() {
        WritingThread writingThread = this;
        synchronized (writingThread) {
            if (this.mStopRequested) {
                return 1;
            }
            if (this.mCloseFrame != null) {
                return 1;
            }
            if (this.mFrames.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.mStopRequested) {
                return 1;
            }
            if (this.mFrames.size() == 0) {
                return 2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFrames() throws WebSocketException {
        ArrayList<WebSocketFrame> frames;
        WritingThread writingThread = this;
        synchronized (writingThread) {
            frames = new ArrayList<WebSocketFrame>(this.mFrames.size());
            frames.addAll(this.mFrames);
            this.mFrames.clear();
        }
        if (frames.size() == 0) {
            return;
        }
        for (WebSocketFrame frame : frames) {
            this.sendFrame(frame);
        }
        try {
            this.mWebSocket.getOutput().flush();
        }
        catch (IOException e) {
            WebSocketException cause = new WebSocketException(WebSocketError.FLUSH_ERROR, "Flushing frames to the server failed", e);
            ListenerManager manager = this.mWebSocket.getListenerManager();
            manager.callOnError(cause);
            manager.callOnSendError(cause, null);
            throw cause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFrame(WebSocketFrame frame) throws WebSocketException {
        boolean unsent = false;
        WritingThread writingThread = this;
        synchronized (writingThread) {
            if (this.mCloseFrame != null) {
                unsent = true;
            } else if (frame.isCloseFrame()) {
                this.mCloseFrame = frame;
            }
        }
        if (unsent) {
            this.mWebSocket.getListenerManager().callOnFrameUnsent(frame);
            return;
        }
        if (frame.isCloseFrame()) {
            this.changeToClosing();
        }
        try {
            this.mWebSocket.getOutput().write(frame);
        }
        catch (IOException e) {
            WebSocketException cause = new WebSocketException(WebSocketError.IO_ERROR_IN_WRITING, "An I/O error occurred when a frame was tried to be sent.", e);
            ListenerManager manager = this.mWebSocket.getListenerManager();
            manager.callOnError(cause);
            manager.callOnSendError(cause, frame);
            throw cause;
        }
        this.mWebSocket.getListenerManager().callOnFrameSent(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeToClosing() {
        StateManager manager = this.mWebSocket.getStateManager();
        boolean stateChanged = false;
        StateManager stateManager = manager;
        synchronized (stateManager) {
            WebSocketState state = manager.getState();
            if (state != WebSocketState.CLOSING && state != WebSocketState.CLOSED) {
                manager.changeToClosing(StateManager.CloseInitiator.CLIENT);
                stateChanged = true;
            }
        }
        if (stateChanged) {
            this.mWebSocket.getListenerManager().callOnStateChanged(WebSocketState.CLOSING);
        }
    }

    private void notifyFinished() {
        this.mWebSocket.onWritingThreadFinished(this.mCloseFrame);
    }
}

