/*
 * Decompiled with CFR 0.152.
 */
package com.neovisionaries.ws.client;

import java.nio.ByteBuffer;

class ByteArray {
    private static final int ADDITIONAL_BUFFER_SIZE = 1024;
    private ByteBuffer mBuffer;
    private int mLength;

    public ByteArray(int capacity) {
        this.mBuffer = ByteBuffer.allocate(capacity);
        this.mLength = 0;
    }

    public ByteArray(byte[] data) {
        this.mBuffer = ByteBuffer.wrap(data);
        this.mLength = data.length;
    }

    public int length() {
        return this.mLength;
    }

    public byte get(int index) throws IndexOutOfBoundsException {
        if (index < 0 || this.mLength <= index) {
            throw new IndexOutOfBoundsException(String.format("Bad index: index=%d, length=%d", index, this.mLength));
        }
        return this.mBuffer.get(index);
    }

    private void expandBuffer(int newBufferSize) {
        ByteBuffer newBuffer = ByteBuffer.allocate(newBufferSize);
        this.mBuffer.position(0);
        newBuffer.put(this.mBuffer);
        this.mBuffer = newBuffer;
    }

    public void put(int data) {
        if (this.mBuffer.capacity() < this.mLength + 1) {
            this.expandBuffer(this.mLength + 1024);
        }
        this.mBuffer.put((byte)data);
        ++this.mLength;
    }

    public void put(byte[] data) {
        if (this.mBuffer.capacity() < this.mLength + data.length) {
            this.expandBuffer(this.mLength + data.length + 1024);
        }
        this.mBuffer.put(data);
        this.mLength += data.length;
    }

    public void put(ByteArray data, int index, int length) {
        if (this.mBuffer.capacity() < this.mLength + length) {
            this.expandBuffer(this.mLength + length + 1024);
        }
        byte[] bytes = data.mBuffer.array();
        this.mBuffer.put(bytes, index, length);
        this.mLength += length;
    }

    public byte[] toBytes(int beginIndex) {
        return this.toBytes(beginIndex, this.length());
    }

    public byte[] toBytes(int beginIndex, int endIndex) {
        int len = endIndex - beginIndex;
        if (len < 0 || beginIndex < 0 || this.mLength < endIndex) {
            throw new IllegalArgumentException(String.format("Bad range: beginIndex=%d, endIndex=%d, length=%d", beginIndex, endIndex, this.mLength));
        }
        byte[] bytes = new byte[len];
        if (len != 0) {
            System.arraycopy(this.mBuffer.array(), beginIndex, bytes, 0, len);
        }
        return bytes;
    }

    public void clear() {
        this.mBuffer.clear();
        this.mLength = 0;
    }

    public void shrink(int size) {
        if (this.mBuffer.capacity() <= size) {
            return;
        }
        int endIndex = this.mLength;
        int beginIndex = this.mLength - size;
        byte[] bytes = this.toBytes(beginIndex, endIndex);
        this.mBuffer = ByteBuffer.wrap(bytes);
        this.mLength = bytes.length;
    }
}

