/*
 * Decompiled with CFR 0.152.
 */
package com.neovisionaries.ws.client;

import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketFrame;
import java.util.Timer;
import java.util.TimerTask;

abstract class PeriodicalFrameSender {
    private final WebSocket mWebSocket;
    private final String mTimerName;
    private Timer mTimer;
    private boolean mScheduled;
    private long mInterval;
    private long mCount;

    public PeriodicalFrameSender(WebSocket webSocket, String timerName) {
        this.mWebSocket = webSocket;
        this.mTimerName = timerName;
    }

    public void start() {
        this.setInterval(this.getInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        PeriodicalFrameSender periodicalFrameSender = this;
        synchronized (periodicalFrameSender) {
            if (this.mTimer == null) {
                return;
            }
            this.mScheduled = false;
            this.mTimer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInterval() {
        PeriodicalFrameSender periodicalFrameSender = this;
        synchronized (periodicalFrameSender) {
            return this.mInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterval(long interval) {
        if (interval < 0L) {
            interval = 0L;
        }
        PeriodicalFrameSender periodicalFrameSender = this;
        synchronized (periodicalFrameSender) {
            this.mInterval = interval;
        }
        if (interval == 0L) {
            return;
        }
        if (!this.mWebSocket.isOpen()) {
            return;
        }
        periodicalFrameSender = this;
        synchronized (periodicalFrameSender) {
            if (this.mTimer == null) {
                this.mTimer = new Timer(this.mTimerName);
            }
            if (!this.mScheduled) {
                this.mScheduled = true;
                this.mTimer.schedule((TimerTask)new Task(), interval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTask() {
        PeriodicalFrameSender periodicalFrameSender = this;
        synchronized (periodicalFrameSender) {
            if (this.mInterval == 0L || !this.mWebSocket.isOpen()) {
                this.mScheduled = false;
                return;
            }
            this.mCount = Math.max(this.mCount + 1L, 1L);
            this.mWebSocket.sendFrame(this.createFrame(this.mCount));
            this.mTimer.schedule((TimerTask)new Task(), this.mInterval);
        }
    }

    protected abstract WebSocketFrame createFrame(long var1);

    private final class Task
    extends TimerTask {
        private Task() {
        }

        public void run() {
            PeriodicalFrameSender.this.doTask();
        }
    }
}

