/*
 * Decompiled with CFR 0.152.
 */
package com.neovisionaries.ws.client;

import com.neovisionaries.ws.client.Base64;
import com.neovisionaries.ws.client.ConnectThread;
import com.neovisionaries.ws.client.Connectable;
import com.neovisionaries.ws.client.HandshakeBuilder;
import com.neovisionaries.ws.client.ListenerManager;
import com.neovisionaries.ws.client.Misc;
import com.neovisionaries.ws.client.PingSender;
import com.neovisionaries.ws.client.PongSender;
import com.neovisionaries.ws.client.ReadingThread;
import com.neovisionaries.ws.client.StateManager;
import com.neovisionaries.ws.client.WebSocketError;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketExtension;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketInputStream;
import com.neovisionaries.ws.client.WebSocketListener;
import com.neovisionaries.ws.client.WebSocketOutputStream;
import com.neovisionaries.ws.client.WebSocketState;
import com.neovisionaries.ws.client.WritingThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocket {
    private static final String ACCEPT_MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final WebSocketFactory mWebSocketFactory;
    private final Socket mSocket;
    private final int mConnectionTimeout;
    private final StateManager mStateManager;
    private HandshakeBuilder mHandshakeBuilder;
    private final ListenerManager mListenerManager;
    private final PingSender mPingSender;
    private final PongSender mPongSender;
    private final Object mThreadsLock = new Object();
    private WebSocketInputStream mInput;
    private WebSocketOutputStream mOutput;
    private ReadingThread mReadingThread;
    private WritingThread mWritingThread;
    private Map<String, List<String>> mServerHeaders;
    private List<WebSocketExtension> mAgreedExtensions;
    private String mAgreedProtocol;
    private boolean mExtended;
    private boolean mAutoFlush = true;
    private boolean mOnConnectedCalled;
    private boolean mReadingThreadStarted;
    private boolean mWritingThreadStarted;
    private boolean mReadingThreadFinished;
    private boolean mWritingThreadFinished;
    private WebSocketFrame mServerCloseFrame;
    private WebSocketFrame mClientCloseFrame;

    WebSocket(WebSocketFactory factory, boolean secure, String userInfo, String host, String path, Socket socket, int timeout) {
        this.mWebSocketFactory = factory;
        this.mSocket = socket;
        this.mConnectionTimeout = timeout;
        this.mStateManager = new StateManager();
        this.mHandshakeBuilder = new HandshakeBuilder(secure, userInfo, host, path);
        this.mListenerManager = new ListenerManager(this);
        this.mPingSender = new PingSender(this);
        this.mPongSender = new PongSender(this);
    }

    public WebSocket recreate() throws IOException {
        return this.recreate(this.mConnectionTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSocket recreate(int timeout) throws IOException {
        List<WebSocketListener> listeners;
        if (timeout < 0) {
            throw new IllegalArgumentException("The given timeout value is negative.");
        }
        WebSocket instance = this.mWebSocketFactory.createSocket(this.getURI(), timeout);
        instance.mHandshakeBuilder = new HandshakeBuilder(this.mHandshakeBuilder);
        instance.setPingInterval(this.getPingInterval());
        instance.setPongInterval(this.getPongInterval());
        List<WebSocketListener> list = listeners = this.mListenerManager.getListeners();
        synchronized (list) {
            for (WebSocketListener listener : listeners) {
                instance.addListener(listener);
            }
        }
        return instance;
    }

    protected void finalize() throws Throwable {
        if (this.isInState(WebSocketState.CREATED)) {
            this.finish();
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSocketState getState() {
        StateManager stateManager = this.mStateManager;
        synchronized (stateManager) {
            return this.mStateManager.getState();
        }
    }

    public boolean isOpen() {
        return this.isInState(WebSocketState.OPEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInState(WebSocketState state) {
        StateManager stateManager = this.mStateManager;
        synchronized (stateManager) {
            return this.mStateManager.getState() == state;
        }
    }

    public WebSocket addProtocol(String protocol) {
        this.mHandshakeBuilder.addProtocol(protocol);
        return this;
    }

    public WebSocket addExtension(WebSocketExtension extension) {
        this.mHandshakeBuilder.addExtension(extension);
        return this;
    }

    public WebSocket addHeader(String name, String value) {
        this.mHandshakeBuilder.addHeader(name, value);
        return this;
    }

    public WebSocket setUserInfo(String userInfo) {
        this.mHandshakeBuilder.setUserInfo(userInfo);
        return this;
    }

    public WebSocket setUserInfo(String id, String password) {
        this.mHandshakeBuilder.setUserInfo(id, password);
        return this;
    }

    public boolean isExtended() {
        return this.mExtended;
    }

    public WebSocket setExtended(boolean extended) {
        this.mExtended = extended;
        return this;
    }

    public boolean isAutoFlush() {
        return this.mAutoFlush;
    }

    public WebSocket setAutoFlush(boolean auto) {
        this.mAutoFlush = auto;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSocket flush() {
        StateManager stateManager = this.mStateManager;
        synchronized (stateManager) {
            WebSocketState state = this.mStateManager.getState();
            if (state != WebSocketState.OPEN && state != WebSocketState.CLOSING) {
                return this;
            }
            this.mWritingThread.queueFlush();
        }
        return this;
    }

    public long getPingInterval() {
        return this.mPingSender.getInterval();
    }

    public WebSocket setPingInterval(long interval) {
        this.mPingSender.setInterval(interval);
        return this;
    }

    public long getPongInterval() {
        return this.mPongSender.getInterval();
    }

    public WebSocket setPongInterval(long interval) {
        this.mPongSender.setInterval(interval);
        return this;
    }

    public WebSocket addListener(WebSocketListener listener) {
        this.mListenerManager.addListener(listener);
        return this;
    }

    public Socket getSocket() {
        return this.mSocket;
    }

    public URI getURI() {
        return this.mHandshakeBuilder.getURI();
    }

    public WebSocket connect() throws WebSocketException {
        Map<String, List<String>> headers;
        this.changeStateOnConnect();
        try {
            headers = this.shakeHands();
        }
        catch (WebSocketException e) {
            this.mStateManager.setState(WebSocketState.CLOSED);
            this.mListenerManager.callOnStateChanged(WebSocketState.CLOSED);
            throw e;
        }
        this.mStateManager.setState(WebSocketState.OPEN);
        this.mListenerManager.callOnStateChanged(WebSocketState.OPEN);
        this.mServerHeaders = headers;
        this.startThreads();
        return this;
    }

    public Future<WebSocket> connect(ExecutorService executorService) {
        return executorService.submit(this.connectable());
    }

    public Callable<WebSocket> connectable() {
        return new Connectable(this);
    }

    public WebSocket connectAsynchronously() {
        new ConnectThread(this).start();
        return this;
    }

    public WebSocket disconnect() {
        return this.disconnect(1000, null);
    }

    public WebSocket disconnect(int closeCode) {
        return this.disconnect(closeCode, null);
    }

    public WebSocket disconnect(String reason) {
        return this.disconnect(1000, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSocket disconnect(int closeCode, String reason) {
        StateManager stateManager = this.mStateManager;
        synchronized (stateManager) {
            switch (this.mStateManager.getState()) {
                case CREATED: {
                    this.finishAsynchronously();
                    return this;
                }
                case OPEN: {
                    break;
                }
                default: {
                    return this;
                }
            }
            this.mStateManager.changeToClosing(StateManager.CloseInitiator.CLIENT);
            WebSocketFrame frame = WebSocketFrame.createCloseFrame(closeCode, reason);
            this.sendFrame(frame);
        }
        this.mListenerManager.callOnStateChanged(WebSocketState.CLOSING);
        this.stopThreads();
        return this;
    }

    public List<WebSocketExtension> getAgreedExtensions() {
        return this.mAgreedExtensions;
    }

    public String getAgreedProtocol() {
        return this.mAgreedProtocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSocket sendFrame(WebSocketFrame frame) {
        if (frame == null) {
            return this;
        }
        StateManager stateManager = this.mStateManager;
        synchronized (stateManager) {
            WebSocketState state = this.mStateManager.getState();
            if (state != WebSocketState.OPEN && state != WebSocketState.CLOSING) {
                return this;
            }
            this.mWritingThread.queueFrame(frame);
        }
        return this;
    }

    public WebSocket sendContinuation() {
        return this.sendFrame(WebSocketFrame.createContinuationFrame());
    }

    public WebSocket sendContinuation(boolean fin) {
        return this.sendFrame(WebSocketFrame.createContinuationFrame().setFin(fin));
    }

    public WebSocket sendContinuation(String payload) {
        return this.sendFrame(WebSocketFrame.createContinuationFrame(payload));
    }

    public WebSocket sendContinuation(String payload, boolean fin) {
        return this.sendFrame(WebSocketFrame.createContinuationFrame(payload).setFin(fin));
    }

    public WebSocket sendContinuation(byte[] payload) {
        return this.sendFrame(WebSocketFrame.createContinuationFrame(payload));
    }

    public WebSocket sendContinuation(byte[] payload, boolean fin) {
        return this.sendFrame(WebSocketFrame.createContinuationFrame(payload).setFin(fin));
    }

    public WebSocket sendText(String message) {
        return this.sendFrame(WebSocketFrame.createTextFrame(message));
    }

    public WebSocket sendText(String payload, boolean fin) {
        return this.sendFrame(WebSocketFrame.createTextFrame(payload).setFin(fin));
    }

    public WebSocket sendBinary(byte[] message) {
        return this.sendFrame(WebSocketFrame.createBinaryFrame(message));
    }

    public WebSocket sendBinary(byte[] payload, boolean fin) {
        return this.sendFrame(WebSocketFrame.createBinaryFrame(payload).setFin(fin));
    }

    public WebSocket sendClose() {
        return this.sendFrame(WebSocketFrame.createCloseFrame());
    }

    public WebSocket sendClose(int closeCode) {
        return this.sendFrame(WebSocketFrame.createCloseFrame(closeCode));
    }

    public WebSocket sendClose(int closeCode, String reason) {
        return this.sendFrame(WebSocketFrame.createCloseFrame(closeCode, reason));
    }

    public WebSocket sendPing() {
        return this.sendFrame(WebSocketFrame.createPingFrame());
    }

    public WebSocket sendPing(byte[] payload) {
        return this.sendFrame(WebSocketFrame.createPingFrame(payload));
    }

    public WebSocket sendPing(String payload) {
        return this.sendFrame(WebSocketFrame.createPingFrame(payload));
    }

    public WebSocket sendPong() {
        return this.sendFrame(WebSocketFrame.createPongFrame());
    }

    public WebSocket sendPong(byte[] payload) {
        return this.sendFrame(WebSocketFrame.createPongFrame(payload));
    }

    public WebSocket sendPong(String payload) {
        return this.sendFrame(WebSocketFrame.createPongFrame(payload));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeStateOnConnect() throws WebSocketException {
        StateManager stateManager = this.mStateManager;
        synchronized (stateManager) {
            if (this.mStateManager.getState() != WebSocketState.CREATED) {
                throw new WebSocketException(WebSocketError.NOT_IN_CREATED_STATE, "The current state of the web socket is not CREATED.");
            }
            this.mStateManager.setState(WebSocketState.CONNECTING);
        }
        this.mListenerManager.callOnStateChanged(WebSocketState.CONNECTING);
    }

    private Map<String, List<String>> shakeHands() throws WebSocketException {
        Socket socket = this.mSocket;
        WebSocketInputStream input = this.openInputStream(socket);
        WebSocketOutputStream output = this.openOutputStream(socket);
        String key = WebSocket.generateWebSocketKey();
        this.writeHandshake(output, key);
        Map<String, List<String>> headers = this.readHandshake(input, key);
        this.mInput = input;
        this.mOutput = output;
        return headers;
    }

    private WebSocketInputStream openInputStream(Socket socket) throws WebSocketException {
        try {
            return new WebSocketInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (IOException e) {
            throw new WebSocketException(WebSocketError.SOCKET_INPUT_STREAM_FAILURE, "Failed to get the input stream of the raw socket: " + e.getMessage(), e);
        }
    }

    private WebSocketOutputStream openOutputStream(Socket socket) throws WebSocketException {
        try {
            return new WebSocketOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        }
        catch (IOException e) {
            throw new WebSocketException(WebSocketError.SOCKET_OUTPUT_STREAM_FAILURE, "Failed to get the output stream from the raw socket: " + e.getMessage(), e);
        }
    }

    private static String generateWebSocketKey() {
        byte[] data = new byte[16];
        Misc.nextBytes(data);
        return Base64.encode(data);
    }

    private void writeHandshake(WebSocketOutputStream output, String key) throws WebSocketException {
        this.mHandshakeBuilder.setKey(key);
        String handshake = this.mHandshakeBuilder.build();
        try {
            output.write(handshake);
            output.flush();
        }
        catch (IOException e) {
            throw new WebSocketException(WebSocketError.OPENING_HAHDSHAKE_REQUEST_FAILURE, "Failed to send an opening handshake request to the server: " + e.getMessage(), e);
        }
    }

    private Map<String, List<String>> readHandshake(WebSocketInputStream input, String key) throws WebSocketException {
        this.readStatusLine(input);
        Map<String, List<String>> headers = this.readHttpHeaders(input);
        this.validateUpgrade(headers);
        this.validateConnection(headers);
        this.validateAccept(headers, key);
        this.validateExtensions(headers);
        this.validateProtocol(headers);
        return headers;
    }

    private void readStatusLine(WebSocketInputStream input) throws WebSocketException {
        String line;
        try {
            line = input.readLine();
        }
        catch (IOException e) {
            throw new WebSocketException(WebSocketError.OPENING_HANDSHAKE_RESPONSE_FAILURE, "Failed to read an opening handshake response from the server: " + e.getMessage(), e);
        }
        if (line == null || line.length() == 0) {
            throw new WebSocketException(WebSocketError.STATUS_LINE_EMPTY, "The status line of the opening handshake response is empty.");
        }
        String[] elements = line.split(" +", 3);
        if (elements.length < 2) {
            throw new WebSocketException(WebSocketError.STATUS_LINE_BAD_FORMAT, "The status line of the opening handshake response is badly formatted.");
        }
        if (!"101".equals(elements[1])) {
            throw new WebSocketException(WebSocketError.NOT_SWITCHING_PROTOCOLS, "The status code of the opening handshake response is not '101 Switching Protocols'. The status line is: " + line);
        }
    }

    private Map<String, List<String>> readHttpHeaders(WebSocketInputStream input) throws WebSocketException {
        TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        StringBuilder builder = null;
        while (true) {
            String line;
            try {
                line = input.readLine();
            }
            catch (IOException e) {
                throw new WebSocketException(WebSocketError.HTTP_HEADER_FAILURE, "An error occurred while HTTP header section was being read: " + e.getMessage(), e);
            }
            if (line == null || line.length() == 0) {
                if (builder == null) break;
                this.parseHttpHeader(headers, builder.toString());
                break;
            }
            char ch = line.charAt(0);
            if (ch == ' ' || ch == '\t') {
                if (builder == null) continue;
                line = line.replaceAll("^[ \t]+", " ");
                builder.append(line);
                continue;
            }
            if (builder != null) {
                this.parseHttpHeader(headers, builder.toString());
            }
            builder = new StringBuilder(line);
        }
        return headers;
    }

    private void parseHttpHeader(Map<String, List<String>> headers, String header) {
        String[] pair = header.split(":", 2);
        if (pair.length < 2) {
            return;
        }
        String name = pair[0].trim();
        String value = pair[1].trim();
        List<String> list = headers.get(name);
        if (list == null) {
            list = new ArrayList<String>();
            headers.put(name, list);
        }
        list.add(value);
    }

    private void validateUpgrade(Map<String, List<String>> headers) throws WebSocketException {
        List<String> values = headers.get("UPGRADE");
        if (values == null || values.size() == 0) {
            throw new WebSocketException(WebSocketError.NO_UPGRADE_HEADER, "The opening handshake response does not contain 'Upgrade' header.");
        }
        for (String value : values) {
            String[] elements;
            for (String element : elements = value.split("\\s*,\\s*")) {
                if (!"websocket".equalsIgnoreCase(element)) continue;
                return;
            }
        }
        throw new WebSocketException(WebSocketError.NO_WEBSOCKET_IN_UPGRADE_HEADER, "'websocket' was not found in 'Upgrade' header.");
    }

    private void validateConnection(Map<String, List<String>> headers) throws WebSocketException {
        List<String> values = headers.get("CONNECTION");
        if (values == null || values.size() == 0) {
            throw new WebSocketException(WebSocketError.NO_CONNECTION_HEADER, "The opening handshake response does not contain 'Connection' header.");
        }
        for (String value : values) {
            String[] elements;
            for (String element : elements = value.split("\\s*,\\s*")) {
                if (!"Upgrade".equalsIgnoreCase(element)) continue;
                return;
            }
        }
        throw new WebSocketException(WebSocketError.NO_UPGRADE_IN_CONNECTION_HEADER, "'Upgrade' was not found in 'Connection' header.");
    }

    private void validateAccept(Map<String, List<String>> headers, String key) throws WebSocketException {
        String expected;
        List<String> values = headers.get("SEC-WEBSOCKET-ACCEPT");
        if (values == null) {
            throw new WebSocketException(WebSocketError.NO_SEC_WEBSOCKET_ACCEPT_HEADER, "The opening handshake response does not contain 'Sec-WebSocket-Accept' header.");
        }
        String actual = values.get(0);
        String input = key + ACCEPT_MAGIC;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(Misc.getBytesUTF8(input));
            expected = Base64.encode(digest);
        }
        catch (Exception e) {
            return;
        }
        if (!expected.equals(actual)) {
            throw new WebSocketException(WebSocketError.UNEXPECTED_SEC_WEBSOCKET_ACCEPT_HEADER, "The value of 'Sec-WebSocket-Accept' header is different from the expected one.");
        }
    }

    private void validateExtensions(Map<String, List<String>> headers) throws WebSocketException {
        List<String> values = headers.get("SEC-WEBSOCKET-EXTENSIONS");
        if (values == null || values.size() == 0) {
            return;
        }
        ArrayList<WebSocketExtension> extensions = new ArrayList<WebSocketExtension>();
        for (String value : values) {
            String[] elements;
            for (String element : elements = value.split("\\s*,\\s*")) {
                WebSocketExtension extension = WebSocketExtension.parse(element);
                if (extension == null) {
                    throw new WebSocketException(WebSocketError.EXTENSION_PARSE_ERROR, "The value in 'Sec-WebSocket-Extensions' failed to be parsed: " + element);
                }
                String name = extension.getName();
                if (!this.mHandshakeBuilder.containsExtension(name)) {
                    throw new WebSocketException(WebSocketError.UNSUPPORTED_EXTENSION, "The extension contained in the Sec-WebSocket-Extensions header is not supported: " + name);
                }
                extensions.add(extension);
            }
        }
        this.mAgreedExtensions = extensions;
    }

    private void validateProtocol(Map<String, List<String>> headers) throws WebSocketException {
        List<String> values = headers.get("SEC-WEBSOCKET-PROTOCOL");
        if (values == null) {
            return;
        }
        String protocol = values.get(0);
        if (protocol == null || protocol.length() == 0) {
            return;
        }
        if (!this.mHandshakeBuilder.containsProtocol(protocol)) {
            throw new WebSocketException(WebSocketError.UNSUPPORTED_PROTOCOL, "The protocol contained in the Sec-WebSocket-Protocol header is not supported: " + protocol);
        }
        this.mAgreedProtocol = protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThreads() {
        ReadingThread readingThread = new ReadingThread(this);
        WritingThread writingThread = new WritingThread(this);
        Object object = this.mThreadsLock;
        synchronized (object) {
            this.mReadingThread = readingThread;
            this.mWritingThread = writingThread;
        }
        readingThread.start();
        writingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThreads() {
        WritingThread writingThread;
        ReadingThread readingThread;
        Object object = this.mThreadsLock;
        synchronized (object) {
            readingThread = this.mReadingThread;
            writingThread = this.mWritingThread;
            this.mReadingThread = null;
            this.mWritingThread = null;
        }
        if (readingThread != null) {
            readingThread.requestStop();
        }
        if (writingThread != null) {
            writingThread.requestStop();
        }
    }

    WebSocketInputStream getInput() {
        return this.mInput;
    }

    WebSocketOutputStream getOutput() {
        return this.mOutput;
    }

    StateManager getStateManager() {
        return this.mStateManager;
    }

    ListenerManager getListenerManager() {
        return this.mListenerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onReadingThreadStarted() {
        Object object = this.mThreadsLock;
        synchronized (object) {
            this.mReadingThreadStarted = true;
            this.callOnConnectedIfNotYet();
            if (!this.mWritingThreadStarted) {
                return;
            }
        }
        this.onThreadsStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWritingThreadStarted() {
        Object object = this.mThreadsLock;
        synchronized (object) {
            this.mWritingThreadStarted = true;
            this.callOnConnectedIfNotYet();
            if (!this.mReadingThreadStarted) {
                return;
            }
        }
        this.onThreadsStarted();
    }

    private void callOnConnectedIfNotYet() {
        if (this.mOnConnectedCalled) {
            return;
        }
        this.mListenerManager.callOnConnected(this.mServerHeaders);
        this.mOnConnectedCalled = true;
    }

    private void onThreadsStarted() {
        this.mPingSender.start();
        this.mPongSender.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onReadingThreadFinished(WebSocketFrame closeFrame) {
        Object object = this.mThreadsLock;
        synchronized (object) {
            this.mReadingThreadFinished = true;
            this.mServerCloseFrame = closeFrame;
            if (!this.mWritingThreadFinished) {
                return;
            }
        }
        this.onThreadsFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWritingThreadFinished(WebSocketFrame closeFrame) {
        Object object = this.mThreadsLock;
        synchronized (object) {
            this.mWritingThreadFinished = true;
            this.mClientCloseFrame = closeFrame;
            if (!this.mReadingThreadFinished) {
                return;
            }
        }
        this.onThreadsFinished();
    }

    private void onThreadsFinished() {
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        this.mPingSender.stop();
        this.mPongSender.stop();
        try {
            this.mSocket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        StateManager stateManager = this.mStateManager;
        synchronized (stateManager) {
            this.mStateManager.setState(WebSocketState.CLOSED);
        }
        this.mListenerManager.callOnStateChanged(WebSocketState.CLOSED);
        this.mListenerManager.callOnDisconnected(this.mServerCloseFrame, this.mClientCloseFrame, this.mStateManager.getClosedByServer());
    }

    private void finishAsynchronously() {
        new Thread(){

            public void run() {
                WebSocket.this.finish();
            }
        }.start();
    }
}

