/*
 * Decompiled with CFR 0.152.
 */
package com.neovisionaries.ws.client;

import com.neovisionaries.ws.client.WebSocket;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class WebSocketFactory {
    private SocketFactory mSocketFactory;
    private SSLSocketFactory mSSLSocketFactory;
    private SSLContext mSSLContext;

    public SocketFactory getSocketFactory() {
        return this.mSocketFactory;
    }

    public WebSocketFactory setSocketFactory(SocketFactory factory) {
        this.mSocketFactory = factory;
        return this;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.mSSLSocketFactory;
    }

    public WebSocketFactory setSSLSocketFactory(SSLSocketFactory factory) {
        this.mSSLSocketFactory = factory;
        return this;
    }

    public SSLContext getSSLContext() {
        return this.mSSLContext;
    }

    public WebSocketFactory setSSLContext(SSLContext context) {
        this.mSSLContext = context;
        return this;
    }

    public WebSocket createSocket(String uri) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("The given URI is null.");
        }
        return this.createSocket(URI.create(uri));
    }

    public WebSocket createSocket(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("The given URL is null.");
        }
        try {
            return this.createSocket(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to convert the given URL into a URI.");
        }
    }

    public WebSocket createSocket(URI uri) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("The given URI is null.");
        }
        String scheme = uri.getScheme();
        String userInfo = uri.getUserInfo();
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        String query = uri.getQuery();
        return this.createSocket(scheme, userInfo, host, port, path, query);
    }

    private WebSocket createSocket(String scheme, String userInfo, String host, int port, String path, String query) throws IOException {
        boolean secure = WebSocketFactory.isSecureConnectionRequired(scheme);
        if (host == null || host.length() == 0) {
            throw new IllegalArgumentException("The host part is empty.");
        }
        path = WebSocketFactory.determinePath(path);
        Socket socket = this.createRawSocket(host, port, secure);
        return this.createWebSocket(userInfo, host, port, path, query, socket);
    }

    private static boolean isSecureConnectionRequired(String scheme) {
        if (scheme == null || scheme.length() == 0) {
            throw new IllegalArgumentException("The scheme part is empty.");
        }
        if ("wss".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
            return true;
        }
        if ("ws".equalsIgnoreCase(scheme) || "http".equalsIgnoreCase(scheme)) {
            return false;
        }
        throw new IllegalArgumentException("Bad scheme: " + scheme);
    }

    private static String determinePath(String path) {
        if (path == null || path.length() == 0) {
            return "/";
        }
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    private Socket createRawSocket(String host, int port, boolean secure) throws IOException {
        port = WebSocketFactory.determinePort(port, secure);
        SocketFactory factory = this.determineSocketFactory(secure);
        return factory.createSocket(host, port);
    }

    private static int determinePort(int port, boolean secure) {
        if (0 <= port) {
            return port;
        }
        if (secure) {
            return 443;
        }
        return 80;
    }

    private SocketFactory determineSocketFactory(boolean secure) {
        if (secure) {
            if (this.mSSLContext != null) {
                return this.mSSLContext.getSocketFactory();
            }
            if (this.mSSLSocketFactory != null) {
                return this.mSSLSocketFactory;
            }
            return SSLSocketFactory.getDefault();
        }
        if (this.mSocketFactory != null) {
            return this.mSocketFactory;
        }
        return SocketFactory.getDefault();
    }

    private WebSocket createWebSocket(String userInfo, String host, int port, String path, String query, Socket socket) {
        if (0 <= port) {
            host = host + ":" + port;
        }
        if (query != null) {
            path = path + "?" + query;
        }
        return new WebSocket(userInfo, host, path, socket);
    }
}

