/*
 * Decompiled with CFR 0.152.
 */
package com.ncorti.ktfmt.gradle.tasks.worker;

import com.facebook.ktfmt.format.Formatter;
import com.facebook.ktfmt.format.FormattingOptions;
import com.facebook.ktfmt.format.ParseError;
import com.google.common.collect.ImmutableList;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.FormattingError;
import com.ncorti.ktfmt.gradle.FormattingOptionsBean;
import com.ncorti.ktfmt.gradle.tasks.worker.KtfmtFormatterKt;
import com.ncorti.ktfmt.gradle.tasks.worker.KtfmtResult;
import com.ncorti.ktfmt.gradle.util.KtfmtLoggerKt;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ncorti/ktfmt/gradle/tasks/worker/KtfmtFormatter;", "", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "format", "Lcom/ncorti/ktfmt/gradle/tasks/worker/KtfmtResult;", "ctx", "Lcom/ncorti/ktfmt/gradle/tasks/worker/KtfmtFormatter$FormatContext;", "FormatContext", "plugin"})
public final class KtfmtFormatter {
    @NotNull
    public static final KtfmtFormatter INSTANCE = new KtfmtFormatter();
    private static final Logger logger = Logging.getLogger(KtfmtFormatter.class);

    private KtfmtFormatter() {
    }

    @NotNull
    public final KtfmtResult format(@NotNull FormatContext ctx) {
        KtfmtResult ktfmtResult;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Logger logger = KtfmtFormatter.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        KtfmtLoggerKt.d(logger, "Formatting: " + ctx);
        if (!((Collection)ctx.getIncludedFiles()).isEmpty() && !ctx.getIncludedFiles().contains(ctx.getSourceFile().getCanonicalFile())) {
            return new KtfmtResult.KtfmtSkipped(ctx.getSourceFile(), "Not included inside --include-only");
        }
        try {
            String originCode = FilesKt.readText$default((File)ctx.getSourceFile(), null, (int)1, null);
            String formattedCode = Formatter.format((FormattingOptions)KtfmtFormatterKt.toFormattingOptions(ctx.getFormattingOptions()), (String)originCode);
            boolean isCorrectlyFormatted = Intrinsics.areEqual((Object)originCode, (Object)formattedCode);
            ktfmtResult = new KtfmtResult.KtfmtSuccess(ctx.getSourceFile(), isCorrectlyFormatted, formattedCode);
        }
        catch (Throwable cause) {
            String string;
            Throwable throwable = cause;
            if (throwable instanceof IOException) {
                string = "Unable to read file";
            } else if (throwable instanceof ParseError) {
                string = "Failed to parse file";
            } else if (throwable instanceof FormattingError) {
                ImmutableList immutableList = ((FormattingError)cause).diagnostics();
                Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"cause.diagnostics()");
                string = CollectionsKt.joinToString$default((Iterable)((Iterable)immutableList), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<FormatterDiagnostic, CharSequence>(ctx){
                    final /* synthetic */ FormatContext $ctx;
                    {
                        this.$ctx = $ctx;
                        super(1);
                    }

                    public final CharSequence invoke(FormatterDiagnostic it) {
                        return this.$ctx.getSourceFile() + ":" + it;
                    }
                }), (int)30, null);
            } else {
                string = "Generic error during file processing";
            }
            String message2 = string;
            ktfmtResult = new KtfmtResult.KtfmtFailure(ctx.getSourceFile(), message2, cause);
        }
        return ktfmtResult;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J7\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/ncorti/ktfmt/gradle/tasks/worker/KtfmtFormatter$FormatContext;", "", "sourceFile", "Ljava/io/File;", "includedFiles", "", "formattingOptions", "Lcom/ncorti/ktfmt/gradle/FormattingOptionsBean;", "sourceRoot", "(Ljava/io/File;Ljava/util/Set;Lcom/ncorti/ktfmt/gradle/FormattingOptionsBean;Ljava/io/File;)V", "getFormattingOptions", "()Lcom/ncorti/ktfmt/gradle/FormattingOptionsBean;", "getIncludedFiles", "()Ljava/util/Set;", "getSourceFile", "()Ljava/io/File;", "getSourceRoot", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "plugin"})
    public static final class FormatContext {
        @NotNull
        private final File sourceFile;
        @NotNull
        private final Set<File> includedFiles;
        @NotNull
        private final FormattingOptionsBean formattingOptions;
        @NotNull
        private final File sourceRoot;

        public FormatContext(@NotNull File sourceFile, @NotNull Set<? extends File> includedFiles, @NotNull FormattingOptionsBean formattingOptions, @NotNull File sourceRoot) {
            Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
            Intrinsics.checkNotNullParameter(includedFiles, (String)"includedFiles");
            Intrinsics.checkNotNullParameter((Object)formattingOptions, (String)"formattingOptions");
            Intrinsics.checkNotNullParameter((Object)sourceRoot, (String)"sourceRoot");
            this.sourceFile = sourceFile;
            this.includedFiles = includedFiles;
            this.formattingOptions = formattingOptions;
            this.sourceRoot = sourceRoot;
        }

        public /* synthetic */ FormatContext(File file, Set set, FormattingOptionsBean formattingOptionsBean, File file2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                set = SetsKt.emptySet();
            }
            if ((n & 4) != 0) {
                formattingOptionsBean = new FormattingOptionsBean(0, 0, 0, false, false, false, 63, null);
            }
            this(file, set, formattingOptionsBean, file2);
        }

        @NotNull
        public final File getSourceFile() {
            return this.sourceFile;
        }

        @NotNull
        public final Set<File> getIncludedFiles() {
            return this.includedFiles;
        }

        @NotNull
        public final FormattingOptionsBean getFormattingOptions() {
            return this.formattingOptions;
        }

        @NotNull
        public final File getSourceRoot() {
            return this.sourceRoot;
        }

        @NotNull
        public final File component1() {
            return this.sourceFile;
        }

        @NotNull
        public final Set<File> component2() {
            return this.includedFiles;
        }

        @NotNull
        public final FormattingOptionsBean component3() {
            return this.formattingOptions;
        }

        @NotNull
        public final File component4() {
            return this.sourceRoot;
        }

        @NotNull
        public final FormatContext copy(@NotNull File sourceFile, @NotNull Set<? extends File> includedFiles, @NotNull FormattingOptionsBean formattingOptions, @NotNull File sourceRoot) {
            Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
            Intrinsics.checkNotNullParameter(includedFiles, (String)"includedFiles");
            Intrinsics.checkNotNullParameter((Object)formattingOptions, (String)"formattingOptions");
            Intrinsics.checkNotNullParameter((Object)sourceRoot, (String)"sourceRoot");
            return new FormatContext(sourceFile, includedFiles, formattingOptions, sourceRoot);
        }

        public static /* synthetic */ FormatContext copy$default(FormatContext formatContext, File file, Set set, FormattingOptionsBean formattingOptionsBean, File file2, int n, Object object) {
            if ((n & 1) != 0) {
                file = formatContext.sourceFile;
            }
            if ((n & 2) != 0) {
                set = formatContext.includedFiles;
            }
            if ((n & 4) != 0) {
                formattingOptionsBean = formatContext.formattingOptions;
            }
            if ((n & 8) != 0) {
                file2 = formatContext.sourceRoot;
            }
            return formatContext.copy(file, set, formattingOptionsBean, file2);
        }

        @NotNull
        public String toString() {
            return "FormatContext(sourceFile=" + this.sourceFile + ", includedFiles=" + this.includedFiles + ", formattingOptions=" + this.formattingOptions + ", sourceRoot=" + this.sourceRoot + ")";
        }

        public int hashCode() {
            int result = this.sourceFile.hashCode();
            result = result * 31 + ((Object)this.includedFiles).hashCode();
            result = result * 31 + this.formattingOptions.hashCode();
            result = result * 31 + this.sourceRoot.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FormatContext)) {
                return false;
            }
            FormatContext formatContext = (FormatContext)other;
            if (!Intrinsics.areEqual((Object)this.sourceFile, (Object)formatContext.sourceFile)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.includedFiles, formatContext.includedFiles)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.formattingOptions, (Object)formatContext.formattingOptions)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sourceRoot, (Object)formatContext.sourceRoot);
        }
    }
}

