/*
 * Decompiled with CFR 0.152.
 */
package com.naver.speech.clientapi;

public class SpeechConfig {
    private ServiceType mServiceType = ServiceType.OPENAPI;
    private LanguageType mLanguageType;
    private CaptureType mCaptureType;
    private WakewordType mWakewordType;
    private EndPointDetectType mEndPointDetectType;
    private ConnectionType mConnectionType;
    private boolean mQuestionDetection;
    private String mExtraInfo;

    public SpeechConfig(LanguageType languageType, EndPointDetectType endPointDetectType) {
        this.mLanguageType = languageType;
        this.mCaptureType = CaptureType.PRESS;
        this.mWakewordType = WakewordType.CLOVA;
        this.mQuestionDetection = false;
        this.mEndPointDetectType = endPointDetectType;
        this.mConnectionType = ConnectionType.GRPC_SECURE;
        this.mExtraInfo = null;
    }

    ServiceType getServiceType() {
        return this.mServiceType;
    }

    public LanguageType getLanguageType() {
        return this.mLanguageType;
    }

    public CaptureType getCaptureType() {
        return this.mCaptureType;
    }

    public WakewordType getWakewordType() {
        return this.mWakewordType;
    }

    public EndPointDetectType getEndPointDetectType() {
        return this.mEndPointDetectType;
    }

    public ConnectionType getConnectionType() {
        return this.mConnectionType;
    }

    boolean isQuestionDetection() {
        return this.mQuestionDetection;
    }

    String getExtraInfo() {
        return this.mExtraInfo;
    }

    public static enum ConnectionType {
        GRPC_SECURE(2);

        private int connectionType;

        private ConnectionType(int connectionType) {
            this.connectionType = connectionType;
        }

        public int toInteger() {
            return this.connectionType;
        }
    }

    public static enum DomainType {
        NORMAL(0),
        GOV(1),
        FIN(2);

        private int domainType;

        private DomainType(int domainType) {
            this.domainType = domainType;
        }

        public int toInteger() {
            return this.domainType;
        }
    }

    public static enum EndPointDetectType {
        AUTO(0),
        MANUAL(1),
        HYBRID(2);

        private int epdType;

        private EndPointDetectType(int epdType) {
            this.epdType = epdType;
        }

        public int toInteger() {
            return this.epdType;
        }
    }

    public static enum WakewordType {
        CLOVA(0);

        private int wakewordType;

        private WakewordType(int wakewordType) {
            this.wakewordType = wakewordType;
        }

        int toInteger() {
            return this.wakewordType;
        }
    }

    public static enum CaptureType {
        PRESS(0);

        private int captureType;

        private CaptureType(int captureType) {
            this.captureType = captureType;
        }

        int toInteger() {
            return this.captureType;
        }
    }

    public static enum LanguageType {
        KOREAN(0),
        JAPANESE(1),
        ENGLISH(2),
        CHINESE(3);

        private int languageType;

        private LanguageType(int languageType) {
            this.languageType = languageType;
        }

        int toInteger() {
            return this.languageType;
        }
    }

    public static enum ServiceType {
        OPENAPI(4);

        private int serviceType;

        private ServiceType(int serviceType) {
            this.serviceType = serviceType;
        }

        int toInteger() {
            return this.serviceType;
        }
    }
}

