/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.mapviewer.overlay;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.nhn.android.maps.NMapController;
import com.nhn.android.maps.NMapItemizedOverlay;
import com.nhn.android.maps.NMapOverlay;
import com.nhn.android.maps.NMapOverlayItem;
import com.nhn.android.maps.NMapView;
import com.nhn.android.maps.g;
import com.nhn.android.maps.maplib.NGeoPoint;
import com.nhn.android.maps.maplib.NMapConverter;
import com.nhn.android.maps.maplib.e;
import com.nhn.android.maps.overlay.NMapPOIdata;
import com.nhn.android.maps.overlay.NMapPOIitem;
import com.nhn.android.mapviewer.overlay.NMapOverlayManager;

public class NMapPOIdataOverlay
extends NMapItemizedOverlay {
    private final NMapController a;
    private final NMapOverlayManager b;
    private boolean c;
    private boolean d;
    private final NMapPOIdata e;
    private OnStateChangeListener f;
    private int g;
    private NMapPOIitem h;
    private NMapPOIitem i;
    private NMapPOIitem j;
    private MotionEvent k;
    private OnFloatingItemChangeListener l;
    private OnDragItemChangeListener m;
    private OnFloatingItemDispatchListener n;
    private OnInfoLayersListener o;
    private final Rect p = new Rect();
    private final Rect q = new Rect();
    private final Point r = new Point();
    private final Point s = new Point();
    private int t;
    private int u;
    private final Runnable v = new Runnable(){

        @Override
        public void run() {
            if (NMapPOIdataOverlay.this.j != null) {
                NMapPOIdataOverlay.this.a(NMapPOIdataOverlay.this.j, NMapPOIdataOverlay.this.k);
                if (NMapPOIdataOverlay.this.j.getVisibility() != 0) {
                    NMapPOIdataOverlay.this.j = null;
                }
            }
        }
    };
    private e w;
    private boolean x = false;
    private boolean y = false;

    public NMapPOIdataOverlay(NMapPOIdata nMapPOIdata, Drawable drawable2, NMapController nMapController, NMapOverlayManager nMapOverlayManager) {
        super(drawable2);
        if (drawable2 != null && drawable2.getBounds().isEmpty()) {
            NMapOverlayItem.boundCenterBottom(drawable2);
        }
        if (nMapPOIdata == null) {
            throw new IllegalArgumentException("NMapPOIdataOverlay cannot be created without instances of NMapPOIdata.");
        }
        if (nMapController == null) {
            throw new IllegalArgumentException("NMapPOIdataOverlay cannot be created without instances of NMapController.");
        }
        this.a = nMapController;
        this.b = nMapOverlayManager;
        this.e = nMapPOIdata;
        this.d = false;
        this.f = null;
        this.b();
    }

    public NMapPOIdata getPOIdata() {
        return this.e;
    }

    public NMapPOIitem getPOIitemAtIndex(int n2) {
        return this.e.getPOIitem(n2);
    }

    public boolean isFocusedBySelectItem() {
        return this.c;
    }

    public void updateMarkerForPOIitem(NMapPOIitem nMapPOIitem) {
        if (nMapPOIitem != null) {
            super.updateMarkerForItem(nMapPOIitem);
            this.b.populate();
        }
    }

    public void updateMarkerAtIndex(int n2) {
        NMapPOIitem nMapPOIitem = this.e.getPOIitem(n2);
        this.updateMarkerForPOIitem(nMapPOIitem);
    }

    public void showAllPOIdata(int n2) {
        if (this.b != null) {
            this.b.hideOverlappedView();
        }
        this.a.zoomToBoundsE6(super.getBoundsE6(), n2);
    }

    public boolean isLocationInBounds(double d2, double d3) {
        Rect rect = super.getBoundsE6();
        int n2 = NGeoPoint.toLongitudeE6(d2);
        int n3 = NGeoPoint.toLatitudeE6(d3);
        return n2 > rect.left && n2 < rect.right && n3 < rect.top && n3 > rect.bottom;
    }

    public void setNotifyMapCenterBeforeAnimEnd(boolean bl) {
        this.d = bl;
    }

    public boolean hasNotifiedMapCenterBeforeAnimEnd() {
        return this.d;
    }

    public void selectPOIitem(int n2, boolean bl) {
        NMapPOIitem nMapPOIitem = this.e.getPOIitem(n2);
        this.a(nMapPOIitem, n2, bl, true);
    }

    public void selectPOIitemBy(Object object, boolean bl) {
        int n2 = this.e.indexOfItemWith(object);
        if (n2 > -1) {
            this.selectPOIitem(n2, bl);
        }
    }

    public void selectPOIitemBy(int n2, boolean bl) {
        int n3 = this.e.indexOfItemWith(n2);
        if (n3 > -1) {
            this.selectPOIitem(n3, bl);
        }
    }

    public void deselectFocusedPOIitem() {
        this.c();
    }

    public void removePOIitem(Object object) {
        if (this.e.removePOIitem(object)) {
            this.b();
        }
    }

    public void removePOIitem(int n2) {
        if (this.e.removePOIitem(n2)) {
            this.b();
        }
    }

    public void removePOIdata(int n2, int n3) {
        if (this.e.removePOIdata(n2, n3)) {
            this.b();
        }
    }

    public void removeAllPOIdata() {
        this.e.removeAllPOIdata();
        this.b();
    }

    public void setOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.f = onStateChangeListener;
    }

    public OnStateChangeListener getOnStateChangeListener() {
        return this.f;
    }

    protected void a(NMapPOIitem nMapPOIitem) {
        if (this.f != null) {
            this.f.onFocusChanged(this, nMapPOIitem);
        }
    }

    protected void b(NMapPOIitem nMapPOIitem) {
        if (this.f != null) {
            this.f.onCalloutClick(this, nMapPOIitem);
        }
    }

    public void setOnInfoLayersListener(OnInfoLayersListener onInfoLayersListener) {
        this.o = onInfoLayersListener;
    }

    protected void a() {
        if (this.o != null) {
            this.o.onInfoLayersCleared(this);
        }
    }

    public void setOnFloatingItemChangeListener(OnFloatingItemChangeListener onFloatingItemChangeListener) {
        this.l = onFloatingItemChangeListener;
    }

    protected void c(NMapPOIitem nMapPOIitem) {
        if (this.l != null) {
            this.l.onPointChanged(this, nMapPOIitem);
        }
    }

    public void setOnFloatingItemDispatchListener(OnFloatingItemDispatchListener onFloatingItemDispatchListener) {
        this.n = onFloatingItemDispatchListener;
    }

    protected void a(NMapPOIitem nMapPOIitem, MotionEvent motionEvent) {
        if (this.n != null && this.n.onDispatchStart(this, nMapPOIitem, motionEvent)) {
            nMapPOIitem.setVisibility(8);
            this.b.populate();
        }
    }

    protected void a(OnDragItemChangeListener onDragItemChangeListener) {
        this.m = onDragItemChangeListener;
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent, NMapView nMapView) {
        if (this.a(motionEvent, nMapView)) {
            return true;
        }
        int n2 = motionEvent.getAction();
        int n3 = (int)motionEvent.getX();
        int n4 = (int)motionEvent.getY();
        boolean bl = super.onTouchEvent(motionEvent, nMapView);
        if (bl) {
            switch (n2) {
                case 0: {
                    this.t = n3;
                    this.u = n4;
                    NMapPOIitem nMapPOIitem = (NMapPOIitem)super.getPressedItem();
                    if (this.j == null) {
                        if (nMapPOIitem != null && nMapPOIitem.isDispatchable()) {
                            this.a(nMapView, nMapPOIitem, motionEvent);
                        }
                    } else {
                        this.a(nMapView);
                    }
                    if ((this.g & 8) == 0) break;
                    this.a(nMapView, (NMapPOIitem)super.getPressedItem());
                    break;
                }
                case 1: {
                    if (this.j == null) break;
                    this.a(nMapView);
                }
            }
        } else if (this.j != null) {
            this.a(nMapView);
        }
        return bl;
    }

    @Override
    public boolean onTap(int n2, int n3, NMapView nMapView) {
        boolean bl = super.onTap(n2, n3, nMapView);
        if (!bl) {
            this.a(n2, n3, nMapView);
        }
        return bl;
    }

    @Override
    protected void drawItem(Canvas canvas, NMapView nMapView, boolean bl, Drawable drawable2, NMapOverlayItem nMapOverlayItem) {
        if (nMapOverlayItem == this.i) {
            if (nMapView.isAutoRotateEnabled()) {
                canvas.save(1);
                Matrix matrix = canvas.getMatrix();
                matrix.preRotate(-nMapView.getRoateAngle(), (float)this.s.x, (float)this.s.y);
                canvas.setMatrix(matrix);
            }
            NMapOverlay.drawAt(canvas, drawable2, this.s.x, this.s.y, bl);
            if (nMapView.isAutoRotateEnabled()) {
                canvas.restore();
            }
        } else {
            super.drawItem(canvas, nMapView, bl, drawable2, nMapOverlayItem);
        }
    }

    @Override
    protected boolean onTap(int n2) {
        if (this.mLastFocusedIndex != n2) {
            this.a(n2);
        } else {
            this.a(-1);
        }
        return true;
    }

    @Override
    protected NMapOverlayItem createItem(int n2) {
        NMapPOIitem nMapPOIitem = this.e.getPOIitem(n2);
        if (nMapPOIitem != null) {
            this.g |= nMapPOIitem.getFloatingMode();
            if (nMapPOIitem.isTouchable()) {
                this.h = nMapPOIitem;
            }
        }
        return nMapPOIitem;
    }

    @Override
    public int size() {
        return this.e.count();
    }

    @Override
    public void setHidden(boolean bl) {
        if (this.isHidden() == bl) {
            return;
        }
        super.setHidden(bl);
        if (bl) {
            if (this.b.hasCalloutOverlay(this)) {
                this.b.clearCalloutOverlay();
            } else {
                this.deselectFocusedPOIitem();
            }
        }
    }

    private void a(NMapPOIitem nMapPOIitem, int n2, int n3, Rect rect) {
        rect.set(this.getItemBounds(nMapPOIitem));
        rect.offset(n2, n3);
        rect.inset(-1, -1);
    }

    private void a(NMapView nMapView, NMapPOIitem nMapPOIitem, MotionEvent motionEvent) {
        if (nMapPOIitem != null && nMapPOIitem.isDispatchable()) {
            this.j = nMapPOIitem;
            this.k = motionEvent;
            nMapView.postDelayed(this.v, 250L);
        } else {
            this.j = null;
            this.k = null;
        }
    }

    private void a(NMapView nMapView) {
        if (this.j != null) {
            this.j = null;
            this.k = null;
            nMapView.removeCallbacks(this.v);
        }
    }

    private void a(NMapView nMapView, NMapPOIitem nMapPOIitem) {
        if (nMapPOIitem != null && nMapPOIitem.isDraggable()) {
            this.i = nMapPOIitem;
            nMapView.getMapProjection().toPixels(this.i.getPointInUtmk(), this.r);
            this.a(this.i, this.r.x, this.r.y, this.q);
            this.s.set(this.r.x, this.r.y);
            if (this.m != null) {
                this.m.onDragStarted(this, this.i);
            }
        } else {
            this.i = null;
        }
    }

    private boolean a(MotionEvent motionEvent, NMapView nMapView) {
        if (this.i != null) {
            int n2 = motionEvent.getAction();
            int n3 = (int)motionEvent.getX();
            int n4 = (int)motionEvent.getY();
            this.s.x = this.r.x + (n3 - this.t);
            this.s.y = this.r.y + (n4 - this.u);
            if (n2 == 2) {
                this.p.set(this.q);
                this.a(this.i, this.s.x, this.s.y, this.q);
                this.p.union(this.q);
                if (nMapView.isAutoRotateEnabled()) {
                    nMapView.postInvalidate();
                } else {
                    nMapView.postInvalidate(this.p.left, this.p.top, this.p.right, this.p.bottom);
                }
                return true;
            }
            NGeoPoint nGeoPoint = nMapView.getMapProjection().fromPixels(this.s.x, this.s.y);
            this.i.setPoint(nGeoPoint);
            this.c(this.i);
            if (this.m != null) {
                this.m.onDragEnded(this, this.i);
            }
            this.i = null;
        }
        return false;
    }

    private void a(int n2, int n3, NMapView nMapView) {
        if (this.h != null) {
            NGeoPoint nGeoPoint = nMapView.getMapProjection().fromPixels(n2, n3);
            this.h.setPoint(nGeoPoint);
            this.c(this.h);
            nMapView.postInvalidate();
        }
    }

    public void selectPOIitem(NMapPOIitem nMapPOIitem, boolean bl) {
        this.selectPOIitem(nMapPOIitem, bl, true);
    }

    public void selectPOIitem(NMapPOIitem nMapPOIitem, boolean bl, boolean bl2) {
        int n2 = this.e.indexOf(nMapPOIitem);
        this.a(nMapPOIitem, n2, bl, bl2);
    }

    private void a(NMapPOIitem nMapPOIitem, int n2, boolean bl, boolean bl2) {
        if (nMapPOIitem != null) {
            if (this.b != null) {
                this.b.hideOverlappedView();
            }
            this.c = bl2;
            this.a(n2);
            this.c = false;
            if (bl) {
                this.a.animateTo(nMapPOIitem, this.d);
            }
        }
    }

    private void b() {
        this.g = 0;
        this.h = null;
        this.i = null;
        this.j = null;
        this.k = null;
        super.populate();
        super.setLastFocusedIndex(-1);
    }

    private void a(int n2) {
        NMapPOIitem nMapPOIitem = this.e.getPOIitem(n2);
        if (nMapPOIitem != null) {
            super.setFocus(nMapPOIitem);
            this.x = true;
        } else {
            this.setLastFocusedIndex(-1);
        }
    }

    private void c() {
        if (this.mLastFocusedIndex > -1) {
            this.a(-1);
        }
    }

    public int findClosestPoiIndex(NGeoPoint nGeoPoint) {
        int n2 = 0;
        double d2 = Double.MAX_VALUE;
        int n3 = this.size();
        for (int i2 = 1; i2 < n3; ++i2) {
            double d3;
            NMapPOIitem nMapPOIitem = this.getPOIitemAtIndex(i2);
            if (nMapPOIitem == null || !((d3 = NMapConverter.distLoLa(nGeoPoint, nMapPOIitem.getPoint())) < d2)) continue;
            d2 = d3;
            n2 = i2;
        }
        return n2;
    }

    public void setEnableFocusedItemAnimation(boolean bl) {
        this.y = bl;
    }

    @Override
    protected void setFocusedItemAnimationMatrix(Canvas canvas, NMapView nMapView, long l2, int n2, int n3) {
        if (this.x) {
            if (this.y) {
                if (com.nhn.android.maps.g.a().a(canvas)) {
                    this.x = false;
                    return;
                }
                if (this.w == null) {
                    this.w = new e((Interpolator)new LinearInterpolator(), 300L);
                    this.w.a(0.5f, 1.0f);
                    this.w.a(true);
                }
                if (this.w.b(l2)) {
                    this.x = false;
                    if (!this.w.a()) {
                        this.w.b();
                        this.w = null;
                    }
                } else {
                    float f2 = this.w.c(l2);
                    Matrix matrix = canvas.getMatrix();
                    matrix.preScale(f2, f2, (float)n2, (float)n3);
                    canvas.setMatrix(matrix);
                    nMapView.postInvalidate();
                }
            } else {
                this.x = false;
            }
        }
    }

    public static interface OnInfoLayersListener {
        public void onInfoLayersCleared(NMapPOIdataOverlay var1);
    }

    public static interface OnFloatingItemDispatchListener {
        public boolean onDispatchStart(NMapPOIdataOverlay var1, NMapPOIitem var2, MotionEvent var3);
    }

    protected static interface OnDragItemChangeListener {
        public void onDragStarted(NMapPOIdataOverlay var1, NMapPOIitem var2);

        public void onDragEnded(NMapPOIdataOverlay var1, NMapPOIitem var2);
    }

    public static interface OnFloatingItemChangeListener {
        public void onPointChanged(NMapPOIdataOverlay var1, NMapPOIitem var2);
    }

    public static interface OnStateChangeListener {
        public void onFocusChanged(NMapPOIdataOverlay var1, NMapPOIitem var2);

        public void onCalloutClick(NMapPOIdataOverlay var1, NMapPOIitem var2);
    }
}

