/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.maps;

import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Message;
import android.support.annotation.ColorInt;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import com.nhn.android.maps.NMapOverlayItem;
import com.nhn.android.maps.NMapProjection;
import com.nhn.android.maps.NMapTrafficVersion;
import com.nhn.android.maps.NMapView;
import com.nhn.android.maps.e;
import com.nhn.android.maps.i;
import com.nhn.android.maps.j;
import com.nhn.android.maps.k;
import com.nhn.android.maps.mapcore.d;
import com.nhn.android.maps.maplib.NGPoint;
import com.nhn.android.maps.maplib.NGeoPoint;
import com.nhn.android.maps.maplib.NMapConverter;
import com.nhn.android.maps.maplib.f;
import com.nhn.android.util.Assertion;

public class NMapController {
    private final NMapView a;
    private final d b;
    private final i c;
    private final NMapProjection d;
    private final e e;
    private k f;
    private final com.nhn.android.maps.d g;
    private final j h;
    private boolean i = true;
    private boolean j = true;
    private MotionEvent k;
    private final NGPoint l = new NGPoint();
    private final NGPoint m = new NGPoint();
    private final int[] n = new int[]{0, 0};
    private final Rect o = new Rect();
    private final Rect p = new Rect();
    private final Rect q = new Rect();
    private final Point r = new Point();
    private boolean s = true;
    private OnTrafficVersionListener t;
    private NMapTrafficVersion.OnTrafficVersionListener u = new NMapTrafficVersion.OnTrafficVersionListener(){

        @Override
        public void onTrafficVersionChanged() {
            if (NMapController.this.t == null || !NMapController.this.getMapViewTrafficMode()) {
                return;
            }
            NMapController.this.a.invalidate();
        }
    };

    protected NMapController(NMapView nMapView, d d2, i i2, NMapProjection nMapProjection, e e2) {
        this.a = nMapView;
        this.b = d2;
        this.c = i2;
        this.d = nMapProjection;
        this.e = e2;
        this.g = new com.nhn.android.maps.d(nMapView, d2, this, nMapProjection);
        this.h = new j(nMapView, d2, this, nMapProjection);
    }

    public void setOnTrafficVersionListener(OnTrafficVersionListener onTrafficVersionListener) {
    }

    public NMapView getMapView() {
        return this.a;
    }

    protected void a(k k2) {
        this.f = k2;
    }

    protected com.nhn.android.maps.d a() {
        return this.g;
    }

    protected j b() {
        return this.h;
    }

    public boolean isPanningAnimation() {
        if (this.a.getMapGestureDetector().a()) {
            return true;
        }
        return this.g != null && this.g.c();
    }

    protected boolean c() {
        if (this.v()) {
            return true;
        }
        return this.isPanningAnimation();
    }

    public boolean isZoomingAnimation() {
        if (this.h != null) {
            return this.h.a();
        }
        return false;
    }

    public boolean isAnimationSatate() {
        return this.isPanningAnimation() || this.isZoomingAnimation();
    }

    public void setZoomToFixingPoint(boolean bl) {
        this.s = bl;
    }

    public boolean isZoomToFixingPoint() {
        return this.s;
    }

    protected void d() {
        this.a.postInvalidate();
    }

    protected void e() {
        this.a.invalidate();
    }

    protected void f() {
        if (this.g != null) {
            this.g.a();
        }
    }

    protected void a(int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 - n2 > this.q.width() || n5 - n3 > this.q.height()) {
            Log.w((String)"NMapController", (String)("setClipBounds: left=" + n2 + ", top=" + n3 + ", right=" + n4 + ", bottom=" + n5));
            return;
        }
        if (this.a.isAutoRotateEnabled()) {
            int n6 = n4 - n2;
            int n7 = n5 - n3;
            n4 = (n2 += this.q.left) + n6;
            n5 = (n3 += this.q.top) + n7;
        }
        this.o.set(n2, n3, n4, n5);
    }

    protected Rect g() {
        return this.o;
    }

    protected void a(int n2, int n3) {
        this.o.set(0, 0, n2, n3);
        this.q.set(0, 0, n2, n3);
        this.p.set(0, 0, n2, n3);
        this.d.a(n2, n3);
        this.i();
    }

    protected void b(int n2, int n3, int n4, int n5) {
        if (this.a.isAutoRotateEnabled()) {
            this.q.set(n2, n3, n2 + n4, n3 + n5);
            if (this.p.left > this.q.left && this.p.top > this.q.top) {
                int n6 = this.p.left - this.q.left;
                int n7 = this.p.top - this.q.top;
                int n8 = n6 + this.p.width();
                int n9 = n7 + this.p.height();
                this.setBoundsVisible(n6, n7, n8, n9);
                this.a(n6, n7, n8, n9);
            } else {
                this.p.set(n2, n3, n2 + n4, n3 + n5);
                this.o.set(n2, n3, n2 + n4, n3 + n5);
            }
        }
    }

    public void setBoundsVisible(int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 - n2 > this.q.width() || n5 - n3 > this.q.height()) {
            Log.w((String)"NMapController", (String)("setBoundsVisible: left=" + n2 + ", top=" + n3 + ", right=" + n4 + ", bottom=" + n5));
            return;
        }
        if (this.a.isAutoRotateEnabled()) {
            int n6 = n4 - n2;
            int n7 = n5 - n3;
            n4 = (n2 += this.q.left) + n6;
            n5 = (n3 += this.q.top) + n7;
        }
        this.p.set(n2, n3, n4, n5);
    }

    public Rect getBoundsVisible() {
        return this.p;
    }

    public int getVisibleCenterY() {
        return this.p.centerY();
    }

    public int getVisibleCenterX() {
        return this.p.centerX();
    }

    public Rect getViewFrameVisible() {
        return this.q;
    }

    public int getViewFrameVisibleWidth() {
        return this.q.width();
    }

    public int getViewFrameVisibleHeight() {
        return this.q.height();
    }

    public int getViewFrameVisibleCenterY() {
        return this.q.centerY();
    }

    public boolean isLocationTracking() {
        return this.e.g();
    }

    public void reload() {
        this.b.f();
        this.c.a(true);
    }

    public void resetLazyLoading() {
        this.b(true);
    }

    public boolean setMapVersionUrl(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6) {
        boolean bl = false;
        if (stringArray != null) {
            bl |= this.b.g().a(0, stringArray);
        }
        if (stringArray2 != null) {
            bl |= this.b.g().a(1, stringArray2);
        }
        if (stringArray3 != null) {
            bl |= this.b.g().a(2, stringArray3);
        }
        if (stringArray4 != null) {
            bl |= this.b.g().a(3, stringArray4);
        }
        if (stringArray5 != null) {
            bl |= this.b.g().a(4, stringArray5);
        }
        if (stringArray6 != null) {
            bl |= this.b.g().a(5, stringArray6);
        }
        return bl;
    }

    private String[] a(String string) {
        String[] stringArray;
        block4: {
            int n2;
            block3: {
                n2 = 0;
                stringArray = new String[4];
                TextUtils.SimpleStringSplitter simpleStringSplitter = new TextUtils.SimpleStringSplitter(',');
                simpleStringSplitter.setString(string);
                while (simpleStringSplitter.hasNext() && n2 < stringArray.length) {
                    stringArray[n2++] = simpleStringSplitter.next();
                }
                if (n2 >= true) break block3;
                n2 = 0;
                while (n2 < stringArray.length) {
                    stringArray[n2++] = string;
                }
                break block4;
            }
            if (n2 >= stringArray.length) break block4;
            while (n2 < stringArray.length) {
                stringArray[n2++] = stringArray[0];
            }
        }
        return stringArray;
    }

    public boolean setMapVersionUrl(String string, String string2, String string3, String string4, String string5, String string6) {
        boolean bl = false;
        if (string != null) {
            bl |= this.b.g().a(0, this.a(string));
        }
        if (string2 != null) {
            bl |= this.b.g().a(1, this.a(string2));
        }
        if (string3 != null) {
            bl |= this.b.g().a(2, this.a(string3));
        }
        if (string4 != null) {
            bl |= this.b.g().a(3, this.a(string4));
        }
        if (string5 != null) {
            bl |= this.b.g().a(4, this.a(string5));
        }
        if (string6 != null) {
            bl |= this.b.g().a(5, this.a(string6));
        }
        return bl;
    }

    public boolean setMapVersionMerged(String[] stringArray) {
        boolean bl = false;
        if (stringArray != null) {
            bl |= this.b.g().a(6, stringArray);
        }
        return bl;
    }

    public boolean setMapVersionMerged(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            bl |= this.setMapVersionMerged(this.a(string));
        }
        return bl;
    }

    public boolean setMapVersionMergedHD(String[] stringArray) {
        boolean bl = false;
        if (stringArray != null) {
            bl |= this.b.g().a(7, stringArray);
        }
        return bl;
    }

    public boolean setMapVersionMergedHD(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            bl |= this.setMapVersionMergedHD(this.a(string));
        }
        return bl;
    }

    public void setMapViewMode(int n2) {
        boolean bl;
        int n3 = n2;
        if (com.nhn.android.maps.maplib.f.a && !(bl = this.b.w())) {
            switch (n2) {
                case 0: {
                    n3 = 6;
                    break;
                }
                case 1: {
                    n3 = 10;
                    break;
                }
                case 2: {
                    n3 = 14;
                }
            }
        }
        if (this.b.b(n3)) {
            this.reload();
        }
        this.a.getMapLibrary().e();
    }

    public int getMapViewMode() {
        int n2;
        int n3 = n2 = this.b.h();
        if (com.nhn.android.maps.maplib.f.a) {
            switch (n2) {
                case 6: {
                    n3 = 0;
                    break;
                }
                case 10: {
                    n3 = 1;
                    break;
                }
                case 14: {
                    n3 = 2;
                }
            }
        }
        return n3;
    }

    public void setOfflineViewMode(int n2, int n3, int n4) {
        if (this.b.b(n3, n4)) {
            this.setMapViewMode(n2);
        }
    }

    public void setOnlineViewMode(int n2) {
        this.setOfflineViewMode(n2, -1, -1);
    }

    public void setMapViewTrafficMode(boolean bl) {
        if (!com.nhn.android.maps.maplib.f.a && bl) {
            this.setMapViewPanoramaMode(false);
            this.setMapViewBicycleMode(false);
        }
        if (this.b.a(bl)) {
            if (this.t != null) {
                if (bl) {
                    NMapTrafficVersion.a().a(this.u);
                } else {
                    NMapTrafficVersion.a().b(this.u);
                }
            }
            this.reload();
        }
        this.a.getMapLibrary().e();
    }

    public boolean getMapViewTrafficMode() {
        return this.b.k();
    }

    public void setMapViewPanoramaMode(boolean bl) {
        if (!com.nhn.android.maps.maplib.f.a && bl) {
            this.setMapViewTrafficMode(false);
            this.setMapViewBicycleMode(false);
        }
        if (this.b.b(bl)) {
            if (bl) {
                com.nhn.android.maps.mapcore.e.a(true);
            }
            if (com.nhn.android.maps.mapcore.e.a()) {
                this.c.a(true);
            } else {
                this.reload();
            }
        }
    }

    public boolean getMapViewPanoramaMode() {
        return this.b.l();
    }

    public void setMapViewBicycleMode(boolean bl) {
        if (!com.nhn.android.maps.maplib.f.a && bl) {
            this.setMapViewTrafficMode(false);
            this.setMapViewPanoramaMode(false);
        }
        if (this.b.c(bl)) {
            this.reload();
        }
    }

    public boolean getMapViewBicycleMode() {
        return this.b.m();
    }

    public void setMapAlphaLayerMode(boolean bl, @ColorInt int n2) {
        if (!com.nhn.android.maps.maplib.f.a && bl) {
            this.setMapViewTrafficMode(false);
            this.setMapViewPanoramaMode(false);
        }
        if (this.b.a(bl, n2)) {
            this.reload();
        }
    }

    public boolean getMapAlphaLayerMode() {
        return this.b.p();
    }

    public void setMapViewCadastralMode(boolean bl) {
    }

    public boolean getMapViewCadastralMode() {
        return this.b.n();
    }

    public void setMapViewIndoorMode(boolean bl) {
    }

    public boolean getMapViewIndoorMode() {
        return this.b.o();
    }

    public void setBoundsConstraint(NGPoint nGPoint, NGPoint nGPoint2) {
        if (nGPoint != null && nGPoint2 != null) {
            this.b.a(nGPoint, nGPoint2, this.getZoomLevel());
        } else {
            this.b.a(null, null, 0);
        }
    }

    public void setZoomLevelConstraint(int n2, int n3) {
        if (this.b.c(n2, n3)) {
            if (n2 == n3) {
                this.i = false;
            } else if (n2 == NMapConverter.getMinZoomLevel() && n3 >= NMapConverter.getMaxZoomLevel() - 1) {
                this.i = true;
            }
            this.e.e();
        }
        this.i();
    }

    protected boolean h() {
        if (!this.b.e(this.b.A())) {
            return this.setZoomLevel(this.b.y());
        }
        return false;
    }

    public void setZoomEnabled(boolean bl) {
        this.i = bl;
    }

    public void setPanEnabled(boolean bl) {
        this.j = bl;
    }

    public void notifyMapCenterLocation() {
        this.e.c();
        this.e.d();
    }

    public void setMapCenter(double d2, double d3, int n2) {
        int n3 = this.b.A();
        if (n3 != n2) {
            // empty if block
        }
        this.b.a(d2, d3, n2);
        this.k();
        if (n3 != n2) {
            this.e.a(n2);
        }
        this.m();
    }

    public void setMapCenter(double d2, double d3) {
        this.setMapCenter(d2, d3, this.b.A());
    }

    public void setMapCenter(NGeoPoint nGeoPoint) {
        this.setMapCenter(nGeoPoint.longitude, nGeoPoint.latitude, this.b.A());
    }

    public void setMapCenter(NGeoPoint nGeoPoint, int n2) {
        this.setMapCenter(nGeoPoint.longitude, nGeoPoint.latitude, n2);
    }

    public void setMapCenter(int n2, int n3, int n4) {
        int n5 = this.b.A();
        if (n5 != n4) {
            // empty if block
        }
        this.b.a(n2, n3, n4);
        this.k();
        if (n5 != n4) {
            n4 = this.b.A();
            this.e.a(n4);
        }
        this.m();
    }

    public void setMapCenter(int n2, int n3) {
        this.setMapCenter(n2, n3, this.b.A());
    }

    public NGeoPoint getMapCenter() {
        return this.getMapCenter(true);
    }

    public NGeoPoint getMapCenter(boolean bl) {
        if (this.e.g()) {
            return this.b.v();
        }
        if (bl && this.j()) {
            Point point = new Point(this.p.centerX(), this.p.centerY());
            if (this.a.isAutoRotateEnabled()) {
                this.a.mapPointFromScreen(point);
            }
            return this.d.fromPixels(point.x, point.y);
        }
        return this.b.v();
    }

    public NGPoint getMapCenterInUtmk() {
        return this.getMapCenterInUtmk(true);
    }

    public NGPoint getMapCenterInUtmk(boolean bl) {
        if (this.e.g()) {
            return this.b.u();
        }
        if (bl && this.j()) {
            Point point = new Point(this.p.centerX(), this.p.centerY());
            if (this.a.isAutoRotateEnabled()) {
                this.a.mapPointFromScreen(point);
            }
            return this.d.fromPixelsInUtmk(point.x, point.y);
        }
        return this.b.u();
    }

    public int getZoomLevel() {
        return this.b.A();
    }

    public int getMaxZoomLevel() {
        return this.b.y();
    }

    public int getMinZoomLevel() {
        return this.b.z();
    }

    public boolean canZoomOut() {
        if (!this.i) {
            return false;
        }
        return this.b.C();
    }

    public boolean canZoomIn() {
        if (!this.i) {
            return false;
        }
        return this.b.B();
    }

    public boolean setZoomLevel(int n2) {
        return this.a(n2, null, null);
    }

    protected boolean a(int n2, NGeoPoint nGeoPoint, Point point) {
        if (n2 != this.b.A()) {
            NGPoint nGPoint = this.getMapCenterInUtmk();
            NGPoint nGPoint2 = this.b.u();
            this.b.a(nGPoint2.px, nGPoint2.py, n2);
            if (nGeoPoint != null && point != null && this.isZoomToFixingPoint()) {
                Point point2 = new Point();
                point2 = this.d.a(nGeoPoint, point2, false);
                this.b(point2.x - point.x, point2.y - point.y, false);
            } else if (this.j()) {
                this.setMapCenter(nGPoint.px, nGPoint.py, n2);
            }
            this.e.a(n2);
            return true;
        }
        return false;
    }

    public boolean zoomIn() {
        if (!this.i) {
            return false;
        }
        return this.f.b(true);
    }

    public boolean zoomOut() {
        if (!this.i) {
            return false;
        }
        return this.f.b(false);
    }

    public boolean zoomInFixing(int n2, int n3) {
        return this.f.a(true, n2, n3);
    }

    public boolean zoomOutFixing(int n2, int n3) {
        return this.f.a(false, n2, n3);
    }

    public void zoomToLevel(int n2, Point point) {
        if (!this.i) {
            return;
        }
        int n3 = this.getMinZoomLevel();
        int n4 = this.getMaxZoomLevel();
        if (n2 < n3) {
            n2 = n3;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        float f2 = 1.0f;
        int n5 = this.getZoomLevel();
        if (n5 > n2) {
            f2 /= (float)(1 << n5 - n2);
        } else if (n5 < n2) {
            f2 *= (float)(1 << n2 - n5);
        } else {
            return;
        }
        this.f.a(f2, point);
    }

    public void animateTo(NGeoPoint nGeoPoint, Runnable runnable) {
        if (this.g != null) {
            this.g.a(nGeoPoint, runnable, null, false);
        }
    }

    public void animateTo(NGeoPoint nGeoPoint, Message message) {
        if (this.g != null) {
            this.g.a(nGeoPoint, null, message, false);
        }
    }

    public void animateTo(NGeoPoint nGeoPoint) {
        if (this.g != null) {
            this.g.a(nGeoPoint, null, null, false);
        } else {
            this.setMapCenter(nGeoPoint);
        }
    }

    public void animateTo(NGeoPoint nGeoPoint, boolean bl) {
        if (this.g != null) {
            this.g.a(nGeoPoint, null, null, bl);
        } else {
            this.setMapCenter(nGeoPoint);
        }
    }

    public void animateTo(NMapOverlayItem nMapOverlayItem, boolean bl) {
        int n2;
        int n3;
        if (!Assertion.checkNotNull(nMapOverlayItem)) {
            return;
        }
        Drawable drawable2 = nMapOverlayItem.getMarker(0);
        if (drawable2 == null || drawable2.getBounds().isEmpty()) {
            NGeoPoint nGeoPoint = nMapOverlayItem.getPoint();
            this.animateTo(nGeoPoint, bl);
            return;
        }
        this.a.getMapProjection().toPixels(nMapOverlayItem.getPointInUtmk(), this.r);
        Rect rect = nMapOverlayItem.setBoundsInScreen(drawable2.getBounds(), this.r);
        if (rect == null || rect.isEmpty()) {
            NGeoPoint nGeoPoint = nMapOverlayItem.getPoint();
            this.animateTo(nGeoPoint, bl);
            return;
        }
        if (this.a.isAutoRotateEnabled()) {
            this.r.x = rect.centerX();
            this.r.y = rect.bottom;
            this.a.mapPointToScreen(this.r);
            n3 = rect.width();
            n2 = rect.height();
            rect.left = this.r.x - n3 / 2;
            rect.top = this.r.y - n2;
            rect.right = rect.left + n3;
            rect.bottom = rect.top + n2;
        }
        n3 = rect.centerX();
        n2 = rect.centerY();
        if (this.a.isAutoRotateEnabled()) {
            this.r.x = n3;
            this.r.y = n2;
            this.a.mapPointFromScreen(this.r);
            n3 = this.r.x;
            n2 = this.r.y;
        }
        NGeoPoint nGeoPoint = this.a.getMapProjection().fromPixels(n3, n2);
        this.animateTo(nGeoPoint, bl);
    }

    public int getZoomLevelToBoundsE6(Rect rect) {
        Rect rect2 = this.d.toBoundsUTMK(rect, null);
        return this.getZoomLevelToBounds(rect2);
    }

    public void zoomToBoundsE6(Rect rect) {
        Rect rect2 = this.d.toBoundsUTMK(rect, null);
        this.zoomToBounds(rect2);
    }

    public void zoomToBoundsE6(Rect rect, int n2) {
        if (n2 > 0) {
            Rect rect2 = this.d.toBoundsUTMK(rect, null);
            this.a(rect2, n2);
        } else {
            this.zoomToBoundsE6(rect);
        }
    }

    public int getZoomLevelToBounds(Rect rect) {
        NGPoint nGPoint = new NGPoint(20, 20);
        if (this.j()) {
            nGPoint.px += (this.q.width() - this.p.width()) / 2;
            nGPoint.py += (this.q.height() - this.p.height()) / 2;
        }
        if (this.a.isAutoRotateEnabled()) {
            this.a.mapDeltaFromScreen(nGPoint, false);
        }
        nGPoint = this.d.a(nGPoint);
        int n2 = this.b.a(rect.left, rect.top, rect.right, rect.bottom, nGPoint);
        return n2;
    }

    public void zoomToBounds(Rect rect) {
        int n2 = this.getZoomLevelToBounds(rect);
        this.a(rect, n2);
    }

    public void zoomToBounds(Rect rect, int n2) {
        if (n2 > 0) {
            this.a(rect, n2);
        } else {
            this.zoomToBounds(rect);
        }
    }

    protected void a(int n2, int n3, boolean bl) {
        if (this.g != null) {
            this.g.a(false);
        }
        this.a(n2, n3, false, bl);
    }

    public void scrollByDelta(int n2, int n3) {
        this.b(n2, n3, true);
    }

    protected void b(int n2, int n3, boolean bl) {
        if (this.g != null) {
            this.g.a(false);
        }
        if (this.a.isAutoRotateEnabled()) {
            this.n[0] = n2;
            this.n[1] = n3;
            this.a.mapDeltaFromScreen(this.n, false);
            n2 = this.n[0];
            n3 = this.n[1];
        }
        this.a(n2, n3, true, bl);
    }

    protected void i() {
    }

    protected void a(int n2) {
        if (this.setZoomLevel(n2)) {
            this.d();
        }
    }

    protected boolean a(boolean bl) {
        if (bl) {
            return this.w();
        }
        return this.x();
    }

    private boolean w() {
        if (!this.i) {
            return false;
        }
        if (this.b.B()) {
            // empty if block
        }
        return this.n();
    }

    private boolean x() {
        if (!this.i) {
            return false;
        }
        if (this.b.C()) {
            // empty if block
        }
        return this.o();
    }

    protected void a(int n2, int n3, boolean bl, boolean bl2) {
        if (!this.j && bl2) {
            return;
        }
        n2 = -n2;
        n3 = -n3;
        NGPoint nGPoint = new NGPoint(n2, -n3);
        nGPoint = this.d.a(nGPoint);
        nGPoint = this.b.a(nGPoint);
        n2 = nGPoint.px;
        n3 = -nGPoint.py;
        this.c.a(bl);
        if (!bl) {
            this.e.a();
        }
    }

    protected boolean j() {
        if (this.p.width() > 0 && this.p.height() > 0) {
            return this.p.height() != this.q.height() || this.p.width() != this.q.width();
        }
        return false;
    }

    protected void k() {
        if (this.e.g()) {
            return;
        }
        if (this.j()) {
            NGPoint nGPoint = new NGPoint();
            if (this.p.width() != this.q.width()) {
                nGPoint.px = this.p.centerX() - this.q.centerX();
            }
            if (this.p.height() != this.q.height()) {
                nGPoint.py = this.q.centerY() - this.p.centerY();
            }
            if (this.a.isAutoRotateEnabled()) {
                this.a.mapDeltaFromScreen(nGPoint, true);
            }
            this.d.b(nGPoint);
        }
    }

    protected boolean l() {
        if (!this.j) {
            return false;
        }
        if (this.e.g()) {
            return false;
        }
        return !this.a.isAutoRotateEnabled();
    }

    private void a(Rect rect, int n2) {
        int n3 = (rect.left + rect.right) / 2;
        int n4 = (rect.top + rect.bottom) / 2;
        this.setMapCenter(n3, n4, n2);
    }

    protected void m() {
        this.c.a(true);
        this.e.d();
    }

    protected boolean n() {
        if (this.b.B()) {
            NGPoint nGPoint = this.getMapCenterInUtmk();
            this.setMapCenter(nGPoint.px, nGPoint.py, this.b.A() + 1);
            return true;
        }
        return false;
    }

    protected boolean o() {
        if (this.b.C()) {
            NGPoint nGPoint = this.getMapCenterInUtmk();
            this.setMapCenter(nGPoint.px, nGPoint.py, this.b.A() - 1);
            return true;
        }
        return false;
    }

    protected void p() {
        this.b.x();
        this.e.a();
    }

    protected void b(boolean bl) {
        if (!this.isAnimationSatate()) {
            this.b.r();
        }
        if (this.b.d(bl)) {
            this.e();
        }
        this.e.b();
    }

    protected void q() {
        if (this.isAnimationSatate()) {
            return;
        }
        if (this.c.c()) {
            this.c.a(true);
        }
    }

    protected void r() {
        if (this.t != null && this.getMapViewTrafficMode()) {
            NMapTrafficVersion.a().a(this.u);
        }
    }

    protected void s() {
        if (this.t != null && this.getMapViewTrafficMode()) {
            NMapTrafficVersion.a().b(this.u);
        }
    }

    protected void t() {
        if (this.t == null || !this.getMapViewTrafficMode()) {
            return;
        }
        NMapTrafficVersion nMapTrafficVersion = NMapTrafficVersion.a();
        if (nMapTrafficVersion.c()) {
            int n2 = nMapTrafficVersion.b();
            int n3 = this.b.b();
            if (n3 != n2) {
                if (this.t != null) {
                    this.t.onTrafficVersionChanged();
                }
                this.b.a(n2);
                nMapTrafficVersion.a(false);
                this.reload();
            }
        }
    }

    protected void a(MotionEvent motionEvent) {
        this.l.px = (int)motionEvent.getX();
        this.l.py = (int)motionEvent.getY();
        this.k = motionEvent;
        this.b(this.l.px, this.l.py);
        this.p();
    }

    protected void b(MotionEvent motionEvent) {
        if (!this.v()) {
            this.u();
            return;
        }
        int n2 = (int)motionEvent.getX();
        int n3 = (int)motionEvent.getY();
        int n4 = -(n2 - this.m.px);
        int n5 = -(n3 - this.m.py);
        this.b(n2, n3);
        this.a(n4, n5, false, true);
        this.e.a(this.k, motionEvent);
        this.k = motionEvent;
    }

    protected void c(MotionEvent motionEvent) {
        this.b(!this.isAnimationSatate());
        this.a.getMapGestureDetector().c();
        this.u();
    }

    protected boolean a(View view, int n2, KeyEvent keyEvent) {
        if (this.g != null && this.g.a(n2)) {
            this.d();
            this.e.a();
            return true;
        }
        return false;
    }

    protected boolean b(View view, int n2, KeyEvent keyEvent) {
        if (this.g != null && this.g.b(n2)) {
            this.d();
            this.e.b();
            return true;
        }
        return false;
    }

    protected void u() {
        this.l.px = -1;
        this.l.py = -1;
        this.m.px = -1;
        this.m.py = -1;
        this.k = null;
    }

    private void b(int n2, int n3) {
        this.m.px = n2;
        this.m.py = n3;
    }

    protected boolean v() {
        return this.m.px > 0;
    }

    public static interface OnTrafficVersionListener {
        public void onTrafficVersionChanged();
    }
}

