/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.IdentityHashMap;
import java.util.Map;
import org.bridj.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BitFields {
    private static final PrimHandler INT_HANDLER = new PrimHandler(){

        public void writeLong(Pointer p, long offset, long value) {
            p.setIntAtOffset(offset, (int)value);
        }

        public long readLong(Pointer p, long offset) {
            return p.getIntAtOffset(offset);
        }

        public Object objectValue(long value) {
            return (int)value;
        }

        public long longValue(Object value) {
            return ((Integer)value).longValue();
        }

        public void writeObject(Pointer p, long offset, Object value) {
            p.setIntAtOffset(offset, value == null ? 0 : (Integer)value);
        }

        public Object readObject(Pointer p, long offset) {
            return p.getIntAtOffset(offset);
        }

        public int size() {
            return 4;
        }
    };
    private static final PrimHandler LONG_HANDLER = new PrimHandler(){

        public void writeLong(Pointer p, long offset, long value) {
            p.setLongAtOffset(offset, value);
        }

        public long readLong(Pointer p, long offset) {
            return p.getLongAtOffset(offset);
        }

        public Object objectValue(long value) {
            return value;
        }

        public long longValue(Object value) {
            return (Long)value;
        }

        public void writeObject(Pointer p, long offset, Object value) {
            p.setLongAtOffset(offset, value == null ? 0L : (Long)value);
        }

        public Object readObject(Pointer p, long offset) {
            return p.getLongAtOffset(offset);
        }

        public int size() {
            return 8;
        }
    };
    private static final PrimHandler SHORT_HANDLER = new PrimHandler(){

        public void writeLong(Pointer p, long offset, long value) {
            p.setShortAtOffset(offset, (short)value);
        }

        public long readLong(Pointer p, long offset) {
            return p.getShortAtOffset(offset);
        }

        public Object objectValue(long value) {
            return (short)value;
        }

        public long longValue(Object value) {
            return ((Short)value).longValue();
        }

        public void writeObject(Pointer p, long offset, Object value) {
            p.setShortAtOffset(offset, value == null ? (short)0 : (Short)value);
        }

        public Object readObject(Pointer p, long offset) {
            return p.getShortAtOffset(offset);
        }

        public int size() {
            return 2;
        }
    };
    private static final PrimHandler BYTE_HANDLER = new PrimHandler(){

        public void writeLong(Pointer p, long offset, long value) {
            p.setByteAtOffset(offset, (byte)value);
        }

        public long readLong(Pointer p, long offset) {
            return p.getByteAtOffset(offset);
        }

        public Object objectValue(long value) {
            return (byte)value;
        }

        public long longValue(Object value) {
            return ((Byte)value).longValue();
        }

        public void writeObject(Pointer p, long offset, Object value) {
            p.setByteAtOffset(offset, value == null ? (byte)0 : (Byte)value);
        }

        public Object readObject(Pointer p, long offset) {
            return p.getByteAtOffset(offset);
        }

        public int size() {
            return 1;
        }
    };
    private static final PrimHandler CHAR_HANDLER = new PrimHandler(){

        public void writeLong(Pointer p, long offset, long value) {
            p.setCharAtOffset(offset, (char)value);
        }

        public long readLong(Pointer p, long offset) {
            return p.getCharAtOffset(offset);
        }

        public Object objectValue(long value) {
            return Character.valueOf((char)value);
        }

        public long longValue(Object value) {
            return ((Character)value).charValue();
        }

        public void writeObject(Pointer p, long offset, Object value) {
            p.setCharAtOffset(offset, value == null ? (char)'\u0000' : ((Character)value).charValue());
        }

        public Object readObject(Pointer p, long offset) {
            return Character.valueOf(p.getCharAtOffset(offset));
        }

        public int size() {
            return 2;
        }
    };
    private static final PrimHandler BOOL_HANDLER = new PrimHandler(){

        public void writeLong(Pointer p, long offset, long value) {
            p.setByteAtOffset(offset, (byte)value);
        }

        public long readLong(Pointer p, long offset) {
            return p.getByteAtOffset(offset);
        }

        public Object objectValue(long value) {
            return (byte)value == 0 ? Boolean.FALSE : Boolean.TRUE;
        }

        public long longValue(Object value) {
            return (Boolean)value != false ? -1L : 0L;
        }

        public void writeObject(Pointer p, long offset, Object value) {
            p.setByteAtOffset(offset, value == null ? (byte)0 : (byte)(Boolean.TRUE.equals(value) ? -1 : 0));
        }

        public Object readObject(Pointer p, long offset) {
            return p.getByteAtOffset(offset) == 0 ? Boolean.FALSE : Boolean.TRUE;
        }

        public int size() {
            return 1;
        }
    };
    private static final PrimHandler DOUBLE_HANDLER = new NonIntHandler(){

        public long readLong(Pointer p, long offset) {
            return p.getLongAtOffset(offset);
        }

        public void writeLong(Pointer p, long offset, long value) {
            p.setLongAtOffset(offset, value);
        }

        public long longValue(Object value) {
            return Double.doubleToRawLongBits((Double)value);
        }

        public Object objectValue(long value) {
            return Double.longBitsToDouble(value);
        }

        public void writeObject(Pointer p, long offset, Object value) {
            p.setDoubleAtOffset(offset, value == null ? 0.0 : (Double)value);
        }

        public Object readObject(Pointer p, long offset) {
            return p.getDoubleAtOffset(offset);
        }

        public int size() {
            return 8;
        }
    };
    private static final PrimHandler FLOAT_HANDLER = new NonIntHandler(){

        public long readLong(Pointer p, long offset) {
            return p.getIntAtOffset(offset);
        }

        public void writeLong(Pointer p, long offset, long value) {
            p.setIntAtOffset(offset, (int)value);
        }

        public long longValue(Object value) {
            return Float.floatToRawIntBits(((Float)value).floatValue());
        }

        public Object objectValue(long value) {
            return Float.valueOf(Float.intBitsToFloat((int)value));
        }

        public void writeObject(Pointer p, long offset, Object value) {
            p.setFloatAtOffset(offset, value == null ? 0.0f : ((Float)value).floatValue());
        }

        public Object readObject(Pointer p, long offset) {
            return Float.valueOf(p.getFloatAtOffset(offset));
        }

        public int size() {
            return 4;
        }
    };
    private static final PrimHandler STRING_HANDLER = new StringHandler(false);
    private static final PrimHandler WSTRING_HANDLER = new StringHandler(true);
    private static final Map primHandlers = new IdentityHashMap(10);
    public static final Object UNHANDLED_TYPE;

    BitFields() {
    }

    private static PrimHandler getHandlerWithAtLeastNBytes(int n) {
        switch (n) {
            case 1: {
                return BYTE_HANDLER;
            }
            case 2: {
                return SHORT_HANDLER;
            }
            case 3: 
            case 4: {
                return INT_HANDLER;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return LONG_HANDLER;
            }
        }
        return null;
    }

    private static PrimHandler getPrimHandler(Class type, int bitOffset, int bits) {
        PrimHandler handler = (PrimHandler)primHandlers.get(type);
        if (handler == null && (bitOffset | bits) != 0 || handler != null && (!handler.supportsBitOffset() && bitOffset != 0 || !handler.supportsBitLength() && bits != 0)) {
            throw new UnsupportedOperationException("Bit fields only support integral fields !!!");
        }
        return handler;
    }

    static void print(BigInteger bi) {
        int len = bi.bitLength();
        for (int i = 0; i < len; ++i) {
            System.out.print(bi.testBit(i) ? (char)'1' : '0');
        }
        System.out.println();
    }

    private static BigInteger shiftedMask(int bits, int bitOffset) {
        BigInteger mask = BigInteger.valueOf(bits == 0 ? 0L : 1L);
        if (bits != 0) {
            mask = mask.shiftLeft(bits);
        }
        mask = mask.subtract(BigInteger.valueOf(1L));
        if (bitOffset != 0) {
            mask = mask.shiftLeft(bitOffset);
            for (int i = 0; i < bitOffset; ++i) {
                mask.clearBit(i);
            }
        }
        return mask;
    }

    private static byte[] getBigEndianByteArray(Pointer pointer, long offset, int bytesToFetch) {
        byte[] bs = pointer.getBytesAtOffset(offset, bytesToFetch);
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            BitFields.revert(bs);
        }
        return bs;
    }

    private static void setBigEndianByteArray(Pointer pointer, long offset, byte[] bs) {
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            BitFields.revert(bs);
        }
        pointer.setBytesAtOffset(offset, bs, 0, bs.length);
    }

    private static void revert(byte[] bs) {
        int len = bs.length;
        int sup = len >>> 1;
        for (int i = 0; i < sup; ++i) {
            int j = len - i - 1;
            byte t = bs[i];
            bs[i] = bs[j];
            bs[j] = t;
        }
    }

    public static boolean setPrimitiveValue(Pointer pointer, long offset, int bitOffset, int bits, Object value, Class type) {
        int bitLen;
        int bytesToFetch;
        PrimHandler io;
        PrimHandler handler = BitFields.getPrimHandler(type, bitOffset, bits);
        if (handler == null) {
            return false;
        }
        if ((bitOffset | bits) == 0) {
            handler.writeObject(pointer, offset, value);
            return true;
        }
        if (bits <= 0) {
            bits = handler.size() << 3;
        }
        if ((io = BitFields.getHandlerWithAtLeastNBytes(bytesToFetch = (bitLen >> 3) + (((bitLen = bits + bitOffset) & 7) == 0 ? 0 : 1))) != null) {
            long longValue = handler.longValue(value);
            longValue <<= bitOffset;
            long existing = io.readLong(pointer, offset);
            if (bits != 0) {
                long mask = (1L << bits) - 1L << bitOffset;
                longValue &= mask;
                existing &= mask ^ 0xFFFFFFFFFFFFFFFFL;
            }
            io.writeLong(pointer, offset, longValue |= existing);
        } else {
            BigInteger bigValue = BigInteger.valueOf(handler.longValue(value));
            bigValue = bigValue.shiftLeft(bitOffset);
            byte[] bs = BitFields.getBigEndianByteArray(pointer, offset, bytesToFetch);
            BigInteger existing = new BigInteger(bs);
            BigInteger mask = BitFields.shiftedMask(bits, bitOffset);
            bigValue = bigValue.and(mask);
            existing = existing.and(mask.not());
            bigValue = bigValue.or(existing);
            BitFields.setBigEndianByteArray(pointer, offset, bigValue.toByteArray());
        }
        return true;
    }

    public static <T> T getPrimitiveValue(Pointer pointer, long offset, int bitOffset, int bits, Class<T> type) {
        long longValue;
        int bitLen;
        int bytesToFetch;
        PrimHandler io;
        PrimHandler handler = BitFields.getPrimHandler(type, bitOffset, bits);
        if (handler == null) {
            return (T)UNHANDLED_TYPE;
        }
        if ((bitOffset | bits) == 0) {
            return (T)handler.readObject(pointer, offset);
        }
        if (bits <= 0) {
            bits = handler.size() << 3;
        }
        if ((io = BitFields.getHandlerWithAtLeastNBytes(bytesToFetch = (bitLen >> 3) + (((bitLen = bits + bitOffset) & 7) == 0 ? 0 : 1))) != null) {
            longValue = io.readLong(pointer, offset);
            longValue >>= bitOffset;
            if (bits != 0) {
                long mask = (1L << bits) - 1L;
                longValue &= mask;
            }
        } else {
            BigInteger bigValue = new BigInteger(BitFields.getBigEndianByteArray(pointer, offset, bytesToFetch));
            bigValue = bigValue.shiftRight(bitOffset);
            if (bits != 0) {
                BigInteger mask = BitFields.shiftedMask(bits, 0);
                bigValue = bigValue.and(mask);
            }
            longValue = bigValue.longValue();
        }
        return (T)handler.objectValue(longValue);
    }

    static {
        primHandlers.put(Integer.TYPE, INT_HANDLER);
        primHandlers.put(Integer.class, INT_HANDLER);
        primHandlers.put(Long.TYPE, LONG_HANDLER);
        primHandlers.put(Long.class, LONG_HANDLER);
        primHandlers.put(Short.TYPE, SHORT_HANDLER);
        primHandlers.put(Short.class, SHORT_HANDLER);
        primHandlers.put(Byte.TYPE, BYTE_HANDLER);
        primHandlers.put(Byte.class, BYTE_HANDLER);
        primHandlers.put(Character.TYPE, CHAR_HANDLER);
        primHandlers.put(Character.class, CHAR_HANDLER);
        primHandlers.put(Boolean.TYPE, BOOL_HANDLER);
        primHandlers.put(Boolean.class, BOOL_HANDLER);
        primHandlers.put(Float.TYPE, FLOAT_HANDLER);
        primHandlers.put(Float.class, FLOAT_HANDLER);
        primHandlers.put(Double.TYPE, DOUBLE_HANDLER);
        primHandlers.put(Double.class, DOUBLE_HANDLER);
        primHandlers.put(String.class, STRING_HANDLER);
        UNHANDLED_TYPE = new Object(){};
    }

    private static final class StringHandler
    extends NonIntHandler {
        final boolean wide;

        public StringHandler(boolean wide) {
            this.wide = wide;
        }

        public Object readObject(Pointer p, long offset) {
            return (p = p.getPointerAtOffset(offset)) != null ? (this.wide ? p.getWideCString() : p.getCString()) : null;
        }

        public int size() {
            return Pointer.SIZE;
        }

        public void writeObject(Pointer pointer, long offset, Object value) {
            pointer.setPointerAtOffset(offset, (Pointer)value);
        }
    }

    private static abstract class NonIntHandler
    extends PrimHandler {
        private NonIntHandler() {
        }

        public void writeLong(Pointer p, long offset, long value) {
            throw new UnsupportedOperationException();
        }

        public long readLong(Pointer p, long offset) {
            throw new UnsupportedOperationException();
        }

        public Object objectValue(long value) {
            throw new UnsupportedOperationException();
        }

        public long longValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean supportsBitLength() {
            return false;
        }
    }

    private static abstract class PrimHandler {
        private PrimHandler() {
        }

        abstract long longValue(Object var1);

        abstract Object objectValue(long var1);

        abstract void writeLong(Pointer var1, long var2, long var4);

        abstract long readLong(Pointer var1, long var2);

        abstract int size();

        abstract void writeObject(Pointer var1, long var2, Object var4);

        abstract Object readObject(Pointer var1, long var2);

        boolean supportsBitOffset() {
            return true;
        }

        boolean supportsBitLength() {
            return true;
        }
    }
}

