/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.WebSocketException;
import fi.iki.elonen.WebSocketFrame;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.util.LinkedList;
import java.util.List;

public abstract class WebSocket {
    protected final InputStream in;
    protected OutputStream out;
    protected WebSocketFrame.OpCode continuousOpCode = null;
    protected List<WebSocketFrame> continuousFrames = new LinkedList<WebSocketFrame>();
    protected State state = State.UNCONNECTED;
    protected final NanoHTTPD.IHTTPSession handshakeRequest;
    protected final NanoHTTPD.Response handshakeResponse = new NanoHTTPD.Response(NanoHTTPD.Response.Status.SWITCH_PROTOCOL, null, null){

        protected void send(OutputStream out) {
            WebSocket.this.out = out;
            WebSocket.this.state = State.CONNECTING;
            super.send(out);
            WebSocket.this.state = State.OPEN;
            WebSocket.this.readWebsocket();
        }
    };

    public WebSocket(NanoHTTPD.IHTTPSession handshakeRequest) {
        this.handshakeRequest = handshakeRequest;
        this.in = handshakeRequest.getInputStream();
        this.handshakeResponse.addHeader("upgrade", "websocket");
        this.handshakeResponse.addHeader("connection", "Upgrade");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readWebsocket() {
        try {
            while (this.state == State.OPEN) {
                this.handleWebsocketFrame(WebSocketFrame.read(this.in));
            }
        }
        catch (CharacterCodingException e) {
            this.onException(e);
            this.doClose(WebSocketFrame.CloseCode.InvalidFramePayloadData, e.toString(), false);
        }
        catch (IOException e) {
            this.onException(e);
            if (e instanceof WebSocketException) {
                this.doClose(((WebSocketException)e).getCode(), ((WebSocketException)e).getReason(), false);
            }
        }
        finally {
            this.doClose(WebSocketFrame.CloseCode.InternalServerError, "Handler terminated without closing the connection.", false);
        }
    }

    protected void handleWebsocketFrame(WebSocketFrame frame) throws IOException {
        if (frame.getOpCode() == WebSocketFrame.OpCode.Close) {
            this.handleCloseFrame(frame);
        } else if (frame.getOpCode() == WebSocketFrame.OpCode.Ping) {
            this.sendFrame(new WebSocketFrame(WebSocketFrame.OpCode.Pong, true, frame.getBinaryPayload()));
        } else if (frame.getOpCode() == WebSocketFrame.OpCode.Pong) {
            this.onPong(frame);
        } else if (!frame.isFin() || frame.getOpCode() == WebSocketFrame.OpCode.Continuation) {
            this.handleFrameFragment(frame);
        } else {
            if (this.continuousOpCode != null) {
                throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Continuous frame sequence not completed.");
            }
            if (frame.getOpCode() == WebSocketFrame.OpCode.Text || frame.getOpCode() == WebSocketFrame.OpCode.Binary) {
                this.onMessage(frame);
            } else {
                throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Non control or continuous frame expected.");
            }
        }
    }

    protected void handleCloseFrame(WebSocketFrame frame) throws IOException {
        WebSocketFrame.CloseCode code = WebSocketFrame.CloseCode.NormalClosure;
        String reason = "";
        if (frame instanceof WebSocketFrame.CloseFrame) {
            code = ((WebSocketFrame.CloseFrame)frame).getCloseCode();
            reason = ((WebSocketFrame.CloseFrame)frame).getCloseReason();
        }
        if (this.state == State.CLOSING) {
            this.doClose(code, reason, false);
        } else {
            State oldState = this.state;
            this.state = State.CLOSING;
            if (oldState == State.OPEN) {
                this.sendFrame(new WebSocketFrame.CloseFrame(code, reason));
            }
            this.doClose(code, reason, true);
        }
    }

    protected void handleFrameFragment(WebSocketFrame frame) throws IOException {
        if (frame.getOpCode() != WebSocketFrame.OpCode.Continuation) {
            if (this.continuousOpCode != null) {
                throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Previous continuous frame sequence not completed.");
            }
            this.continuousOpCode = frame.getOpCode();
            this.continuousFrames.clear();
            this.continuousFrames.add(frame);
        } else if (frame.isFin()) {
            if (this.continuousOpCode == null) {
                throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Continuous frame sequence was not started.");
            }
            this.onMessage(new WebSocketFrame(this.continuousOpCode, this.continuousFrames));
            this.continuousOpCode = null;
            this.continuousFrames.clear();
        } else {
            if (this.continuousOpCode == null) {
                throw new WebSocketException(WebSocketFrame.CloseCode.ProtocolError, "Continuous frame sequence was not started.");
            }
            this.continuousFrames.add(frame);
        }
    }

    public synchronized void sendFrame(WebSocketFrame frame) throws IOException {
        frame.write(this.out);
    }

    protected void doClose(WebSocketFrame.CloseCode code, String reason, boolean initiatedByRemote) {
        if (this.state == State.CLOSED) {
            return;
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.state = State.CLOSED;
        this.onClose(code, reason, initiatedByRemote);
    }

    protected abstract void onPong(WebSocketFrame var1);

    protected abstract void onMessage(WebSocketFrame var1);

    protected abstract void onClose(WebSocketFrame.CloseCode var1, String var2, boolean var3);

    protected abstract void onException(IOException var1);

    public void ping(byte[] payload) throws IOException {
        this.sendFrame(new WebSocketFrame(WebSocketFrame.OpCode.Ping, true, payload));
    }

    public void send(byte[] payload) throws IOException {
        this.sendFrame(new WebSocketFrame(WebSocketFrame.OpCode.Binary, true, payload));
    }

    public void send(String payload) throws IOException {
        this.sendFrame(new WebSocketFrame(WebSocketFrame.OpCode.Text, true, payload));
    }

    public void close(WebSocketFrame.CloseCode code, String reason) throws IOException {
        State oldState = this.state;
        this.state = State.CLOSING;
        if (oldState == State.OPEN) {
            this.sendFrame(new WebSocketFrame.CloseFrame(code, reason));
        } else {
            this.doClose(code, reason, false);
        }
    }

    public NanoHTTPD.IHTTPSession getHandshakeRequest() {
        return this.handshakeRequest;
    }

    public NanoHTTPD.Response getHandshakeResponse() {
        return this.handshakeResponse;
    }

    public static enum State {
        UNCONNECTED,
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

