/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.ServerRunner;
import fi.iki.elonen.debug.DebugServer;
import java.util.ArrayList;
import java.util.List;

public class TempFilesServer
extends DebugServer {
    public static void main(String[] args) {
        TempFilesServer server = new TempFilesServer();
        server.setTempFileManagerFactory(new ExampleManagerFactory());
        ServerRunner.executeInstance((NanoHTTPD)server);
    }

    private static class ExampleManager
    implements NanoHTTPD.TempFileManager {
        private final String tmpdir = System.getProperty("java.io.tmpdir");
        private final List<NanoHTTPD.TempFile> tempFiles = new ArrayList<NanoHTTPD.TempFile>();

        private ExampleManager() {
        }

        public NanoHTTPD.TempFile createTempFile() throws Exception {
            NanoHTTPD.DefaultTempFile tempFile = new NanoHTTPD.DefaultTempFile(this.tmpdir);
            this.tempFiles.add((NanoHTTPD.TempFile)tempFile);
            System.out.println("Created tempFile: " + tempFile.getName());
            return tempFile;
        }

        public void clear() {
            if (!this.tempFiles.isEmpty()) {
                System.out.println("Cleaning up:");
            }
            for (NanoHTTPD.TempFile file : this.tempFiles) {
                try {
                    System.out.println("   " + file.getName());
                    file.delete();
                }
                catch (Exception exception) {}
            }
            this.tempFiles.clear();
        }
    }

    private static class ExampleManagerFactory
    implements NanoHTTPD.TempFileManagerFactory {
        private ExampleManagerFactory() {
        }

        public NanoHTTPD.TempFileManager create() {
            return new ExampleManager();
        }
    }
}

