/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.annotation;

import java.lang.reflect.Method;
import org.springframework.amqp.core.AbstractExchange;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitAdminNameResolver;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.annotation.RabbitListenerAnnotationBeanPostProcessor;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MultiRabbitListenerAnnotationBeanPostProcessor
extends RabbitListenerAnnotationBeanPostProcessor
implements ApplicationContextAware,
BeanFactoryAware {
    private static final String NO_ADMIN_BEAN_ERROR = "Bean '%s' for RabbitAdmin not found.";
    private ApplicationContext applicationContext;
    private BeanFactory beanFactory;

    protected void processAmqpListener(RabbitListener rabbitListener, Method method, Object bean, String beanName) {
        super.processAmqpListener(rabbitListener, method, bean, beanName);
        this.enhanceBeansWithReferenceToRabbitAdmin(rabbitListener);
    }

    private void enhanceBeansWithReferenceToRabbitAdmin(RabbitListener rabbitListener) {
        RabbitAdmin rabbitAdmin = this.getRabbitAdminBean(rabbitListener);
        this.applicationContext.getBeansOfType(AbstractExchange.class).values().stream().filter(this::isNotProcessed).forEach(exchange -> exchange.setAdminsThatShouldDeclare(new Object[]{rabbitAdmin != null ? rabbitAdmin : this}));
        this.applicationContext.getBeansOfType(Queue.class).values().stream().filter(this::isNotProcessed).forEach(queue -> queue.setAdminsThatShouldDeclare(new Object[]{rabbitAdmin != null ? rabbitAdmin : this}));
        this.applicationContext.getBeansOfType(Binding.class).values().stream().filter(this::isNotProcessed).forEach(binding -> binding.setAdminsThatShouldDeclare(new Object[]{rabbitAdmin != null ? rabbitAdmin : this}));
    }

    private RabbitAdmin getRabbitAdminBean(RabbitListener rabbitListener) {
        String name = RabbitAdminNameResolver.resolve(rabbitListener);
        RabbitAdmin rabbitAdmin = (RabbitAdmin)this.beanFactory.getBean(name, RabbitAdmin.class);
        if (rabbitAdmin == null) {
            throw new IllegalStateException(String.format(NO_ADMIN_BEAN_ERROR, name));
        }
        return rabbitAdmin;
    }

    private boolean isNotProcessed(Declarable declarable) {
        return declarable.getDeclaringAdmins() == null || declarable.getDeclaringAdmins().stream().noneMatch(item -> item == this) && declarable.getDeclaringAdmins().stream().noneMatch(item -> item instanceof RabbitAdmin);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        super.setBeanFactory(beanFactory);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

