/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.impl;

import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.dml.UpdateClause;
import com.mysema.query.jpa.JPQLSerializer;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.impl.JPAProvider;
import com.mysema.query.jpa.impl.JPAUtil;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.NullExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class JPAUpdateClause
implements UpdateClause<JPAUpdateClause> {
    private final QueryMetadata metadata = new DefaultQueryMetadata();
    private final EntityManager entityManager;
    private final JPQLTemplates templates;

    public JPAUpdateClause(EntityManager em, EntityPath<?> entity) {
        this(em, entity, JPAProvider.getTemplates(em));
    }

    public JPAUpdateClause(EntityManager em, EntityPath<?> entity, JPQLTemplates templates) {
        this.entityManager = em;
        this.templates = templates;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
    }

    public long execute() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, this.entityManager);
        serializer.serializeForUpdate(this.metadata);
        Map constants = serializer.getConstantToLabel();
        Query query = this.entityManager.createQuery(serializer.toString());
        JPAUtil.setConstants(query, constants, this.metadata.getParams());
        return query.executeUpdate();
    }

    public <T> JPAUpdateClause set(Path<T> path, T value) {
        if (value != null) {
            this.metadata.addProjection(new Expression[]{ExpressionUtils.eqConst(path, value)});
        } else {
            this.setNull(path);
        }
        return this;
    }

    public <T> JPAUpdateClause set(Path<T> path, Expression<? extends T> expression) {
        if (expression != null) {
            this.metadata.addProjection(new Expression[]{ExpressionUtils.eq(path, expression)});
        } else {
            this.setNull(path);
        }
        return this;
    }

    public <T> JPAUpdateClause setNull(Path<T> path) {
        this.metadata.addProjection(new Expression[]{ExpressionUtils.eq(path, (Expression)new NullExpression(path.getType()))});
        return this;
    }

    public JPAUpdateClause set(List<? extends Path<?>> paths, List<?> values) {
        for (int i = 0; i < paths.size(); ++i) {
            if (values.get(i) != null) {
                this.metadata.addProjection(new Expression[]{ExpressionUtils.eqConst((Expression)((Expression)paths.get(i)), values.get(i))});
                continue;
            }
            this.metadata.addProjection(new Expression[]{ExpressionUtils.eq((Expression)((Expression)paths.get(i)), (Expression)new NullExpression(paths.get(i).getType()))});
        }
        return this;
    }

    public JPAUpdateClause where(Predicate ... o) {
        this.metadata.addWhere(o);
        return this;
    }

    public String toString() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, this.entityManager);
        serializer.serializeForUpdate(this.metadata);
        return serializer.toString();
    }

    public boolean isEmpty() {
        return this.metadata.getProjection().isEmpty();
    }
}

