/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.Template;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.TemplateFactory;
import com.mysema.query.types.Visitor;
import java.util.Arrays;
import java.util.List;

public class TemplateExpressionImpl<T>
extends ExpressionBase<T>
implements TemplateExpression<T> {
    private static final long serialVersionUID = 6951623726800809083L;
    private final List<Expression<?>> args;
    private final Template template;

    public static <C> Expression<C> create(Class<C> cl, String template, Expression<?> ... args) {
        return TemplateExpressionImpl.create(cl, TemplateFactory.DEFAULT.create(template), args);
    }

    public static <C> Expression<C> create(Class<C> cl, Template template, Expression<?> ... args) {
        return new TemplateExpressionImpl<C>(cl, template, args);
    }

    public TemplateExpressionImpl(Class<? extends T> type, Template template, Expression<?> ... args) {
        this(type, template, Arrays.asList(args));
    }

    public TemplateExpressionImpl(Class<? extends T> type, Template template, List<Expression<?>> args) {
        super(type);
        this.args = (List)Assert.notNull(args, (String)"args");
        this.template = (Template)Assert.notNull((Object)template, (String)"template");
    }

    @Override
    public Expression<?> getArg(int index) {
        return this.getArgs().get(index);
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.args;
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TemplateExpression) {
            TemplateExpression c = (TemplateExpression)o;
            return c.getTemplate().equals(this.template) && c.getType().equals(this.getType());
        }
        return false;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }
}

