/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query;

import com.google.common.base.Objects;
import com.mysema.query.BooleanBuilder;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinType;
import com.mysema.query.QueryException;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.ValidatingVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class DefaultQueryMetadata
implements QueryMetadata,
Cloneable {
    private static final long serialVersionUID = 317736313966701232L;
    private boolean distinct;
    private Set<Expression<?>> exprInJoins = new HashSet();
    private List<Expression<?>> groupBy = new ArrayList();
    private BooleanBuilder having = new BooleanBuilder();
    private List<JoinExpression> joins = new ArrayList<JoinExpression>();
    @Nullable
    private QueryModifiers modifiers = QueryModifiers.EMPTY;
    private List<OrderSpecifier<?>> orderBy = new ArrayList();
    private List<Expression<?>> projection = new ArrayList();
    private Map<ParamExpression<?>, Object> params = new HashMap();
    private boolean unique;
    private BooleanBuilder where = new BooleanBuilder();
    private Set<QueryFlag> flags = new LinkedHashSet<QueryFlag>();
    private final ValidatingVisitor validatingVisitor = new ValidatingVisitor(this.exprInJoins);
    private boolean validate = true;

    public DefaultQueryMetadata noValidate() {
        this.validate = false;
        return this;
    }

    @Override
    public void addGroupBy(Expression<?> ... o) {
        this.validate(o);
        this.groupBy.addAll(Arrays.asList(o));
    }

    @Override
    public void addHaving(Predicate ... o) {
        for (Predicate e : o) {
            if (e == null || BooleanBuilder.class.isInstance(e) && !((BooleanBuilder)e).hasValue()) continue;
            this.validate(e);
            this.having.and(e);
        }
    }

    @Override
    public void addJoin(JoinType joinType, Expression<?> expr) {
        this.addJoin(new JoinExpression(joinType, expr));
    }

    @Override
    public void addJoin(JoinExpression ... j) {
        for (JoinExpression join : j) {
            Expression<?> expr = join.getTarget();
            if (this.exprInJoins.contains(expr)) {
                throw new IllegalStateException(expr + " is already used");
            }
            this.validateJoin(join);
            this.exprInJoins.add(expr);
            this.validate(expr);
            this.joins.add(join);
        }
    }

    private void validateJoin(JoinExpression join) {
        if (join.getTarget() instanceof Path) {
            Path path = (Path)join.getTarget();
            if (join.getType() == JoinType.DEFAULT) {
                this.ensureRoot(path);
            }
        }
    }

    @Override
    public void addJoinCondition(Predicate o) {
        if (!this.joins.isEmpty()) {
            this.validate(o);
            this.joins.get(this.joins.size() - 1).addCondition(o);
        }
    }

    @Override
    public void addOrderBy(OrderSpecifier<?> ... o) {
        this.orderBy.addAll(Arrays.asList(o));
    }

    @Override
    public void addProjection(Expression<?> ... o) {
        this.validate(o);
        this.projection.addAll(Arrays.asList(o));
    }

    @Override
    public void addWhere(Predicate ... o) {
        for (Predicate e : o) {
            if (e == null || BooleanBuilder.class.isInstance(e) && !((BooleanBuilder)e).hasValue()) continue;
            this.validate(e);
            this.where.and(e);
        }
    }

    @Override
    public void clearOrderBy() {
        this.orderBy = new ArrayList();
    }

    @Override
    public void clearProjection() {
        this.projection = new ArrayList();
    }

    @Override
    public void clearWhere() {
        this.where = new BooleanBuilder();
    }

    @Override
    public QueryMetadata clone() {
        try {
            DefaultQueryMetadata clone = (DefaultQueryMetadata)super.clone();
            clone.exprInJoins = new HashSet(this.exprInJoins);
            clone.groupBy = new ArrayList(this.groupBy);
            clone.having = this.having.clone();
            clone.joins = new ArrayList<JoinExpression>(this.joins);
            clone.modifiers = new QueryModifiers(this.modifiers);
            clone.orderBy = new ArrayList(this.orderBy);
            clone.projection = new ArrayList(this.projection);
            clone.params = new HashMap(this.params);
            clone.where = this.where.clone();
            clone.flags = new LinkedHashSet<QueryFlag>(this.flags);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new QueryException(e);
        }
    }

    private void ensureRoot(Path<?> path) {
        if (path.getMetadata().getParent() != null) {
            throw new IllegalArgumentException("Only root paths are allowed for joins : " + path);
        }
    }

    @Override
    public List<Expression<?>> getGroupBy() {
        return Collections.unmodifiableList(this.groupBy);
    }

    @Override
    public Predicate getHaving() {
        return this.having.hasValue() ? this.having.getValue() : null;
    }

    @Override
    public List<JoinExpression> getJoins() {
        return Collections.unmodifiableList(this.joins);
    }

    @Override
    @Nullable
    public QueryModifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public Map<ParamExpression<?>, Object> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public List<OrderSpecifier<?>> getOrderBy() {
        return Collections.unmodifiableList(this.orderBy);
    }

    @Override
    public List<Expression<?>> getProjection() {
        return Collections.unmodifiableList(this.projection);
    }

    @Override
    public Predicate getWhere() {
        return this.where.hasValue() ? this.where.getValue() : null;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public void reset() {
        this.clearProjection();
        this.params = new HashMap();
        this.modifiers = QueryModifiers.EMPTY;
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public void setLimit(Long limit) {
        this.modifiers = this.modifiers == null || this.modifiers.getOffset() == null ? QueryModifiers.limit(limit) : new QueryModifiers(limit, this.modifiers.getOffset());
    }

    @Override
    public void setModifiers(@Nullable QueryModifiers restriction) {
        this.modifiers = restriction;
    }

    @Override
    public void setOffset(Long offset) {
        this.modifiers = this.modifiers == null || this.modifiers.getLimit() == null ? QueryModifiers.offset(offset) : new QueryModifiers(this.modifiers.getLimit(), offset);
    }

    @Override
    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    @Override
    public <T> void setParam(ParamExpression<T> param, T value) {
        this.params.put(param, value);
    }

    @Override
    public void addFlag(QueryFlag flag) {
        this.flags.add(flag);
    }

    @Override
    public Set<QueryFlag> getFlags() {
        return this.flags;
    }

    @Override
    public boolean hasFlag(QueryFlag flag) {
        return this.flags.contains(flag);
    }

    private void validate(Expression<?> ... expr) {
        if (this.validate) {
            for (Expression<?> e : expr) {
                e.accept(this.validatingVisitor, null);
            }
        }
    }

    @Override
    public void setValidate(boolean v) {
        this.validate = v;
    }

    public boolean equals(Object o) {
        if (o instanceof QueryMetadata) {
            QueryMetadata q = (QueryMetadata)o;
            return ((Object)q.getFlags()).equals(this.flags) && ((Object)q.getGroupBy()).equals(this.groupBy) && Objects.equal((Object)q.getHaving(), (Object)this.having.getValue()) && q.isDistinct() == this.distinct && q.isUnique() == this.unique && ((Object)q.getJoins()).equals(this.joins) && Objects.equal((Object)q.getModifiers(), (Object)this.modifiers) && ((Object)q.getOrderBy()).equals(this.orderBy) && ((Object)q.getParams()).equals(this.params) && ((Object)q.getProjection()).equals(this.projection) && Objects.equal((Object)q.getWhere(), (Object)this.where.getValue());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.flags, this.groupBy, this.having, this.joins, this.modifiers, this.orderBy, this.params, this.projection, this.unique, this.where});
    }
}

