/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.ComparableExpressionBase;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.util.MathUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class NumberExpression<T extends Number>
extends ComparableExpressionBase<T> {
    private static final long serialVersionUID = -5485902768703364888L;
    @Nullable
    private static final NumberExpression<Double> random = NumberOperation.create(Double.class, Ops.MathOps.RANDOM, new Expression[0]);
    @Nullable
    private volatile NumberExpression<T> abs;
    @Nullable
    private volatile NumberExpression<T> sum;
    @Nullable
    private volatile NumberExpression<T> min;
    @Nullable
    private volatile NumberExpression<T> max;
    @Nullable
    private volatile NumberExpression<T> floor;
    @Nullable
    private volatile NumberExpression<T> ceil;
    @Nullable
    private volatile NumberExpression<Double> avg;
    @Nullable
    private volatile NumberExpression<Double> sqrt;
    @Nullable
    private volatile NumberExpression<T> negation;
    @Nullable
    private volatile NumberExpression<Integer> round;

    public static <A extends Number> NumberExpression<A> max(Expression<A> left, Expression<A> right) {
        return NumberOperation.create(left.getType(), Ops.MathOps.MAX, left, right);
    }

    public static <A extends Number> NumberExpression<A> min(Expression<A> left, Expression<A> right) {
        return NumberOperation.create(left.getType(), Ops.MathOps.MIN, left, right);
    }

    public static NumberExpression<Double> random() {
        return random;
    }

    public NumberExpression(Expression<T> mixin) {
        super(mixin);
    }

    @Override
    public NumberExpression<T> as(Path<T> alias) {
        return NumberOperation.create(this.getType(), Ops.ALIAS, this, alias);
    }

    @Override
    public NumberExpression<T> as(String alias) {
        return NumberOperation.create(this.getType(), Ops.ALIAS, this, new PathImpl(this.getType(), alias));
    }

    public NumberExpression<T> abs() {
        if (this.abs == null) {
            this.abs = NumberOperation.create(this.getType(), Ops.MathOps.ABS, this);
        }
        return this.abs;
    }

    public <N extends Number> NumberExpression<T> add(Expression<N> right) {
        return NumberOperation.create(this.getType(), Ops.ADD, this, right);
    }

    public <N extends Number> NumberExpression<T> add(N right) {
        return NumberOperation.create(this.getType(), Ops.ADD, this, new ConstantImpl<N>(right));
    }

    public NumberExpression<Double> avg() {
        if (this.avg == null) {
            this.avg = NumberOperation.create(Double.class, Ops.AggOps.AVG_AGG, this);
        }
        return this.avg;
    }

    public NumberExpression<Byte> byteValue() {
        return this.castToNum(Byte.class);
    }

    private T cast(Number number) {
        Class type = this.getType();
        if (type.equals(number.getClass())) {
            return (T)number;
        }
        if (Byte.class.equals(type)) {
            return (T)Byte.valueOf(number.byteValue());
        }
        if (Double.class.equals(type)) {
            return (T)Double.valueOf(number.doubleValue());
        }
        if (Float.class.equals(type)) {
            return (T)Float.valueOf(number.floatValue());
        }
        if (Integer.class.equals(type)) {
            return (T)Integer.valueOf(number.intValue());
        }
        if (Long.class.equals(type)) {
            return (T)Long.valueOf(number.longValue());
        }
        if (Short.class.equals(type)) {
            return (T)Short.valueOf(number.shortValue());
        }
        if (BigInteger.class.equals(type)) {
            return (T)new BigInteger(String.valueOf(number.longValue()));
        }
        if (BigDecimal.class.equals(type)) {
            return (T)new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Unsupported target type : " + type.getName());
    }

    @Override
    public <A extends Number> NumberExpression<A> castToNum(Class<A> type) {
        if (type.equals(this.getType())) {
            return this;
        }
        return NumberOperation.create(type, Ops.NUMCAST, this, new ConstantImpl<Class<A>>(type));
    }

    public NumberExpression<T> ceil() {
        if (this.ceil == null) {
            this.ceil = NumberOperation.create(this.getType(), Ops.MathOps.CEIL, this);
        }
        return this.ceil;
    }

    public <N extends Number> NumberExpression<Double> divide(Expression<N> right) {
        return NumberOperation.create(Double.class, Ops.DIV, this, right);
    }

    public <N extends Number> NumberExpression<Double> divide(N right) {
        return NumberOperation.create(Double.class, Ops.DIV, this, new ConstantImpl<N>(right));
    }

    public NumberExpression<Double> doubleValue() {
        return this.castToNum(Double.class);
    }

    public NumberExpression<Float> floatValue() {
        return this.castToNum(Float.class);
    }

    public NumberExpression<T> floor() {
        if (this.floor == null) {
            this.floor = NumberOperation.create(this.getType(), Ops.MathOps.FLOOR, this);
        }
        return this.floor;
    }

    public final <A extends Number> BooleanExpression goe(A right) {
        return this.goe(new ConstantImpl<T>(this.cast(right)));
    }

    public final <A extends Number> BooleanExpression goe(Expression<A> right) {
        return BooleanOperation.create(Ops.GOE, this, right);
    }

    public BooleanExpression goeAll(CollectionExpression<?, ? super T> right) {
        return this.goe(ExpressionUtils.all(right));
    }

    public BooleanExpression goeAny(CollectionExpression<?, ? super T> right) {
        return this.goe(ExpressionUtils.any(right));
    }

    public final <A extends Number> BooleanExpression gt(A right) {
        return this.gt(new ConstantImpl<T>(this.cast(right)));
    }

    public final <A extends Number> BooleanExpression gt(Expression<A> right) {
        return BooleanOperation.create(Ops.GT, this, right);
    }

    public BooleanExpression gtAll(CollectionExpression<?, ? super T> right) {
        return this.gt(ExpressionUtils.all(right));
    }

    public BooleanExpression gtAny(CollectionExpression<?, ? super T> right) {
        return this.gt(ExpressionUtils.any(right));
    }

    public final <A extends Number> BooleanExpression between(@Nullable A from, @Nullable A to) {
        if (from == null) {
            if (to != null) {
                return BooleanOperation.create(Ops.LOE, this, new ConstantImpl<A>(to));
            }
            throw new IllegalArgumentException("Either from or to needs to be non-null");
        }
        if (to == null) {
            return BooleanOperation.create(Ops.GOE, this, new ConstantImpl<A>(from));
        }
        return BooleanOperation.create(Ops.BETWEEN, this, new ConstantImpl<A>(from), new ConstantImpl<A>(to));
    }

    public final <A extends Number> BooleanExpression between(@Nullable Expression<A> from, @Nullable Expression<A> to) {
        if (from == null) {
            if (to != null) {
                return BooleanOperation.create(Ops.LOE, this, to);
            }
            throw new IllegalArgumentException("Either from or to needs to be non-null");
        }
        if (to == null) {
            return BooleanOperation.create(Ops.GOE, this, from);
        }
        return BooleanOperation.create(Ops.BETWEEN, this, from, to);
    }

    public final <A extends Number> BooleanExpression notBetween(A from, A to) {
        return this.between(from, to).not();
    }

    public final <A extends Number> BooleanExpression notBetween(Expression<A> from, Expression<A> to) {
        return this.between(from, to).not();
    }

    public NumberExpression<Integer> intValue() {
        return this.castToNum(Integer.class);
    }

    public final <A extends Number> BooleanExpression loe(A right) {
        return this.loe(new ConstantImpl<T>(this.cast(right)));
    }

    public final <A extends Number> BooleanExpression loe(Expression<A> right) {
        return BooleanOperation.create(Ops.LOE, this, right);
    }

    public BooleanExpression loeAll(CollectionExpression<?, ? super T> right) {
        return this.loe(ExpressionUtils.all(right));
    }

    public BooleanExpression loeAny(CollectionExpression<?, ? super T> right) {
        return this.loe(ExpressionUtils.any(right));
    }

    public NumberExpression<Long> longValue() {
        return this.castToNum(Long.class);
    }

    public final <A extends Number> BooleanExpression lt(A right) {
        return this.lt(new ConstantImpl<T>(this.cast(right)));
    }

    public final <A extends Number> BooleanExpression lt(Expression<A> right) {
        return BooleanOperation.create(Ops.LT, this, right);
    }

    public BooleanExpression ltAll(CollectionExpression<?, ? super T> right) {
        return this.lt(ExpressionUtils.all(right));
    }

    public BooleanExpression ltAny(CollectionExpression<?, ? super T> right) {
        return this.lt(ExpressionUtils.any(right));
    }

    public NumberExpression<T> max() {
        if (this.max == null) {
            this.max = NumberOperation.create(this.getType(), Ops.AggOps.MAX_AGG, this);
        }
        return this.max;
    }

    public NumberExpression<T> min() {
        if (this.min == null) {
            this.min = NumberOperation.create(this.getType(), Ops.AggOps.MIN_AGG, this);
        }
        return this.min;
    }

    public NumberExpression<T> mod(Expression<T> num) {
        return NumberOperation.create(this.getType(), Ops.MOD, this, num);
    }

    public NumberExpression<T> mod(T num) {
        return NumberOperation.create(this.getType(), Ops.MOD, this, new ConstantImpl<T>(num));
    }

    public <N extends Number> NumberExpression<T> multiply(Expression<N> right) {
        return NumberOperation.create(this.getType(), Ops.MULT, this, right);
    }

    public <N extends Number> NumberExpression<T> multiply(N right) {
        return NumberOperation.create(this.getType(), Ops.MULT, this, new ConstantImpl<N>(right));
    }

    public NumberExpression<T> negate() {
        if (this.negation == null) {
            this.negation = NumberOperation.create(this.getType(), Ops.NEGATE, this);
        }
        return this.negation;
    }

    public NumberExpression<Integer> round() {
        if (this.round == null) {
            this.round = NumberOperation.create(Integer.class, Ops.MathOps.ROUND, this);
        }
        return this.round;
    }

    public NumberExpression<Short> shortValue() {
        return this.castToNum(Short.class);
    }

    public NumberExpression<Double> sqrt() {
        if (this.sqrt == null) {
            this.sqrt = NumberOperation.create(Double.class, Ops.MathOps.SQRT, this);
        }
        return this.sqrt;
    }

    public <N extends Number> NumberExpression<T> subtract(Expression<N> right) {
        return NumberOperation.create(this.getType(), Ops.SUB, this, right);
    }

    public <N extends Number> NumberExpression<T> subtract(N right) {
        return NumberOperation.create(this.getType(), Ops.SUB, this, new ConstantImpl<N>(right));
    }

    public NumberExpression<T> sum() {
        if (this.sum == null) {
            this.sum = NumberOperation.create(this.getType(), Ops.AggOps.SUM_AGG, this);
        }
        return this.sum;
    }

    public BooleanExpression in(Number ... numbers) {
        return super.in(this.convert(numbers));
    }

    public BooleanExpression notIn(Number ... numbers) {
        return super.notIn(this.convert(numbers));
    }

    private List<T> convert(Number ... numbers) {
        ArrayList list = new ArrayList(numbers.length);
        for (int i = 0; i < numbers.length; ++i) {
            list.add(MathUtils.cast(numbers[i], this.getType()));
        }
        return list;
    }
}

