/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections;

import com.mysema.query.collections.CollQuery;
import com.mysema.query.collections.DefaultQueryEngine;
import com.mysema.query.collections.QueryEngine;
import com.mysema.query.dml.UpdateClause;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.util.BeanMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollUpdateClause<T>
implements UpdateClause<CollUpdateClause<T>> {
    private final Path<T> expr;
    private final Map<Path<?>, Object> paths = new HashMap();
    private final CollQuery query;

    public CollUpdateClause(QueryEngine qe, Path<T> expr, Iterable<? extends T> col) {
        this.query = (CollQuery)new CollQuery(qe).from(expr, col);
        this.expr = expr;
    }

    public CollUpdateClause(Path<T> expr, Iterable<? extends T> col) {
        this(DefaultQueryEngine.getDefault(), expr, col);
    }

    public long execute() {
        int rv = 0;
        for (T match : this.query.list(this.expr)) {
            BeanMap beanMap = new BeanMap(match);
            for (Map.Entry<Path<?>, Object> entry : this.paths.entrySet()) {
                String propertyName = entry.getKey().getMetadata().getName();
                beanMap.put(propertyName, entry.getValue());
            }
            ++rv;
        }
        return rv;
    }

    public <U> CollUpdateClause<T> set(Path<U> path, U value) {
        this.paths.put(path, value);
        return this;
    }

    public <U> CollUpdateClause<T> set(Path<U> path, Expression<? extends U> expression) {
        throw new UnsupportedOperationException();
    }

    public <U> CollUpdateClause<T> setNull(Path<U> path) {
        this.paths.put(path, null);
        return this;
    }

    public CollUpdateClause<T> set(List<? extends Path<?>> p, List<?> v) {
        for (int i = 0; i < p.size(); ++i) {
            this.paths.put(p.get(i), v.get(i));
        }
        return this;
    }

    public CollUpdateClause<T> where(Predicate ... o) {
        this.query.where(o);
        return this;
    }

    public String toString() {
        return "update " + this.query;
    }

    public boolean isEmpty() {
        return this.paths.isEmpty();
    }
}

