/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.JoinType;
import com.mysema.query.QueryException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.SearchResults;
import com.mysema.query.SimpleQuery;
import com.mysema.query.Tuple;
import com.mysema.query.collections.CollQueryMixin;
import com.mysema.query.collections.QueryEngine;
import com.mysema.query.support.ProjectableQuery;
import com.mysema.query.types.Expression;
import com.mysema.query.types.MapExpression;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractCollQuery<Q extends AbstractCollQuery<Q>>
extends ProjectableQuery<Q>
implements SimpleQuery<Q> {
    private final Map<Expression<?>, Iterable<?>> iterables = new HashMap();
    private final QueryEngine queryEngine;

    public AbstractCollQuery(QueryMetadata metadata, QueryEngine queryEngine) {
        super(new CollQueryMixin(metadata));
        this.queryMixin.setSelf((Object)this);
        this.queryEngine = queryEngine;
    }

    public long count() {
        try {
            long l = this.queryEngine.count(this.getMetadata(), this.iterables);
            return l;
        }
        catch (Exception e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    public boolean exists() {
        try {
            boolean bl = this.queryEngine.exists(this.getMetadata(), this.iterables);
            return bl;
        }
        catch (Exception e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    private <D> Expression<D> createAlias(Path<? extends Collection<D>> target, Path<D> alias) {
        return OperationImpl.create((Class)alias.getType(), (Operator)Ops.ALIAS, target, alias);
    }

    private <D> Expression<D> createAlias(MapExpression<?, D> target, Path<D> alias) {
        return OperationImpl.create((Class)alias.getType(), (Operator)Ops.ALIAS, target, alias);
    }

    public <A> Q from(Path<A> entity, Iterable<? extends A> col) {
        this.iterables.put((Expression<?>)entity, col);
        this.getMetadata().addJoin(JoinType.DEFAULT, entity);
        return (Q)((Object)this);
    }

    public <A> Q bind(Path<A> entity, Iterable<? extends A> col) {
        this.iterables.put((Expression<?>)entity, col);
        return (Q)((Object)this);
    }

    public Q groupBy(Expression<?> e) {
        throw new UnsupportedOperationException();
    }

    public Q groupBy(Expression<?> ... o) {
        throw new UnsupportedOperationException();
    }

    public Q having(Predicate e) {
        throw new UnsupportedOperationException();
    }

    public Q having(Predicate ... e) {
        throw new UnsupportedOperationException();
    }

    public abstract QueryMetadata getMetadata();

    protected QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    public <P> Q innerJoin(Path<? extends Collection<P>> target, Path<P> alias) {
        this.getMetadata().addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return (Q)((Object)this);
    }

    public <P> Q innerJoin(MapExpression<?, P> target, Path<P> alias) {
        this.getMetadata().addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return (Q)((Object)this);
    }

    public <P> Q leftJoin(Path<? extends Collection<P>> target, Path<P> alias) {
        this.getMetadata().addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return (Q)((Object)this);
    }

    public <P> Q leftJoin(MapExpression<?, P> target, Path<P> alias) {
        this.getMetadata().addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return (Q)((Object)this);
    }

    public CloseableIterator<Tuple> iterate(Expression<?> ... args) {
        return this.iterate((Expression<RT>)this.queryMixin.createProjection(args));
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> projection) {
        try {
            projection = this.queryMixin.addProjection(projection);
            IteratorAdapter iteratorAdapter = new IteratorAdapter(this.queryEngine.list(this.getMetadata(), this.iterables, projection).iterator());
            return iteratorAdapter;
        }
        finally {
            this.reset();
        }
    }

    public List<Tuple> list(Expression<?> ... args) {
        return this.list((Expression<RT>)this.queryMixin.createProjection(args));
    }

    public <RT> List<RT> list(Expression<RT> projection) {
        try {
            projection = this.queryMixin.addProjection(projection);
            List list = this.queryEngine.list(this.getMetadata(), this.iterables, projection);
            return list;
        }
        finally {
            this.reset();
        }
    }

    public SearchResults<Tuple> listResults(Expression<?> ... args) {
        return this.listResults((Expression<RT>)this.queryMixin.createProjection(args));
    }

    public <RT> SearchResults<RT> listResults(Expression<RT> projection) {
        projection = this.queryMixin.addProjection(projection);
        long count = this.queryEngine.count(this.getMetadata(), this.iterables);
        if (count > 0L) {
            List list = this.queryEngine.list(this.getMetadata(), this.iterables, projection);
            this.reset();
            return new SearchResults(list, this.getMetadata().getModifiers(), count);
        }
        this.reset();
        return SearchResults.emptyResults();
    }

    public Tuple uniqueResult(Expression<?> ... args) {
        return (Tuple)this.uniqueResult((Expression<RT>)this.queryMixin.createProjection(args));
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        this.queryMixin.setUnique(true);
        if (this.queryMixin.getMetadata().getModifiers().getLimit() == null) {
            this.limit(2L);
        }
        return (RT)this.uniqueResult(this.iterate(expr));
    }

    private void reset() {
        this.getMetadata().clearProjection();
    }
}

