/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.DialerPreview;
import com.mypurecloud.sdk.v2.model.Segment;
import com.mypurecloud.sdk.v2.model.Voicemail;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Callback
implements Serializable {
    private StateEnum state = null;
    private String id = null;
    private List<Segment> segments = new ArrayList<Segment>();
    private DirectionEnum direction = null;
    private Boolean held = null;
    private DisconnectTypeEnum disconnectType = null;
    private Date startHoldTime = null;
    private DialerPreview dialerPreview = null;
    private Voicemail voicemail = null;
    private List<String> callbackNumbers = new ArrayList<String>();
    private String callbackUserName = null;
    private String scriptId = null;
    private Boolean externalCampaign = null;
    private Boolean skipEnabled = null;
    private Integer timeoutSeconds = null;
    private Date startAlertingTime = null;
    private Date connectedTime = null;
    private Date disconnectedTime = null;
    private Date callbackScheduledTime = null;
    private String automatedCallbackConfigId = null;
    private String provider = null;
    private String peerId = null;

    public Callback state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The connection state of this communication.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Callback id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for this communication.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Callback segments(List<Segment> segments) {
        this.segments = segments;
        return this;
    }

    @ApiModelProperty(example="null", value="The time line of the participant's callback, divided into activity segments.")
    @JsonProperty(value="segments")
    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public Callback direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The direction of the call")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public Callback held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this call is held and the person on this side hears silence.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public Callback disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public Callback startHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the callback was placed on hold in the cloud clock if the callback is currently on hold. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startHoldTime")
    public Date getStartHoldTime() {
        return this.startHoldTime;
    }

    public void setStartHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
    }

    public Callback dialerPreview(DialerPreview dialerPreview) {
        this.dialerPreview = dialerPreview;
        return this;
    }

    @ApiModelProperty(example="null", value="The preview data to be used when this callback is a Preview.")
    @JsonProperty(value="dialerPreview")
    public DialerPreview getDialerPreview() {
        return this.dialerPreview;
    }

    public void setDialerPreview(DialerPreview dialerPreview) {
        this.dialerPreview = dialerPreview;
    }

    public Callback voicemail(Voicemail voicemail) {
        this.voicemail = voicemail;
        return this;
    }

    @ApiModelProperty(example="null", value="The voicemail data to be used when this callback is an ACD voicemail.")
    @JsonProperty(value="voicemail")
    public Voicemail getVoicemail() {
        return this.voicemail;
    }

    public void setVoicemail(Voicemail voicemail) {
        this.voicemail = voicemail;
    }

    public Callback callbackNumbers(List<String> callbackNumbers) {
        this.callbackNumbers = callbackNumbers;
        return this;
    }

    @ApiModelProperty(example="null", value="The phone number(s) to use to place the callback.")
    @JsonProperty(value="callbackNumbers")
    public List<String> getCallbackNumbers() {
        return this.callbackNumbers;
    }

    public void setCallbackNumbers(List<String> callbackNumbers) {
        this.callbackNumbers = callbackNumbers;
    }

    public Callback callbackUserName(String callbackUserName) {
        this.callbackUserName = callbackUserName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the user requesting a callback.")
    @JsonProperty(value="callbackUserName")
    public String getCallbackUserName() {
        return this.callbackUserName;
    }

    public void setCallbackUserName(String callbackUserName) {
        this.callbackUserName = callbackUserName;
    }

    public Callback scriptId(String scriptId) {
        this.scriptId = scriptId;
        return this;
    }

    @ApiModelProperty(example="null", value="The UUID of the script to use.")
    @JsonProperty(value="scriptId")
    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public Callback externalCampaign(Boolean externalCampaign) {
        this.externalCampaign = externalCampaign;
        return this;
    }

    @ApiModelProperty(example="null", value="True if the call for the callback uses external dialing.")
    @JsonProperty(value="externalCampaign")
    public Boolean getExternalCampaign() {
        return this.externalCampaign;
    }

    public void setExternalCampaign(Boolean externalCampaign) {
        this.externalCampaign = externalCampaign;
    }

    public Callback skipEnabled(Boolean skipEnabled) {
        this.skipEnabled = skipEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="True if the ability to skip a callback should be enabled.")
    @JsonProperty(value="skipEnabled")
    public Boolean getSkipEnabled() {
        return this.skipEnabled;
    }

    public void setSkipEnabled(Boolean skipEnabled) {
        this.skipEnabled = skipEnabled;
    }

    public Callback timeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of seconds before the system automatically places a call for a callback.  0 means the automatic placement is disabled.")
    @JsonProperty(value="timeoutSeconds")
    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public Callback startAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the communication has when it is first put into an alerting state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startAlertingTime")
    public Date getStartAlertingTime() {
        return this.startAlertingTime;
    }

    public void setStartAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
    }

    public Callback connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public Callback disconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="disconnectedTime")
    public Date getDisconnectedTime() {
        return this.disconnectedTime;
    }

    public void setDisconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
    }

    public Callback callbackScheduledTime(Date callbackScheduledTime) {
        this.callbackScheduledTime = callbackScheduledTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication is scheduled in the provider clock. If this value is missing it indicates the callback will be placed immediately. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="callbackScheduledTime")
    public Date getCallbackScheduledTime() {
        return this.callbackScheduledTime;
    }

    public void setCallbackScheduledTime(Date callbackScheduledTime) {
        this.callbackScheduledTime = callbackScheduledTime;
    }

    public Callback automatedCallbackConfigId(String automatedCallbackConfigId) {
        this.automatedCallbackConfigId = automatedCallbackConfigId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the config for automatically placing the callback (and handling the disposition). If null, the callback will not be placed automatically but routed to an agent as per normal.")
    @JsonProperty(value="automatedCallbackConfigId")
    public String getAutomatedCallbackConfigId() {
        return this.automatedCallbackConfigId;
    }

    public void setAutomatedCallbackConfigId(String automatedCallbackConfigId) {
        this.automatedCallbackConfigId = automatedCallbackConfigId;
    }

    public Callback provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the callback.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public Callback peerId(String peerId) {
        this.peerId = peerId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the peer communication corresponding to a matching leg for this communication.")
    @JsonProperty(value="peerId")
    public String getPeerId() {
        return this.peerId;
    }

    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Callback callback = (Callback)o;
        return Objects.equals((Object)this.state, (Object)callback.state) && Objects.equals(this.id, callback.id) && Objects.equals(this.segments, callback.segments) && Objects.equals((Object)this.direction, (Object)callback.direction) && Objects.equals(this.held, callback.held) && Objects.equals((Object)this.disconnectType, (Object)callback.disconnectType) && Objects.equals(this.startHoldTime, callback.startHoldTime) && Objects.equals(this.dialerPreview, callback.dialerPreview) && Objects.equals(this.voicemail, callback.voicemail) && Objects.equals(this.callbackNumbers, callback.callbackNumbers) && Objects.equals(this.callbackUserName, callback.callbackUserName) && Objects.equals(this.scriptId, callback.scriptId) && Objects.equals(this.externalCampaign, callback.externalCampaign) && Objects.equals(this.skipEnabled, callback.skipEnabled) && Objects.equals(this.timeoutSeconds, callback.timeoutSeconds) && Objects.equals(this.startAlertingTime, callback.startAlertingTime) && Objects.equals(this.connectedTime, callback.connectedTime) && Objects.equals(this.disconnectedTime, callback.disconnectedTime) && Objects.equals(this.callbackScheduledTime, callback.callbackScheduledTime) && Objects.equals(this.automatedCallbackConfigId, callback.automatedCallbackConfigId) && Objects.equals(this.provider, callback.provider) && Objects.equals(this.peerId, callback.peerId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.id, this.segments, this.direction, this.held, this.disconnectType, this.startHoldTime, this.dialerPreview, this.voicemail, this.callbackNumbers, this.callbackUserName, this.scriptId, this.externalCampaign, this.skipEnabled, this.timeoutSeconds, this.startAlertingTime, this.connectedTime, this.disconnectedTime, this.callbackScheduledTime, this.automatedCallbackConfigId, this.provider, this.peerId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Callback {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    startHoldTime: ").append(this.toIndentedString(this.startHoldTime)).append("\n");
        sb.append("    dialerPreview: ").append(this.toIndentedString(this.dialerPreview)).append("\n");
        sb.append("    voicemail: ").append(this.toIndentedString(this.voicemail)).append("\n");
        sb.append("    callbackNumbers: ").append(this.toIndentedString(this.callbackNumbers)).append("\n");
        sb.append("    callbackUserName: ").append(this.toIndentedString(this.callbackUserName)).append("\n");
        sb.append("    scriptId: ").append(this.toIndentedString(this.scriptId)).append("\n");
        sb.append("    externalCampaign: ").append(this.toIndentedString(this.externalCampaign)).append("\n");
        sb.append("    skipEnabled: ").append(this.toIndentedString(this.skipEnabled)).append("\n");
        sb.append("    timeoutSeconds: ").append(this.toIndentedString(this.timeoutSeconds)).append("\n");
        sb.append("    startAlertingTime: ").append(this.toIndentedString(this.startAlertingTime)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    disconnectedTime: ").append(this.toIndentedString(this.disconnectedTime)).append("\n");
        sb.append("    callbackScheduledTime: ").append(this.toIndentedString(this.callbackScheduledTime)).append("\n");
        sb.append("    automatedCallbackConfigId: ").append(this.toIndentedString(this.automatedCallbackConfigId)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    peerId: ").append(this.toIndentedString(this.peerId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        CLIENT("client"),
        SYSTEM("system"),
        TIMEOUT("timeout"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_FORWARD("transfer.forward"),
        TRANSFER_NOANSWER("transfer.noanswer"),
        TRANSFER_NOTAVAILABLE("transfer.notavailable"),
        TRANSPORT_FAILURE("transport.failure"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        SPAM("spam"),
        UNCALLABLE("uncallable");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        SCHEDULED("scheduled"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

