/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class PostAuthorizationSubjectDivisionRoleRequest {
    private String subjectId;
    private String divisionId;
    private String roleId;
    private String subjectType;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getSubjectId() {
        return this.subjectId;
    }

    public void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }

    public PostAuthorizationSubjectDivisionRoleRequest withSubjectId(String subjectId) {
        this.setSubjectId(subjectId);
        return this;
    }

    public String getDivisionId() {
        return this.divisionId;
    }

    public void setDivisionId(String divisionId) {
        this.divisionId = divisionId;
    }

    public PostAuthorizationSubjectDivisionRoleRequest withDivisionId(String divisionId) {
        this.setDivisionId(divisionId);
        return this;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public PostAuthorizationSubjectDivisionRoleRequest withRoleId(String roleId) {
        this.setRoleId(roleId);
        return this;
    }

    public String getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public PostAuthorizationSubjectDivisionRoleRequest withSubjectType(String subjectType) {
        this.setSubjectType(subjectType);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostAuthorizationSubjectDivisionRoleRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.subjectId == null) {
            throw new IllegalStateException("Missing the required parameter 'subjectId' when building request for PostAuthorizationSubjectDivisionRoleRequest.");
        }
        if (this.divisionId == null) {
            throw new IllegalStateException("Missing the required parameter 'divisionId' when building request for PostAuthorizationSubjectDivisionRoleRequest.");
        }
        if (this.roleId == null) {
            throw new IllegalStateException("Missing the required parameter 'roleId' when building request for PostAuthorizationSubjectDivisionRoleRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/authorization/subjects/{subjectId}/divisions/{divisionId}/roles/{roleId}").withPathParameter("subjectId", this.subjectId).withPathParameter("divisionId", this.divisionId).withPathParameter("roleId", this.roleId).withQueryParameters("subjectType", "", this.subjectType).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String subjectId, String divisionId, String roleId) {
        return new Builder().withRequiredParams(subjectId, divisionId, roleId);
    }

    public static class Builder {
        private final PostAuthorizationSubjectDivisionRoleRequest request = new PostAuthorizationSubjectDivisionRoleRequest();

        private Builder() {
        }

        public Builder withSubjectId(String subjectId) {
            this.request.setSubjectId(subjectId);
            return this;
        }

        public Builder withDivisionId(String divisionId) {
            this.request.setDivisionId(divisionId);
            return this;
        }

        public Builder withRoleId(String roleId) {
            this.request.setRoleId(roleId);
            return this;
        }

        public Builder withSubjectType(String subjectType) {
            this.request.setSubjectType(subjectType);
            return this;
        }

        public Builder withRequiredParams(String subjectId, String divisionId, String roleId) {
            this.request.setSubjectId(subjectId);
            this.request.setDivisionId(divisionId);
            this.request.setRoleId(roleId);
            return this;
        }

        public PostAuthorizationSubjectDivisionRoleRequest build() {
            if (this.request.subjectId == null) {
                throw new IllegalStateException("Missing the required parameter 'subjectId' when building request for PostAuthorizationSubjectDivisionRoleRequest.");
            }
            if (this.request.divisionId == null) {
                throw new IllegalStateException("Missing the required parameter 'divisionId' when building request for PostAuthorizationSubjectDivisionRoleRequest.");
            }
            if (this.request.roleId == null) {
                throw new IllegalStateException("Missing the required parameter 'roleId' when building request for PostAuthorizationSubjectDivisionRoleRequest.");
            }
            return this.request;
        }
    }
}

