/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ScimMetadata;
import com.mypurecloud.sdk.v2.model.ScimV2MemberReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines a SCIM group.")
public class ScimV2Group
implements Serializable {
    private String id = null;
    private List<String> schemas = new ArrayList<String>();
    private String displayName = null;
    private List<ScimV2MemberReference> members = new ArrayList<ScimV2MemberReference>();
    private ScimMetadata meta = null;

    @ApiModelProperty(example="null", value="The ID of the SCIM resource. Set by the service provider. \"caseExact\" is set to \"true\". \"Mutability\" is set to \"readOnly\". \"Returned\" is set to \"always\".")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ScimV2Group schemas(List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of supported schemas.")
    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    @ApiModelProperty(example="null", value="The display name of the group.")
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public ScimV2Group members(List<ScimV2MemberReference> members) {
        this.members = members;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of members in the group.")
    @JsonProperty(value="members")
    public List<ScimV2MemberReference> getMembers() {
        return this.members;
    }

    public void setMembers(List<ScimV2MemberReference> members) {
        this.members = members;
    }

    public ScimV2Group meta(ScimMetadata meta) {
        this.meta = meta;
        return this;
    }

    @ApiModelProperty(example="null", value="The metadata of the SCIM resource.")
    @JsonProperty(value="meta")
    public ScimMetadata getMeta() {
        return this.meta;
    }

    public void setMeta(ScimMetadata meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimV2Group scimV2Group = (ScimV2Group)o;
        return Objects.equals(this.id, scimV2Group.id) && Objects.equals(this.schemas, scimV2Group.schemas) && Objects.equals(this.displayName, scimV2Group.displayName) && Objects.equals(this.members, scimV2Group.members) && Objects.equals(this.meta, scimV2Group.meta);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.schemas, this.displayName, this.members, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimV2Group {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    members: ").append(this.toIndentedString(this.members)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

