/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.util.concurrent.SettableFuture;
import com.mypurecloud.sdk.v2.ApiDateFormat;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.DetailLevel;
import com.mypurecloud.sdk.v2.LocalDateDeserializer;
import com.mypurecloud.sdk.v2.LocalDateSerializer;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.PureCloudRegionHosts;
import com.mypurecloud.sdk.v2.StringUtil;
import com.mypurecloud.sdk.v2.auth.ApiKeyAuth;
import com.mypurecloud.sdk.v2.auth.Authentication;
import com.mypurecloud.sdk.v2.auth.OAuth;
import com.mypurecloud.sdk.v2.connector.ApiClientConnector;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorLoader;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorProperties;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorProperty;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorRequest;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorResponse;
import com.mypurecloud.sdk.v2.extensions.AuthResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;

public class ApiClient
implements AutoCloseable {
    private static final String DEFAULT_BASE_PATH = "https://api.mypurecloud.com";
    private static final String DEFAULT_USER_AGENT = "PureCloud SDK/java";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private final Map<String, String> defaultHeaderMap;
    private final String basePath;
    private final Boolean shouldThrowErrors;
    private final DateFormat dateFormat;
    private final ObjectMapper objectMapper;
    private final ConnectorProperties properties;
    private final Map<String, Authentication> authentications;
    private final ApiClientConnector connector;

    private static Map<String, Authentication> buildAuthentications() {
        HashMap<String, Authentication> authentications = new HashMap<String, Authentication>();
        authentications.put("PureCloud OAuth", new OAuth());
        authentications.put("Guest Chat JWT", new ApiKeyAuth("header", "Authorization"));
        return Collections.unmodifiableMap(authentications);
    }

    public ApiClient() {
        this(Builder.standard());
    }

    private ApiClient(Builder builder) {
        String basePath = builder.basePath;
        if (basePath == null) {
            basePath = DEFAULT_BASE_PATH;
        }
        this.basePath = basePath;
        this.defaultHeaderMap = new HashMap<String, String>(builder.defaultHeaderMap);
        this.properties = builder.properties.copy();
        this.shouldThrowErrors = builder.shouldThrowErrors == null ? true : builder.shouldThrowErrors;
        DateFormat dateFormat = builder.dateFormat;
        if (dateFormat == null) {
            dateFormat = this.buildDateFormat();
        }
        this.dateFormat = dateFormat;
        ObjectMapper objectMapper = builder.objectMapper;
        if (objectMapper == null) {
            objectMapper = ApiClient.buildObjectMapper(dateFormat);
        }
        this.objectMapper = objectMapper;
        this.authentications = this.buildAuthentications(builder);
        this.connector = this.buildHttpConnector(builder);
    }

    @Override
    public void close() throws Exception {
        this.connector.close();
    }

    public static ObjectMapper buildObjectMapper(DateFormat dateFormat) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        objectMapper.registerModule((Module)new JodaModule());
        objectMapper.setDateFormat(dateFormat);
        SimpleModule localDateModule = new SimpleModule();
        localDateModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer());
        localDateModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer());
        objectMapper.registerModule((Module)localDateModule);
        return objectMapper;
    }

    private DateFormat buildDateFormat() {
        return new ApiDateFormat();
    }

    private Map<String, Authentication> buildAuthentications(Builder builder) {
        Map<String, Authentication> authentications = ApiClient.buildAuthentications();
        String accessToken = builder.accessToken;
        for (Authentication authentication : authentications.values()) {
            if (!(authentication instanceof OAuth) || accessToken == null) continue;
            ((OAuth)authentication).setAccessToken(accessToken);
        }
        return authentications;
    }

    private ApiClientConnector buildHttpConnector(Builder builder) {
        return ApiClientConnectorLoader.load(this.properties);
    }

    public boolean getShouldThrowErrors() {
        return this.shouldThrowErrors;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiResponse<AuthResponse> authorizeClientCredentials(String clientId, String clientSecret) throws IOException, ApiException {
        String encodedAuth = DatatypeConverter.printBase64Binary((byte[])(clientId + ":" + clientSecret).getBytes("UTF-8"));
        ApiRequest<Void> request = ApiRequestBuilder.create("POST", "/oauth/token").withCustomHeader("Authorization", "Basic " + encodedAuth).withCustomHeader("Content-Type", "application/x-www-form-urlencoded").withFormParameter("grant_type", "client_credentials").build();
        ApiResponse<AuthResponse> response = this.getAPIResponse(request, new TypeReference<AuthResponse>(){}, true);
        this.setAccessToken(response.getBody().getAccess_token());
        return response;
    }

    public ApiResponse<AuthResponse> authorizeSaml2Bearer(String clientId, String clientSecret, String orgName, String assertion) throws IOException, ApiException {
        String encodedAuth = DatatypeConverter.printBase64Binary((byte[])(clientId + ":" + clientSecret).getBytes("UTF-8"));
        ApiRequest<Void> request = ApiRequestBuilder.create("POST", "/oauth/token").withCustomHeader("Authorization", "Basic " + encodedAuth).withCustomHeader("Content-Type", "application/x-www-form-urlencoded").withFormParameter("grant_type", "urn:ietf:params:oauth:grant-type:saml2-bearer").withFormParameter("orgName", orgName).withFormParameter("assertion", assertion).build();
        ApiResponse<AuthResponse> response = this.getAPIResponse(request, new TypeReference<AuthResponse>(){}, true);
        this.setAccessToken(response.getBody().getAccess_token());
        return response;
    }

    public int getConnectTimeout() {
        return this.properties.getProperty(ApiClientConnectorProperty.CONNECTION_TIMEOUT, Integer.class, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseDate(String str) {
        try {
            DateFormat dateFormat = this.dateFormat;
            synchronized (dateFormat) {
                return this.dateFormat.parse(str);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatDate(Date date) {
        DateFormat dateFormat = this.dateFormat;
        synchronized (dateFormat) {
            return this.dateFormat.format(date);
        }
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        Collection valueCollection = null;
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = collectionFormat = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if (collectionFormat.equals("multi")) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if (collectionFormat.equals("csv")) {
            delimiter = ",";
        } else if (collectionFormat.equals("ssv")) {
            delimiter = " ";
        } else if (collectionFormat.equals("tsv")) {
            delimiter = "\t";
        } else if (collectionFormat.equals("pipes")) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public boolean isJsonMime(String mime) {
        return mime != null && mime.matches("(?i)application\\/json(;.*)?");
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public String serialize(Object obj) throws IOException {
        return this.objectMapper.writeValueAsString(obj);
    }

    public <T> T deserialize(String obj, Class<T> type) throws IOException {
        return (T)this.objectMapper.readValue(obj, type);
    }

    private String buildUrl(String path, Map<String, String> pathParams, List<Pair> queryParams, boolean isAuthRequest) {
        path = path.replaceAll("\\{format\\}", "json");
        if (pathParams != null && !pathParams.isEmpty()) {
            for (Map.Entry<String, String> entry : pathParams.entrySet()) {
                path = path.replaceAll("\\{" + entry.getKey() + "\\}", entry.getValue());
            }
        }
        StringBuilder url = new StringBuilder();
        if (isAuthRequest) {
            String[] parts = this.basePath.split("\\.", 2);
            url.append("https://login.").append(parts[1]).append(path);
        } else {
            url.append(this.basePath).append(path);
        }
        if (queryParams != null && !queryParams.isEmpty()) {
            String prefix = path.contains("?") ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                String value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
            }
        }
        return url.toString();
    }

    private ApiClientConnectorRequest prepareConnectorRequest(final ApiRequest<?> request, boolean isAuthRequest) throws IOException {
        Map<String, String> customHeaders;
        Map<String, String> headerParams;
        String contentType;
        String path = request.getPath();
        ArrayList<Pair> queryParams = new ArrayList<Pair>(request.getQueryParams());
        final HashMap<String, String> headers = new HashMap<String, String>();
        String accept = request.getAccepts();
        if (accept != null && !accept.isEmpty()) {
            headers.put("Accept", accept);
        }
        if ((contentType = request.getContentType()) != null && !contentType.isEmpty()) {
            headers.put("Content-Type", contentType);
        }
        if ((headerParams = request.getHeaderParams()) != null && !headerParams.isEmpty()) {
            for (Map.Entry<String, String> entry : headerParams.entrySet()) {
                headers.put(entry.getKey(), entry.getValue());
            }
        }
        if ((customHeaders = request.getCustomHeaders()) != null && !customHeaders.isEmpty()) {
            for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
                headers.put(entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry<String, String> entry : this.defaultHeaderMap.entrySet()) {
            if (headers.containsKey(entry.getKey())) continue;
            headers.put(entry.getKey(), entry.getValue());
        }
        this.updateParamsForAuth(request.getAuthNames(), queryParams, headers);
        final String string = this.buildUrl(path, request.getPathParams(), queryParams, isAuthRequest);
        Object obj = request.getBody();
        Map<String, Object> formParams = request.getFormParams();
        if (obj != null && !formParams.isEmpty()) {
            throw new IllegalStateException("Request cannot have both form and body parameters.");
        }
        final String serializedBody = obj != null ? this.serialize(obj) : (formParams != null ? this.getXWWWFormUrlencodedParams(formParams) : null);
        return new ApiClientConnectorRequest(){

            @Override
            public String getMethod() {
                return request.getMethod();
            }

            @Override
            public String getUrl() {
                return string;
            }

            @Override
            public Map<String, String> getHeaders() {
                return headers;
            }

            @Override
            public boolean hasBody() {
                return serializedBody != null;
            }

            @Override
            public String readBody() throws IOException {
                return serializedBody;
            }

            @Override
            public InputStream getBody() throws IOException {
                return serializedBody != null ? new ByteArrayInputStream(serializedBody.getBytes("UTF8")) : null;
            }
        };
    }

    private <T> ApiResponse<T> interpretConnectorResponse(ApiClientConnectorResponse response, TypeReference<T> returnType) throws ApiException, IOException {
        int statusCode = response.getStatusCode();
        String reasonPhrase = response.getStatusReasonPhrase();
        Map<String, String> headers = response.getHeaders();
        if (statusCode >= 200 && statusCode < 300) {
            String body = null;
            Object entity = null;
            if (statusCode != 204 && returnType != null && returnType.getType() != Void.class && response.hasBody()) {
                body = response.readBody();
                if (body != null && body.length() > 0 && returnType.getType() == String.class) {
                    entity = body;
                } else if (body != null && body.length() > 0) {
                    entity = this.objectMapper.readValue(body, returnType);
                }
            }
            return new ApiResponseWrapper<Object>(statusCode, reasonPhrase, headers, body, entity);
        }
        String message = "error";
        String body = response.readBody();
        throw new ApiException(statusCode, message, headers, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ApiResponse<T> getAPIResponse(ApiRequest<?> request, TypeReference<T> returnType, boolean isAuthRequest) throws IOException, ApiException {
        ApiClientConnectorRequest connectorRequest = this.prepareConnectorRequest(request, isAuthRequest);
        ApiClientConnectorResponse connectorResponse = null;
        try {
            connectorResponse = this.connector.invoke(connectorRequest);
            ApiResponse<T> apiResponse = this.interpretConnectorResponse(connectorResponse, returnType);
            return apiResponse;
        }
        finally {
            if (connectorResponse != null) {
                try {
                    connectorResponse.close();
                }
                catch (Throwable exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
    }

    private <T> Future<ApiResponse<T>> getAPIResponseAsync(ApiRequest<?> request, final TypeReference<T> returnType, final AsyncApiCallback<ApiResponse<T>> callback) {
        final SettableFuture future = SettableFuture.create();
        try {
            ApiClientConnectorRequest connectorRequest = this.prepareConnectorRequest(request, false);
            this.connector.invokeAsync(connectorRequest, new AsyncApiCallback<ApiClientConnectorResponse>(){

                @Override
                public void onCompleted(ApiClientConnectorResponse connectorResponse) {
                    try {
                        ApiResponse response;
                        try {
                            response = ApiClient.this.interpretConnectorResponse(connectorResponse, returnType);
                        }
                        finally {
                            connectorResponse.close();
                        }
                        ApiClient.this.notifySuccess(future, callback, response);
                    }
                    catch (Throwable exception) {
                        ApiClient.this.notifyFailure(future, callback, exception);
                    }
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiClient.this.notifyFailure(future, callback, exception);
                }
            });
        }
        catch (Throwable exception) {
            this.notifyFailure(future, callback, exception);
        }
        return future;
    }

    private <T> void notifySuccess(SettableFuture<T> future, AsyncApiCallback<T> callback, T result) {
        if (callback != null) {
            try {
                callback.onCompleted(result);
                future.set(result);
            }
            catch (Throwable exception) {
                future.setException(exception);
            }
        } else {
            future.set(result);
        }
    }

    private <T> void notifyFailure(SettableFuture<T> future, AsyncApiCallback<T> callback, Throwable exception) {
        if (callback != null) {
            try {
                callback.onFailed(exception);
                future.setException(exception);
            }
            catch (Throwable callbackException) {
                future.setException(callbackException);
            }
        } else {
            future.setException(exception);
        }
    }

    public <T> ApiResponse<T> invoke(ApiRequest<?> request, TypeReference<T> returnType) throws ApiException, IOException {
        return this.getAPIResponse(request, returnType, false);
    }

    public <T> Future<ApiResponse<T>> invokeAsync(ApiRequest<?> request, TypeReference<T> returnType, AsyncApiCallback<ApiResponse<T>> callback) {
        SettableFuture future = SettableFuture.create();
        this.getAPIResponseAsync(request, returnType, callback);
        return future;
    }

    private void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams);
        }
    }

    private String getXWWWFormUrlencodedParams(Map<String, Object> formParams) {
        StringBuilder formParamBuilder = new StringBuilder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            String valueStr = this.parameterToString(param.getValue());
            try {
                formParamBuilder.append(URLEncoder.encode(param.getKey(), "utf8")).append("=").append(URLEncoder.encode(valueStr, "utf8"));
                formParamBuilder.append("&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        String encodedFormParams = formParamBuilder.toString();
        if (encodedFormParams.endsWith("&")) {
            encodedFormParams = encodedFormParams.substring(0, encodedFormParams.length() - 1);
        }
        return encodedFormParams;
    }

    private static class ApiResponseWrapper<T>
    implements ApiResponse<T> {
        private final int statusCode;
        private final String reasonPhrase;
        private final Map<String, String> headers;
        private final String body;
        private final T entity;

        public ApiResponseWrapper(int statusCode, String reasonPhrase, Map<String, String> headers, String body, T entity) {
            this.statusCode = statusCode;
            this.reasonPhrase = reasonPhrase;
            TreeMap<String, String> caseInsensitiveMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            caseInsensitiveMap.putAll(headers);
            this.headers = Collections.unmodifiableMap(caseInsensitiveMap);
            this.body = body;
            this.entity = entity;
        }

        @Override
        public Exception getException() {
            return null;
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }

        @Override
        public String getStatusReasonPhrase() {
            return this.reasonPhrase;
        }

        @Override
        public boolean hasRawBody() {
            return this.body != null && !this.body.isEmpty();
        }

        @Override
        public String getRawBody() {
            return this.body;
        }

        @Override
        public T getBody() {
            return this.entity;
        }

        @Override
        public Map<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public String getHeader(String key) {
            return this.headers.get(key);
        }

        @Override
        public String getCorrelationId() {
            return this.headers.get("ININ-Correlation-ID");
        }

        @Override
        public void close() throws Exception {
        }
    }

    private static class ApiRequestWrapper<T>
    implements ApiRequest<T> {
        private final String path;
        private final String method;
        private final List<Pair> queryParams;
        private final T body;
        private final Map<String, String> headerParams;
        private final Map<String, Object> formParams;
        private final String accept;
        private final String contentType;
        private final String[] authNames;

        public ApiRequestWrapper(String path, String method, List<Pair> queryParams, T body, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames) {
            this.path = path;
            this.method = method;
            this.queryParams = queryParams;
            this.body = body;
            this.headerParams = headerParams;
            this.formParams = formParams;
            this.accept = accept;
            this.contentType = contentType;
            this.authNames = authNames;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getMethod() {
            return this.method;
        }

        @Override
        public Map<String, String> getPathParams() {
            return Collections.emptyMap();
        }

        @Override
        public List<Pair> getQueryParams() {
            return this.queryParams;
        }

        @Override
        public Map<String, Object> getFormParams() {
            return this.formParams;
        }

        @Override
        public Map<String, String> getHeaderParams() {
            return this.headerParams;
        }

        @Override
        public Map<String, String> getCustomHeaders() {
            return Collections.emptyMap();
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public String getAccepts() {
            return this.accept;
        }

        @Override
        public T getBody() {
            return this.body;
        }

        @Override
        public String[] getAuthNames() {
            return this.authNames;
        }
    }

    private static class ConnectorProperties
    implements ApiClientConnectorProperties {
        private final Map<String, Object> properties = new HashMap<String, Object>();

        public ConnectorProperties() {
        }

        public ConnectorProperties(Map<String, Object> properties) {
            if (properties != null) {
                this.properties.putAll(properties);
            }
        }

        @Override
        public <T> T getProperty(String key, Class<T> propertyClass, T defaultValue) {
            Object value = this.properties.get(key);
            if (propertyClass.isInstance(value)) {
                return propertyClass.cast(value);
            }
            return defaultValue;
        }

        public void setProperty(String key, Object value) {
            if (key != null) {
                if (value != null) {
                    this.properties.put(key, value);
                } else {
                    this.properties.remove(key);
                }
            }
        }

        public ConnectorProperties copy() {
            return new ConnectorProperties(this.properties);
        }
    }

    public static class Builder {
        private final Map<String, String> defaultHeaderMap = new HashMap<String, String>();
        private final ConnectorProperties properties;
        private String accessToken;
        private ObjectMapper objectMapper;
        private DateFormat dateFormat;
        private String basePath;
        private Boolean shouldThrowErrors = true;

        public static Builder standard() {
            return new Builder(new ConnectorProperties());
        }

        public static Builder from(ApiClient client) {
            if (client == null) {
                throw new NullPointerException();
            }
            Builder builder = new Builder(client.properties);
            builder.defaultHeaderMap.putAll(client.defaultHeaderMap);
            for (Authentication authentication : client.authentications.values()) {
                if (!(authentication instanceof OAuth)) continue;
                builder.accessToken = ((OAuth)authentication).getAccessToken();
            }
            builder.dateFormat = client.dateFormat;
            builder.objectMapper = client.objectMapper;
            builder.basePath = client.basePath;
            builder.shouldThrowErrors = client.shouldThrowErrors;
            return builder;
        }

        public static ApiClient defaultClient() {
            return Builder.standard().build();
        }

        private Builder(ConnectorProperties properties) {
            this.properties = properties != null ? properties.copy() : new ConnectorProperties();
            this.withUserAgent(ApiClient.DEFAULT_USER_AGENT);
            this.withDefaultHeader("purecloud-sdk", "68.0.0");
        }

        public Builder withDefaultHeader(String header, String value) {
            this.defaultHeaderMap.put(header, value);
            return this;
        }

        public Builder withAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder withUserAgent(String userAgent) {
            return this.withDefaultHeader(ApiClient.USER_AGENT_HEADER, userAgent);
        }

        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder withDateFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder withBasePath(PureCloudRegionHosts region) {
            this.basePath = region.getApiHost();
            return this;
        }

        public Builder withConnectionTimeout(int connectionTimeout) {
            this.properties.setProperty(ApiClientConnectorProperty.CONNECTION_TIMEOUT, connectionTimeout);
            return this;
        }

        public Builder withShouldThrowErrors(boolean shouldThrowErrors) {
            this.shouldThrowErrors = shouldThrowErrors;
            return this;
        }

        public Builder withDetailLevel(DetailLevel detailLevel) {
            this.properties.setProperty(ApiClientConnectorProperty.DETAIL_LEVEL, (Object)detailLevel);
            return this;
        }

        public Builder withProxy(Proxy proxy) {
            this.properties.setProperty(ApiClientConnectorProperty.PROXY, proxy);
            return this;
        }

        public Builder withProperty(String name, Object value) {
            this.properties.setProperty(name, value);
            return this;
        }

        public ApiClient build() {
            return new ApiClient(this);
        }
    }
}

