/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteLocationRequest;
import com.mypurecloud.sdk.v2.api.request.GetLocationRequest;
import com.mypurecloud.sdk.v2.api.request.GetLocationSublocationsRequest;
import com.mypurecloud.sdk.v2.api.request.GetLocationsRequest;
import com.mypurecloud.sdk.v2.api.request.GetLocationsSearchRequest;
import com.mypurecloud.sdk.v2.api.request.PatchLocationRequest;
import com.mypurecloud.sdk.v2.api.request.PostLocationsRequest;
import com.mypurecloud.sdk.v2.api.request.PostLocationsSearchRequest;
import com.mypurecloud.sdk.v2.model.LocationDefinition;
import com.mypurecloud.sdk.v2.model.LocationEntityListing;
import com.mypurecloud.sdk.v2.model.LocationSearchRequest;
import com.mypurecloud.sdk.v2.model.LocationUpdateDefinition;
import com.mypurecloud.sdk.v2.model.LocationsSearchResponse;
import java.util.concurrent.Future;

public class LocationsApiAsync {
    private final ApiClient pcapiClient;

    public LocationsApiAsync() {
        this(Configuration.getDefaultApiClient());
    }

    public LocationsApiAsync(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Future<Void> deleteLocationAsync(DeleteLocationRequest request, final AsyncApiCallback<Void> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), null, new AsyncApiCallback<ApiResponse<Void>>(){

                @Override
                public void onCompleted(ApiResponse<Void> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LocationsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<Void>> deleteLocationAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<Void>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, null, new AsyncApiCallback<ApiResponse<Void>>(){

                @Override
                public void onCompleted(ApiResponse<Void> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<LocationDefinition> getLocationAsync(GetLocationRequest request, final AsyncApiCallback<LocationDefinition> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<LocationDefinition>(){}, new AsyncApiCallback<ApiResponse<LocationDefinition>>(){

                @Override
                public void onCompleted(ApiResponse<LocationDefinition> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LocationsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<LocationDefinition>> getLocationAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<LocationDefinition>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<LocationDefinition>(){}, new AsyncApiCallback<ApiResponse<LocationDefinition>>(){

                @Override
                public void onCompleted(ApiResponse<LocationDefinition> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<LocationEntityListing> getLocationSublocationsAsync(GetLocationSublocationsRequest request, final AsyncApiCallback<LocationEntityListing> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<LocationEntityListing>(){}, new AsyncApiCallback<ApiResponse<LocationEntityListing>>(){

                @Override
                public void onCompleted(ApiResponse<LocationEntityListing> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LocationsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<LocationEntityListing>> getLocationSublocationsAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<LocationEntityListing>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<LocationEntityListing>(){}, new AsyncApiCallback<ApiResponse<LocationEntityListing>>(){

                @Override
                public void onCompleted(ApiResponse<LocationEntityListing> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<LocationEntityListing> getLocationsAsync(GetLocationsRequest request, final AsyncApiCallback<LocationEntityListing> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<LocationEntityListing>(){}, new AsyncApiCallback<ApiResponse<LocationEntityListing>>(){

                @Override
                public void onCompleted(ApiResponse<LocationEntityListing> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LocationsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<LocationEntityListing>> getLocationsAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<LocationEntityListing>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<LocationEntityListing>(){}, new AsyncApiCallback<ApiResponse<LocationEntityListing>>(){

                @Override
                public void onCompleted(ApiResponse<LocationEntityListing> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<LocationsSearchResponse> getLocationsSearchAsync(GetLocationsSearchRequest request, final AsyncApiCallback<LocationsSearchResponse> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<LocationsSearchResponse>(){}, new AsyncApiCallback<ApiResponse<LocationsSearchResponse>>(){

                @Override
                public void onCompleted(ApiResponse<LocationsSearchResponse> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LocationsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<LocationsSearchResponse>> getLocationsSearchAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<LocationsSearchResponse>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<LocationsSearchResponse>(){}, new AsyncApiCallback<ApiResponse<LocationsSearchResponse>>(){

                @Override
                public void onCompleted(ApiResponse<LocationsSearchResponse> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<LocationDefinition> patchLocationAsync(PatchLocationRequest request, final AsyncApiCallback<LocationDefinition> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<LocationDefinition>(){}, new AsyncApiCallback<ApiResponse<LocationDefinition>>(){

                @Override
                public void onCompleted(ApiResponse<LocationDefinition> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LocationsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<LocationDefinition>> patchLocationAsync(ApiRequest<LocationUpdateDefinition> request, final AsyncApiCallback<ApiResponse<LocationDefinition>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<LocationDefinition>(){}, new AsyncApiCallback<ApiResponse<LocationDefinition>>(){

                @Override
                public void onCompleted(ApiResponse<LocationDefinition> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<LocationDefinition> postLocationsAsync(PostLocationsRequest request, final AsyncApiCallback<LocationDefinition> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<LocationDefinition>(){}, new AsyncApiCallback<ApiResponse<LocationDefinition>>(){

                @Override
                public void onCompleted(ApiResponse<LocationDefinition> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LocationsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<LocationDefinition>> postLocationsAsync(ApiRequest<LocationDefinition> request, final AsyncApiCallback<ApiResponse<LocationDefinition>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<LocationDefinition>(){}, new AsyncApiCallback<ApiResponse<LocationDefinition>>(){

                @Override
                public void onCompleted(ApiResponse<LocationDefinition> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<LocationsSearchResponse> postLocationsSearchAsync(PostLocationsSearchRequest request, final AsyncApiCallback<LocationsSearchResponse> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<LocationsSearchResponse>(){}, new AsyncApiCallback<ApiResponse<LocationsSearchResponse>>(){

                @Override
                public void onCompleted(ApiResponse<LocationsSearchResponse> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LocationsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<LocationsSearchResponse>> postLocationsSearchAsync(ApiRequest<LocationSearchRequest> request, final AsyncApiCallback<ApiResponse<LocationsSearchResponse>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<LocationsSearchResponse>(){}, new AsyncApiCallback<ApiResponse<LocationsSearchResponse>>(){

                @Override
                public void onCompleted(ApiResponse<LocationsSearchResponse> response) {
                    LocationsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LocationsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LocationsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    private <T> void notifySuccess(SettableFuture<T> future, AsyncApiCallback<T> callback, T result) {
        if (callback != null) {
            try {
                callback.onCompleted(result);
                future.set(result);
            }
            catch (Throwable exception) {
                future.setException(exception);
            }
        } else {
            future.set(result);
        }
    }

    private <T> void notifyFailure(SettableFuture<T> future, AsyncApiCallback<T> callback, Throwable exception) {
        if (callback != null) {
            try {
                callback.onFailed(exception);
                future.setException(exception);
            }
            catch (Throwable callbackException) {
                future.setException(callbackException);
            }
        } else {
            future.setException(exception);
        }
    }
}

