/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.RecordingJobsQuery;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class RecordingJob
implements Serializable {
    private String id = null;
    private String name = null;
    private StateEnum state = null;
    private RecordingJobsQuery recordingJobsQuery = null;
    private Date dateCreated = null;
    private Integer totalConversations = null;
    private Integer totalRecordings = null;
    private Integer totalProcessedRecordings = null;
    private Integer percentProgress = null;
    private String errorMessage = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public RecordingJob name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RecordingJob state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The current state of the job.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public RecordingJob recordingJobsQuery(RecordingJobsQuery recordingJobsQuery) {
        this.recordingJobsQuery = recordingJobsQuery;
        return this;
    }

    @ApiModelProperty(example="null", value="Original query of the job.")
    @JsonProperty(value="recordingJobsQuery")
    public RecordingJobsQuery getRecordingJobsQuery() {
        return this.recordingJobsQuery;
    }

    public void setRecordingJobsQuery(RecordingJobsQuery recordingJobsQuery) {
        this.recordingJobsQuery = recordingJobsQuery;
    }

    @ApiModelProperty(example="null", value="Date when the job was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Total number of conversations affected.")
    @JsonProperty(value="totalConversations")
    public Integer getTotalConversations() {
        return this.totalConversations;
    }

    @ApiModelProperty(example="null", value="Total number of recordings affected.")
    @JsonProperty(value="totalRecordings")
    public Integer getTotalRecordings() {
        return this.totalRecordings;
    }

    @ApiModelProperty(example="null", value="Total number of recordings have been processed.")
    @JsonProperty(value="totalProcessedRecordings")
    public Integer getTotalProcessedRecordings() {
        return this.totalProcessedRecordings;
    }

    @ApiModelProperty(example="null", value="Progress in percentage based on the number of recordings")
    @JsonProperty(value="percentProgress")
    public Integer getPercentProgress() {
        return this.percentProgress;
    }

    @ApiModelProperty(example="null", value="Error occurred during the job execution")
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordingJob recordingJob = (RecordingJob)o;
        return Objects.equals(this.id, recordingJob.id) && Objects.equals(this.name, recordingJob.name) && Objects.equals((Object)this.state, (Object)recordingJob.state) && Objects.equals(this.recordingJobsQuery, recordingJob.recordingJobsQuery) && Objects.equals(this.dateCreated, recordingJob.dateCreated) && Objects.equals(this.totalConversations, recordingJob.totalConversations) && Objects.equals(this.totalRecordings, recordingJob.totalRecordings) && Objects.equals(this.totalProcessedRecordings, recordingJob.totalProcessedRecordings) && Objects.equals(this.percentProgress, recordingJob.percentProgress) && Objects.equals(this.errorMessage, recordingJob.errorMessage) && Objects.equals(this.selfUri, recordingJob.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.state, this.recordingJobsQuery, this.dateCreated, this.totalConversations, this.totalRecordings, this.totalProcessedRecordings, this.percentProgress, this.errorMessage, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecordingJob {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    recordingJobsQuery: ").append(this.toIndentedString(this.recordingJobsQuery)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    totalConversations: ").append(this.toIndentedString(this.totalConversations)).append("\n");
        sb.append("    totalRecordings: ").append(this.toIndentedString(this.totalRecordings)).append("\n");
        sb.append("    totalProcessedRecordings: ").append(this.toIndentedString(this.totalProcessedRecordings)).append("\n");
        sb.append("    percentProgress: ").append(this.toIndentedString(this.percentProgress)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FULFILLED("FULFILLED"),
        PENDING("PENDING"),
        READY("READY"),
        PROCESSING("PROCESSING"),
        CANCELLED("CANCELLED"),
        FAILED("FAILED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

